create table if not exists HEADEND
    (	FILENAME VARCHAR2(4000),
    HEADEND_ID NVARCHAR2(100),
    COMMUNITY_NAME NVARCHAR2(200),
    COUNTY_NAME NVARCHAR2(200),
    COUNTY_SIZE NVARCHAR2(1),
    ST_COUNTY_CODE NVARCHAR2(100),
    STATE NVARCHAR2(64),
    ZIPCODE NVARCHAR2(100),
    DMA_CODE NVARCHAR2(100),
    DMA_NAME NVARCHAR2(300),
    MSO_CODE NUMBER,
    DMA_RANK NVARCHAR2(100),
    HEADEND_NAME NVARCHAR2(1000),
    HEADEND_LOCATION NVARCHAR2(100),
    MSO_NAME NVARCHAR2(1000),
    TIME_ZONE NVARCHAR2(100),
    HEADEND_TYPE NVARCHAR2(100),
    HEADEND_COUNTRY NVARCHAR2(100),
    CREATED_BY NVARCHAR2(50),
    UPDATED_BY NVARCHAR2(50),
    PROVIDER_ID NUMBER(19) NOT NULL,
    CREATE_DATE TIMESTAMP,
    UPDATE_DATE TIMESTAMP, 
	CONSTRAINT PK_HEADEND PRIMARY KEY ( HEADEND_ID, PROVIDER_ID ));
	
create table if not exists HEADEND_GENERIC
       (	FILENAME VARCHAR2(4000),
         HEADEND_ID NVARCHAR2(100) NOT NULL, 
         ASSET NVARCHAR2(50) NULL, 
         NAME NVARCHAR2(200) NULL, 
         VALUE NVARCHAR2(2000) NULL,
         CREATED_BY NVARCHAR2(50),
         UPDATED_BY NVARCHAR2(50),
         PROVIDER_ID NUMBER(19) NOT NULL,
         CREATE_DATE TIMESTAMP,
         UPDATE_DATE TIMESTAMP, 
         CONSTRAINT HEADEND_GENERIC_PK   PRIMARY KEY (HEADEND_ID, ASSET, NAME, PROVIDER_ID)
       );
       
create table if not exists STATION
    (	FILENAME VARCHAR2(4000),
    STATION_ID NVARCHAR2(100),
    TIME_ZONE NVARCHAR2(100),
    STATION_NAME NVARCHAR2(200),
    CALL_SIGN NVARCHAR2(100),
    AFFILIATION NVARCHAR2(100),
    CITY NVARCHAR2(100),
    STATE NVARCHAR2(100),
    ZIPCODE NVARCHAR2(100),
    COUNTRY NVARCHAR2(100),
    DMA_NAME NVARCHAR2(200),
    DMA_NUMBER NUMBER(12),
    FCC_CHANNEL_NUM NUMBER(12),
    PROGRAM_GENRE NVARCHAR2(200),
    USER_DATA1 NVARCHAR2(1000),
    USER_DATA2 NVARCHAR2(1000),
    USER_DATA3 NVARCHAR2(1000),
    USER_DATA4 NVARCHAR2(1000),
    USER_DATA5 NVARCHAR2(1000),
    USER_DATA6 NVARCHAR2(1000),
    USER_DATA7 NVARCHAR2(1000),
    USER_DATA8 NVARCHAR2(1000),
    USER_DATA9 NVARCHAR2(1000),
    USER_DATA10 NVARCHAR2(1000),
    CREATED_BY NVARCHAR2(50),
    UPDATED_BY NVARCHAR2(50),
    PROVIDER_ID NUMBER(19) NOT NULL,
    CREATE_DATE TIMESTAMP,
    UPDATE_DATE TIMESTAMP, 
    CONSTRAINT PK_STATION PRIMARY KEY ( STATION_ID , PROVIDER_ID)
     );
     
create table if not exists STATION_GENERIC
       (	FILENAME VARCHAR2(4000),
         STATION_ID NVARCHAR2(100) NOT NULL, 
         ASSET NVARCHAR2(50) NULL, 
         NAME NVARCHAR2(200) NULL, 
         VALUE NVARCHAR2(2000) NULL,
         CREATED_BY NVARCHAR2(50),
         UPDATED_BY NVARCHAR2(50),
         PROVIDER_ID NUMBER(19) NOT NULL,
         CREATE_DATE TIMESTAMP,
         UPDATE_DATE TIMESTAMP, 
         CONSTRAINT STATION_GENERIC_PK   PRIMARY KEY (STATION_ID, ASSET, NAME, PROVIDER_ID)
       );
       
 create table if not exists LINEUP
    (	FILENAME VARCHAR2(4000),
    LINEUP_ID nvarchar2(20),
    STATION_ID nvarchar2(100),
    HEADEND_ID nvarchar2(100),
    DEVICE NVARCHAR2(2),
    TMS_CHANNEL NVARCHAR2(20),
    SERVICE_TIER NVARCHAR2(100),
    EFFECTIVE_DATE TIMESTAMP,
    EXPIRATION_DATE TIMESTAMP,
    CREATED_BY NVARCHAR2(50),
    UPDATED_BY NVARCHAR2(50),
    PROVIDER_ID NUMBER(19) NOT NULL,
    CREATE_DATE TIMESTAMP,
    UPDATE_DATE TIMESTAMP, 
     CONSTRAINT PK_LINEUP PRIMARY KEY ( LINEUP_ID, HEADEND_ID, STATION_ID , PROVIDER_ID),
     CONSTRAINT FK_LINEUP_STATION FOREIGN KEY (STATION_ID, PROVIDER_ID) REFERENCES STATION(STATION_ID, PROVIDER_ID),
     CONSTRAINT FK_HEADEND_LINEUP FOREIGN KEY ( HEADEND_ID, PROVIDER_ID) REFERENCES HEADEND(HEADEND_ID, PROVIDER_ID)
    );
    
 create table if not exists LINEUP_GENERIC
       (	FILENAME VARCHAR2(4000),
         LINEUP_ID NVARCHAR2(100) NOT NULL, 
		 HEADEND_ID NVARCHAR2(100) NOT NULL,
		 STATION_ID NVARCHAR2(100) NOT NULL,
         ASSET NVARCHAR2(50) NULL, 
         NAME NVARCHAR2(200) NULL, 
         VALUE NVARCHAR2(2000) NULL,
         CREATED_BY NVARCHAR2(50),
         UPDATED_BY NVARCHAR2(50),
         PROVIDER_ID NUMBER(19) NOT NULL,
         CREATE_DATE TIMESTAMP,
         UPDATE_DATE TIMESTAMP, 
         CONSTRAINT LINEUP_GENERIC_PK   PRIMARY KEY (LINEUP_ID, HEADEND_ID, STATION_ID, ASSET, NAME, PROVIDER_ID)
       );
       
 create table if not exists PROGRAM
    (	FILENAME VARCHAR2(4000),
      PROGRAM_ID NVARCHAR2(100),
      LANGUAGE NVARCHAR2(100),
      TITLE NVARCHAR2(1000),
      REDUCED_TITLE1 NVARCHAR2(1000),
      REDUCED_TITLE2 NVARCHAR2(1000),
      REDUCED_TITLE3 NVARCHAR2(1000),
      REDUCED_TITLE4 NVARCHAR2(1000),
      ALT_TITLE NVARCHAR2(1000),
      REDUCED_DESCRIPTION1 NVARCHAR2(1000),
      REDUCED_DESCRIPTION2 NVARCHAR2(1000),
      REDUCED_DESCRIPTION3 NVARCHAR2(1000),
      REDUCED_DESCRIPTION4 NVARCHAR2(1000),
      ADVISORY_DESC1 NVARCHAR2(100),
      ADVISORY_DESC2 NVARCHAR2(100),
      ADVISORY_DESC3 NVARCHAR2(100),
      ADVISORY_DESC4 NVARCHAR2(100),
      ADVISORY_DESC5 NVARCHAR2(100),
      ADVISORY_DESC6 NVARCHAR2(100),
      GENRE_DESC1 NVARCHAR2(100),
      GENRE_DESC2 NVARCHAR2(100),
      GENRE_DESC3 NVARCHAR2(100),
      GENRE_DESC4 NVARCHAR2(100),
      GENRE_DESC5 NVARCHAR2(100),
      GENRE_DESC6 NVARCHAR2(100),
      DESCRIPTION1 NVARCHAR2(2000),
      DESCRIPTION2 NVARCHAR2(2000),
      YEAR_PROGRAM NVARCHAR2(100),
      MPAA_RATING NVARCHAR2(1000),
      STAR_RATING NVARCHAR2(1000),
      RUN_TIME VARCHAR2(100),
      COLOR_CODE NVARCHAR2(100),
      PROGRAM_LANGUAGE NVARCHAR2(100),
      COUNTRY_OF_ORIGIN NVARCHAR2(100),
      MADE_FOR_TV NVARCHAR2(1),
      SOURCE_TYPE NVARCHAR2(100),
      SHOW_TYPE NVARCHAR2(200),
      HOLIDAY NVARCHAR2(100),
      SYNDICATE_EPISODE_NUM NVARCHAR2(100),
      ALT_SYNDICATE_EPI_NUM NVARCHAR2(100),
      EPISODE_TITLE NVARCHAR2(1000),
      NET_SYN_SOURCE NVARCHAR2(100),
      NET_SYN_TYPE NVARCHAR2(100),
      ORG_STUDIO NVARCHAR2(100),
      GAME_DATETIME TIMESTAMP,
      GAME_TIMEZONE NVARCHAR2(100),
      ORG_AIR_DATE TIMESTAMP,
      UNIQUE_ID NVARCHAR2(100),
      USER_DATA1 NVARCHAR2(1000),
      USER_DATA2 NVARCHAR2(1000),
      USER_DATA3 NVARCHAR2(1000),
      USER_DATA4 NVARCHAR2(1000),
      USER_DATA5 NVARCHAR2(1000),
      USER_DATA6 NVARCHAR2(1000),
      USER_DATA7 NVARCHAR2(1000),
      USER_DATA8 NVARCHAR2(1000),
      USER_DATA9 NVARCHAR2(1000),
      USER_DATA10 NVARCHAR2(1000),
      USER_DATA11 NVARCHAR2(1000),
      USER_DATA12 NVARCHAR2(1000),
      USER_DATA13 NVARCHAR2(1000),
      CREATED_BY NVARCHAR2(50),
      UPDATED_BY NVARCHAR2(50),
      PROVIDER_ID NUMBER(19) NOT NULL,
      CREATE_DATE TIMESTAMP,
      UPDATE_DATE TIMESTAMP, 
     CONSTRAINT PK_PROGRAM PRIMARY KEY ( PROGRAM_ID , PROVIDER_ID)
    );
    
 create table if not exists PROGRAM_CREDITS
       ( 
         FILENAME VARCHAR2(4000), 
         PROGRAM_ID NVARCHAR2(100) NOT NULL, 
         C_ID NVARCHAR2(50) NULL,
         SEQ NUMBER(10) NOT NULL,
         ROLE NVARCHAR2(200) NOT NULL,
         FIRST_NAME NVARCHAR2(200) NULL, 
         MIDDLE_NAME NVARCHAR2(200) NULL, 
         LAST_NAME NVARCHAR2(500) NULL,
         CREATED_BY NVARCHAR2(50),
         UPDATED_BY NVARCHAR2(50),
         PROVIDER_ID NUMBER(19) NOT NULL,
         CREATE_DATE TIMESTAMP,
         UPDATE_DATE TIMESTAMP, 
         CONSTRAINT U_PROGRAM_CREDITS   UNIQUE (PROGRAM_ID, SEQ, ROLE, PROVIDER_ID) 
       );
       
create table if not exists PROGRAM_CAST 
      ( 
	FILENAME VARCHAR2(4000), 
	PROGRAM_ID NVARCHAR2(100) NOT NULL, 
	C_ID NVARCHAR2(50) NULL,
	SEQ NUMBER(10) NOT NULL,
	ROLE NVARCHAR2(200) NOT NULL, 
	FIRST_NAME NVARCHAR2(200) NULL, 
	MIDDLE_NAME NVARCHAR2(200) NULL, 
	LAST_NAME NVARCHAR2(500) NULL, 
    CREATED_BY NVARCHAR2(50),
    UPDATED_BY NVARCHAR2(50),
    PROVIDER_ID NUMBER(19) NOT NULL,
    CREATE_DATE TIMESTAMP,
    UPDATE_DATE TIMESTAMP, 
	CONSTRAINT U_PROGRAM_CAST   UNIQUE (PROGRAM_ID, SEQ, ROLE, PROVIDER_ID)
      );
      
 create table if not exists PROGRAM_RATING
       (	FILENAME VARCHAR2(4000),
         PROGRAM_ID NVARCHAR2(100) NOT NULL, 
         AUTHORITY NVARCHAR2(200) NULL, 
         VALUE NVARCHAR2(2000) NULL,
         CREATED_BY NVARCHAR2(50),
         UPDATED_BY NVARCHAR2(50),
         PROVIDER_ID NUMBER(19) NOT NULL,
         CREATE_DATE TIMESTAMP,
         UPDATE_DATE TIMESTAMP, 
         CONSTRAINT PROGRAM_RATING   PRIMARY KEY (PROGRAM_ID, AUTHORITY, PROVIDER_ID)
        );
    
 create table if not exists PROGRAM_GENERIC
       (	FILENAME VARCHAR2(4000),
         PROGRAM_ID NVARCHAR2(100) NOT NULL, 
         ASSET NVARCHAR2(50) NULL, 
         NAME NVARCHAR2(200) NULL, 
         VALUE NVARCHAR2(2000) NULL,
         CREATED_BY NVARCHAR2(50),
         UPDATED_BY NVARCHAR2(50),
         PROVIDER_ID NUMBER(19) NOT NULL,
         CREATE_DATE TIMESTAMP,
         UPDATE_DATE TIMESTAMP, 
         CONSTRAINT PROGRAM_GENERIC_PK   PRIMARY KEY (PROGRAM_ID, ASSET, NAME, PROVIDER_ID)
       );

 create table if not exists PROGRAM_AUDIO_COMP
       (	FILENAME VARCHAR2(4000),
         PROGRAM_ID NVARCHAR2(100) NOT NULL, 
		 TLA NVARCHAR2(600) NOT NULL,
         TYPE NVARCHAR2(200) NOT NULL, 
         LANGUAGE NVARCHAR2(200) NOT NULL, 
		 ATTRIBUTE_TYPE NVARCHAR2(200) NULL,
         VALUE NVARCHAR2(200) NULL,
         CREATED_BY NVARCHAR2(50),
         UPDATED_BY NVARCHAR2(50),
         PROVIDER_ID NUMBER(19) NOT NULL,
         CREATE_DATE TIMESTAMP,
         UPDATE_DATE TIMESTAMP,          
         CONSTRAINT PROGRAM_AUDIO_COMP_PK   PRIMARY KEY (PROGRAM_ID, TLA, PROVIDER_ID)
       );

    
 create table if not exists PROGRAM_SUBTITLE_COMP
       (	FILENAME VARCHAR2(4000),
         PROGRAM_ID NVARCHAR2(100) NOT NULL, 
		 TLA NVARCHAR2(600) NOT NULL,
         TYPE NVARCHAR2(200) NULL, 
         LANGUAGE NVARCHAR2(200) NULL, 
		 ATTRIBUTE_TYPE NVARCHAR2(200) NULL,
         VALUE NVARCHAR2(200) NULL,
         CREATED_BY NVARCHAR2(50),
         UPDATED_BY NVARCHAR2(50),
         PROVIDER_ID NUMBER(19) NOT NULL,
         CREATE_DATE TIMESTAMP,
         UPDATE_DATE TIMESTAMP,          
         CONSTRAINT PROGRAM_SUBT_COMP_PK   PRIMARY KEY (PROGRAM_ID,TLA, PROVIDER_ID)
       );
       
 create table if not exists SCHEDULE
       (	FILENAME VARCHAR2(4000),
      SCHEDULE_ID NUMBER, 
      STATION_ID NVARCHAR2 (100) NOT NULL,
      PROGRAM_ID NVARCHAR2(100) NOT NULL,
      SCHEDULE_LANGUAGE NVARCHAR2(100) NOT NULL,
      START_TIME TIMESTAMP NOT NULL,
      END_TIME timestamp not null,
      DURATION NUMBER NOT NULL,
      PART_NUMBER NUMBER,
	  SERIES_ID NVARCHAR2(200),
      NO_OF_PARTS NUMBER,
      CC NVARCHAR2(1) NOT NULL,
      STEREO NVARCHAR2(1),
      REPEAT NVARCHAR2(1),
      LIVE_TAPE_DELAY NVARCHAR2(100),
      SUBTITLED NVARCHAR2(1),
      PREMIERE_FINALE NVARCHAR2(100),
      JOINED_IN_PROGRESS NVARCHAR2(1),
      CABLE_IN_CLASSROOM NVARCHAR2(1),
      TV_RATING NVARCHAR2(1000),
      SAP NVARCHAR2(1),
      BLACKOUT NVARCHAR2(1),
      SEX_RATING NVARCHAR2(1),
      VIOLENCE_RATING NVARCHAR2(1),
      LANGUAGE_RATING NVARCHAR2(1),
      DIALOG_RATING NVARCHAR2(1),
      FV_RATING NVARCHAR2(1),
      ENHANCED NVARCHAR2(1),
      THREE_D NVARCHAR2(1),
      LETTERBOX NVARCHAR2(1),
      HD_TV NVARCHAR2(1),
      DOLBY NVARCHAR2(100),
      DVS NVARCHAR2(1),
      USER_DATA1 NVARCHAR2(1000),
      USER_DATA2 NVARCHAR2(1000),
      USER_DATA3 NVARCHAR2(1000),
      USER_DATA4 NVARCHAR2(1000),
      USER_DATA5 NVARCHAR2(1000),
      USER_DATA6 NVARCHAR2(1000),
      USER_DATA7 NVARCHAR2(1000),
      USER_DATA8 NVARCHAR2(1000),
      USER_DATA9 NVARCHAR2(1000),
      USER_DATA10 NVARCHAR2(1000),
      USER_DATA11 NVARCHAR2(1000),
      REQUEST_RECORD VARCHAR2(1),
      CREATED_BY NVARCHAR2(50),
      UPDATED_BY NVARCHAR2(50),
      PROVIDER_ID NUMBER(19) NOT NULL,
      CREATE_DATE TIMESTAMP,
      UPDATE_DATE TIMESTAMP,       
     CONSTRAINT FK_STATION_SCHEDULE FOREIGN KEY ( STATION_ID, PROVIDER_ID) REFERENCES STATION ( STATION_ID, PROVIDER_ID),
     CONSTRAINT FK_SCHEDULE_PROGRAM FOREIGN KEY ( PROGRAM_ID, PROVIDER_ID) REFERENCES PROGRAM ( PROGRAM_ID, PROVIDER_ID)
       );
       
 create table if not exists SCHEDULE_EVENT_ID( FILENAME VARCHAR2(4000),
         PROGRAM_ID NVARCHAR2(100), 
         IDENTIFIER_TYPE NVARCHAR2(200) NULL, 
         VALUE NVARCHAR2(200) NULL,
         CREATED_BY NVARCHAR2(50),
         UPDATED_BY NVARCHAR2(50),
         PROVIDER_ID NUMBER(19) NOT NULL,
         CREATE_DATE TIMESTAMP,
         UPDATE_DATE TIMESTAMP,          
         CONSTRAINT SCHEDULE_EVENT_IDS_PK   PRIMARY KEY (PROGRAM_ID, IDENTIFIER_TYPE, PROVIDER_ID)
		);

    
 create table if not exists SCHEDULE_SERIES_ATTRIB(FILENAME VARCHAR2(4000),
         PROGRAM_ID NVARCHAR2(100), 
         ATTRIBUTE_TYPE NVARCHAR2(200) NULL, 
         VALUE NVARCHAR2(2000) NULL,
         CREATED_BY NVARCHAR2(50),
         UPDATED_BY NVARCHAR2(50),
         PROVIDER_ID NUMBER(19) NOT NULL,
         CREATE_DATE TIMESTAMP,
         UPDATE_DATE TIMESTAMP,          
         CONSTRAINT SCHEDULE_SERIES_ATTRIB_PK   PRIMARY KEY (PROGRAM_ID, ATTRIBUTE_TYPE, PROVIDER_ID)
		);
		
 create table if not exists SCHEDULE_GENERIC
       (	FILENAME VARCHAR2(4000),
         PROGRAM_ID NVARCHAR2(100), 
         ASSET NVARCHAR2(50) NULL, 
         NAME NVARCHAR2(200) NULL, 
         VALUE NVARCHAR2(2000) NULL,
         CREATED_BY NVARCHAR2(50),
         UPDATED_BY NVARCHAR2(50),
         PROVIDER_ID NUMBER(19) NOT NULL,
         CREATE_DATE TIMESTAMP,
         UPDATE_DATE TIMESTAMP,          
         CONSTRAINT SCHEDULE_GENERIC_PK   PRIMARY KEY (PROGRAM_ID, ASSET, NAME, PROVIDER_ID)
       );

-------------------------------ALTER1--------------------------------------------------
      
create table if not exists TEMP_SCHEDULE
       (        FILENAME VARCHAR2(4000),
      STATION_ID NVARCHAR2 (100) NOT NULL,
      PROGRAM_ID NVARCHAR2(100) NOT NULL,
      SCHEDULE_LANGUAGE NVARCHAR2(100) NOT NULL,
      START_TIME TIMESTAMP NOT NULL,
      DURATION NUMBER NOT NULL,
      PART_NUMBER NUMBER,
      SERIES_ID NVARCHAR2(100),
      NO_OF_PARTS NUMBER,
      CC NVARCHAR2(1) NOT NULL,
      STEREO NVARCHAR2(1),
      REPEAT NVARCHAR2(1),
      LIVE_TAPE_DELAY NVARCHAR2(100),
      SUBTITLED NVARCHAR2(1),
      PREMIERE_FINALE NVARCHAR2(100),
      JOINED_IN_PROGRESS NVARCHAR2(1),
      CABLE_IN_CLASSROOM NVARCHAR2(1),
      TV_RATING NVARCHAR2(1000),
      SAP NVARCHAR2(1),
      BLACKOUT NVARCHAR2(1),
      SEX_RATING NVARCHAR2(1),
      VIOLENCE_RATING NVARCHAR2(1),
      LANGUAGE_RATING NVARCHAR2(1),
      DIALOG_RATING NVARCHAR2(1),
      FV_RATING NVARCHAR2(1),
      ENHANCED NVARCHAR2(1),
      THREE_D NVARCHAR2(1),
      LETTERBOX NVARCHAR2(1),
      HD_TV NVARCHAR2(1),
      DOLBY NVARCHAR2(100),
      DVS NVARCHAR2(1),
      USER_DATA1 NVARCHAR2(1000),
      USER_DATA2 NVARCHAR2(1000),
      USER_DATA3 NVARCHAR2(1000),
      USER_DATA4 NVARCHAR2(1000),
      USER_DATA5 NVARCHAR2(1000),
      USER_DATA6 NVARCHAR2(1000),
      USER_DATA7 NVARCHAR2(1000),
      USER_DATA8 NVARCHAR2(1000),
      USER_DATA9 NVARCHAR2(1000),
      USER_DATA10 NVARCHAR2(1000),
      USER_DATA11 NVARCHAR2(1000),
      REQUEST_RECORD VARCHAR2(1),
      ISTIMEAPPROX NVARCHAR2(1),
      THREEDLEVEL NVARCHAR2(50),
      ASPECTRATIO NVARCHAR2(50),
      HDTVLEVEL NVARCHAR2(50),
      SYNDICATED NVARCHAR2(1),
      SCHEDULEID NVARCHAR2(50),
      CAPTIONTYPE NVARCHAR2(50),
      PROVIDER_ID NUMBER(19,0) NOT NULL
       );
       
create unique index SCHEDULE_STID_STIME on SCHEDULE(PROVIDER_ID, STATION_ID, PROGRAM_ID, START_TIME);
create unique index TMP_SCH_STID_TIME on TEMP_SCHEDULE(STATION_ID,START_TIME, PROVIDER_ID);
CREATE INDEX TEMP_SCHEDULE_PGM_ID ON TEMP_SCHEDULE(PROGRAM_ID);
create index I_SCHEDULE_SERIES_ATTRIB_VL on SCHEDULE_SERIES_ATTRIB(VALUE);
create index I_SCHEDULE_SERIES_ATTRIB_TV on SCHEDULE_SERIES_ATTRIB(ATTRIBUTE_TYPE);
create index I_SCHEDULE_SID on SCHEDULE(SERIES_ID);

