/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.me.entitymanager;

import com.ericsson.cms.me.entity.MECacheResult;
import com.ericsson.cms.me.entity.MEEnhancedField;
import com.ericsson.cms.me.entity.MEFieldDefinition;
import com.ericsson.cms.me.entity.MEIdentifierCriteria;
import com.ericsson.cms.me.entity.MERequest;
import com.ericsson.cms.me.entity.MESubsProfile;
import com.ericsson.cms.me.exception.MetadataEnhancementException;
import com.ericsson.cms.me.service.IMEEntityManager;
import com.ericsson.cms.me.service.IMEEntityManagerLocal;
import com.ericsson.cms.me.service.IMEEntityManagerRemote;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.ejb.Local;
import javax.ejb.Remote;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.log4j.Logger;

@Remote(value={IMEEntityManagerRemote.class})
@Local(value={IMEEntityManagerLocal.class})
@Stateless
@TransactionAttribute
public class MEEntityManager
implements IMEEntityManager {
    private static final Logger logger = Logger.getLogger(MEEntityManager.class);
    @PersistenceContext(unitName="MetadataEnhancementRealm")
    private EntityManager entityManager;

    public MESubsProfile getMeSubsProfile(String profileName) {
        logger.debug((Object)"getSubscriptionProfile entered");
        MESubsProfile result = null;
        try {
            Query query = this.entityManager.createQuery("select profile from MESubsProfile profile where profile.name=:profileName");
            query.setParameter("profileName", (Object)profileName);
            result = (MESubsProfile)query.getSingleResult();
            logger.debug((Object)"getSubscriptionProfile exited");
            return result;
        }
        catch (NoResultException re) {
        }
        catch (Exception e) {
            MetadataEnhancementException mee = this.fail("Unable to get named profile: " + profileName, e);
            logger.error((Object)mee, (Throwable)mee);
            throw mee;
        }
        return null;
    }

    public MESubsProfile getMeSubsProfile(long id) {
        logger.debug((Object)"getSubscriptionProfile entered");
        MESubsProfile result = null;
        try {
            Query query = this.entityManager.createQuery("select profile from MESubsProfile profile where profile.id=:id");
            query.setParameter("id", (Object)id);
            result = (MESubsProfile)query.getSingleResult();
            logger.debug((Object)"getSubscriptionProfile exited");
            return result;
        }
        catch (NoResultException re) {
        }
        catch (Exception e) {
            MetadataEnhancementException mee = this.fail("Unable to get profile id: " + id, e);
            logger.error((Object)mee, (Throwable)mee);
            throw mee;
        }
        return null;
    }

    public List<MESubsProfile> getMeSubsProfiles() {
        logger.debug((Object)"getSubscriptionProfiles entered");
        ArrayList<MESubsProfile> profiles = null;
        try {
            Query query = this.entityManager.createQuery("select profile from MESubsProfile profile");
            profiles = new ArrayList<MESubsProfile>(query.getResultList());
            logger.debug((Object)"getSubscriptionProfiles exited");
            return profiles;
        }
        catch (Exception e) {
            logger.debug((Object)("Exception: getSubscriptionProfiles() - " + e));
            return null;
        }
    }

    public List<String> listMeSubsProfileNames() {
        logger.debug((Object)"getSubscriptionProfiles entered");
        ArrayList<String> names = null;
        try {
            Query query = this.entityManager.createQuery("select profile.name from MESubsProfile profile");
            names = new ArrayList<String>(query.getResultList());
            Collections.sort(names);
            logger.debug((Object)"listSubProfileNames exited");
            return names;
        }
        catch (Exception e) {
            logger.debug((Object)("Exception: listSubProfileNames() - " + e));
            return null;
        }
    }

    public void saveMeSubsProfile(MESubsProfile profile) throws MetadataEnhancementException {
        try {
            if (profile != null) {
                if (profile.getId() == null) {
                    logger.info((Object)("Saving profile: '" + profile + "'"));
                    this.entityManager.persist((Object)profile);
                } else {
                    logger.info((Object)("Merging profile: '" + profile + "'"));
                    Set meIdentifierCriterias = profile.getMeIdentifierCriterias();
                    Set meEnhancedFields = profile.getMeEnhancedFields();
                    Set meFieldDefinitions = profile.getMeFieldDefinitions();
                    if (meIdentifierCriterias != null) {
                        for (MEIdentifierCriteria ic : meIdentifierCriterias) {
                            ic.setId(null);
                            if (ic.getMeFieldDefinition() == null) continue;
                            ic.getMeFieldDefinition().setId(null);
                        }
                    }
                    if (meEnhancedFields != null) {
                        for (MEEnhancedField ef : meEnhancedFields) {
                            ef.setId(null);
                            if (ef.getMeFieldDefinition() == null) continue;
                            ef.getMeFieldDefinition().setId(null);
                        }
                    }
                    if (meFieldDefinitions != null) {
                        for (MEFieldDefinition fd : meFieldDefinitions) {
                            fd.setId(null);
                        }
                    }
                    this.entityManager.merge((Object)profile);
                }
            }
        }
        catch (Exception e) {
            MetadataEnhancementException mee = this.fail("Unable to save profile: " + profile, e);
            logger.error((Object)mee, (Throwable)mee);
            throw mee;
        }
    }

    public void deleteMeSubsProfile(long id) {
        MESubsProfile profile = this.getMeSubsProfile(id);
        this.deleteMeSubsProfile(profile);
    }

    public void deleteMeRequest(String requestKey) {
        MERequest meRequest = this.getMeRequest(requestKey);
        if (meRequest != null) {
            this.deleteMeRequest(meRequest);
        }
    }

    private void deleteMeRequest(MERequest meRequest) {
        if (meRequest != null) {
            try {
                this.entityManager.remove((Object)meRequest);
            }
            catch (Exception e) {
                MetadataEnhancementException mee = this.fail("Unable to delete request: " + meRequest, e);
                logger.error((Object)mee, (Throwable)mee);
                throw mee;
            }
        } else {
            logger.warn((Object)"Cannot delete a NULL request");
        }
    }

    private void deleteMeSubsProfile(MESubsProfile profile) {
        if (profile != null) {
            logger.info((Object)("Deleting profile '" + profile.getName() + "'"));
            try {
                List<MECacheResult> meCacheResults = this.getMeCacheResults(profile);
                for (MECacheResult meCacheResult : meCacheResults) {
                    logger.info((Object)("entityManager.removing result: " + meCacheResult.getTitle()));
                    meCacheResult.getMeRequest().getMeCacheResults().remove(meCacheResult);
                    this.entityManager.remove((Object)meCacheResult);
                }
                logger.info((Object)("entityManager.removing profile: " + profile.getName()));
                this.entityManager.remove((Object)profile);
                logger.info((Object)"deletMeSubsProfile exiting.");
            }
            catch (MetadataEnhancementException mee) {
                throw mee;
            }
            catch (Exception e) {
                MetadataEnhancementException mee = this.fail("Unable to delete profile: " + profile, e);
                logger.error((Object)mee, (Throwable)mee);
                throw mee;
            }
        } else {
            logger.warn((Object)"Cannot delete a NULL profile");
        }
    }

    private List<MECacheResult> getMeCacheResults(MESubsProfile profile) {
        List results = null;
        if (profile != null && profile.getId() != null) {
            Query query = this.entityManager.createQuery("select result from MECacheResult result JOIN result.meSubsProfile profile where profile.id=:profileId");
            query.setParameter("profileId", (Object)profile.getId());
            results = query.getResultList();
        }
        return results;
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void saveMeRequest(MERequest meRequest) throws MetadataEnhancementException {
        try {
            if (meRequest != null) {
                this.entityManager.persist((Object)meRequest);
            }
        }
        catch (Exception e) {
            MetadataEnhancementException mee = this.fail("Unable to save request: " + meRequest, e);
            logger.error((Object)mee, (Throwable)mee);
            throw mee;
        }
    }

    public boolean meRequestExists(String requestKey) {
        boolean result = false;
        try {
            if (requestKey != null && requestKey.trim().length() > 0) {
                Query query = this.entityManager.createQuery("select request from MERequest request where request.requestKey=:requestKey");
                query.setParameter("requestKey", (Object)requestKey);
                query.getSingleResult();
                result = true;
            }
        }
        catch (NoResultException e) {
            result = false;
        }
        return result;
    }

    public MERequest getMeRequest(String requestKey) throws MetadataEnhancementException {
        MERequest meRequest = null;
        try {
            if (requestKey != null && requestKey.trim().length() > 0) {
                Query query = this.entityManager.createQuery("select request from MERequest request where request.requestKey=:requestKey");
                query.setParameter("requestKey", (Object)requestKey);
                meRequest = (MERequest)query.getSingleResult();
                if (meRequest.getMeCacheResults() != null) {
                    for (MECacheResult mcr : meRequest.getMeCacheResults()) {
                        mcr.getMeSubsProfile();
                    }
                }
            }
        }
        catch (NoResultException e) {
        }
        catch (Exception e) {
            MetadataEnhancementException mee = this.fail("Unable to get request: " + requestKey, e);
            logger.error((Object)mee, (Throwable)mee);
            throw mee;
        }
        return meRequest;
    }

    public List<MERequest> getMeRequests() throws MetadataEnhancementException {
        ArrayList<MERequest> meRequests = new ArrayList<MERequest>();
        try {
            Query query = this.entityManager.createQuery("select request from MERequest request");
            for (MERequest meRequest : query.getResultList()) {
                if (meRequest.getMeCacheResults() != null) {
                    meRequest.getMeCacheResults().size();
                }
                meRequests.add(meRequest);
            }
        }
        catch (Exception e) {
            MetadataEnhancementException mee = this.fail("Unable to get requests", e);
            logger.error((Object)mee, (Throwable)mee);
            throw mee;
        }
        return meRequests;
    }

    public Set<MECacheResult> getMeCacheResults(Long profileId, String requestKey) throws MetadataEnhancementException {
        LinkedHashSet<MECacheResult> results = null;
        try {
            Set<MECacheResult> requestResults;
            if (profileId != null && requestKey != null && (requestResults = this.getMeCacheResults(requestKey)) != null) {
                results = new LinkedHashSet<MECacheResult>();
                for (MECacheResult meCacheResult : requestResults) {
                    if (!meCacheResult.getMeSubsProfile().getId().equals(profileId)) continue;
                    results.add(meCacheResult);
                }
            }
        }
        catch (MetadataEnhancementException mee) {
            throw mee;
        }
        catch (Exception e) {
            MetadataEnhancementException mee = this.fail("Unable to get request profile results: " + requestKey + "/" + profileId, e);
            logger.error((Object)mee, (Throwable)mee);
            throw mee;
        }
        return results;
    }

    public Set<MECacheResult> getMeCacheResults(String requestKey) throws MetadataEnhancementException {
        LinkedHashSet results = null;
        try {
            if (requestKey != null) {
                results = new LinkedHashSet();
                Query query = this.entityManager.createQuery("select result from MECacheResult result join result.meRequest request where request.requestKey=:requestKey order by result.ranking DESC");
                query.setParameter("requestKey", (Object)requestKey);
                results.addAll(query.getResultList());
            }
        }
        catch (Exception e) {
            MetadataEnhancementException mee = this.fail("Unable to get request results: " + requestKey, e);
            logger.error((Object)mee, (Throwable)mee);
            throw mee;
        }
        return results;
    }

    public MESubsProfile findProfileById(long id) {
        logger.debug((Object)("getting Subscription Profile instance with id: " + id));
        try {
            Query query = this.entityManager.createQuery("select profile from MESubsProfile profile where profile.id=:id");
            query.setParameter("id", (Object)id);
            MESubsProfile result = (MESubsProfile)query.getSingleResult();
            logger.debug((Object)"get successful");
            return result;
        }
        catch (Exception e) {
            MetadataEnhancementException mee = this.fail("Unable to find profile id: " + id, e);
            logger.error((Object)mee, (Throwable)mee);
            throw mee;
        }
    }

    public MERequest findRequestById(long id) {
        logger.debug((Object)("getting Request instance with id: " + id));
        try {
            Query query = this.entityManager.createQuery("select request from MERequest request where request.id=:id");
            query.setParameter("id", (Object)id);
            MERequest result = (MERequest)query.getSingleResult();
            logger.debug((Object)"get successful");
            return result;
        }
        catch (Exception e) {
            MetadataEnhancementException mee = this.fail("Unable to find request id: " + id, e);
            logger.error((Object)mee, (Throwable)mee);
            throw mee;
        }
    }

    public Set<MESubsProfile> getMeSubsProfiles(Set<MECacheResult> meCacheResults) {
        HashSet<MESubsProfile> profiles = null;
        if (meCacheResults != null) {
            profiles = new HashSet<MESubsProfile>();
            for (MECacheResult meCacheResult : meCacheResults) {
                profiles.add(meCacheResult.getMeSubsProfile());
            }
        }
        return profiles;
    }

    public Set<Long> getMeSubsProfileIds(Set<MESubsProfile> meSubsProfiles) {
        HashSet<Long> ids = null;
        if (meSubsProfiles != null) {
            ids = new HashSet<Long>();
            for (MESubsProfile meSubsProfile : meSubsProfiles) {
                ids.add(meSubsProfile.getId());
            }
        }
        return ids;
    }

    public Collection<Long> getMeCacheResultsProfileIds(String requestKey) throws MetadataEnhancementException {
        return this.getMeSubsProfileIds(this.getMeSubsProfiles(this.getMeCacheResults(requestKey)));
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void updateMeRequest(MERequest meRequest) {
        if (meRequest != null && meRequest.getId() != null) {
            try {
                this.entityManager.merge((Object)meRequest);
            }
            catch (Exception e) {
                MetadataEnhancementException mee = this.fail("Unable to update request: " + meRequest, e);
                logger.error((Object)mee, (Throwable)mee);
                throw mee;
            }
        }
    }

    private MetadataEnhancementException fail(String message) {
        return new MetadataEnhancementException(message);
    }

    private MetadataEnhancementException fail(Exception e) {
        return this.fail("Unexpected exception: " + e, e);
    }

    private MetadataEnhancementException fail(String message, Exception e) {
        if (e instanceof MetadataEnhancementException) {
            return (MetadataEnhancementException)((Object)e);
        }
        return new MetadataEnhancementException(message + " cause:" + e, (Throwable)e);
    }
}

