/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.me.manager;

import com.ericsson.cms.me.entity.MECacheResult;
import com.ericsson.cms.me.entity.MEProviderChangedMessage;
import com.ericsson.cms.me.entity.MERequest;
import com.ericsson.cms.me.entity.MESubsProfile;
import com.ericsson.cms.me.enumeration.CacheResultStatus;
import com.ericsson.cms.me.exception.CacheResultException;
import com.ericsson.cms.me.exception.MetadataEnhancementException;
import com.ericsson.cms.me.exception.SubsProfileValidationException;
import com.ericsson.cms.me.jpf.JPFPlugin;
import com.ericsson.cms.me.service.Fields;
import com.ericsson.cms.me.service.IMEEntityManagerLocal;
import com.ericsson.cms.me.service.IMEHazelcastManagerLocal;
import com.ericsson.cms.me.service.IMEManager;
import com.ericsson.cms.me.service.IMEManagerLocal;
import com.ericsson.cms.me.service.IMEManagerRemote;
import com.ericsson.cms.me.service.IMEPlugin;
import com.ericsson.cms.me.service.IMEPluginManagerLocal;
import com.ericsson.cms.me.service.dto.CacheResult;
import com.ericsson.cms.me.service.dto.Duration;
import com.ericsson.cms.me.service.dto.EnhancedField;
import com.ericsson.cms.me.service.dto.FieldDefinition;
import com.ericsson.cms.me.service.dto.Request;
import com.ericsson.cms.me.service.dto.SearchFieldCriteria;
import com.ericsson.cms.me.service.dto.SubscriptionProfile;
import com.ericsson.cms.me.service.dto.SubscriptionProfileParam;
import com.ericsson.cms.me.service.dto.TitleSummary;
import com.ericsson.rules.fieldprovider.fieldvalue.BooleanFieldValue;
import com.ericsson.rules.fieldprovider.fieldvalue.ComplexFieldValue;
import com.ericsson.rules.fieldprovider.fieldvalue.DateFieldValue;
import com.ericsson.rules.fieldprovider.fieldvalue.FieldValue;
import com.ericsson.rules.fieldprovider.fieldvalue.FloatFieldValue;
import com.ericsson.rules.fieldprovider.fieldvalue.LongFieldValue;
import com.ericsson.rules.fieldprovider.fieldvalue.StringFieldValue;
import com.ericsson.rules.fieldprovider.fieldvalue.TimeFieldValue;
import com.ericsson.rules.fieldprovider.metadataenhancement.IMetadataEnhancementProvidersChangeListener;
import com.ericsson.rules.fieldprovider.metadataenhancement.ISubscriptionProfile;
import com.ericsson.rules.fieldprovider.metadataenhancement.ISubscriptionProfileProvider;
import com.ericsson.rules.fieldprovider.metadataenhancement.RuleSetSubscriptionProfile;
import com.hazelcast.core.MessageListener;
import com.tandbergtv.marvin.udt.DataTypes;
import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.Field;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.title.ITitleManager;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.ejb.EJB;
import javax.ejb.Local;
import javax.ejb.Remote;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.xml.bind.DatatypeConverter;
import org.apache.log4j.Logger;

@Remote(value={IMEManagerRemote.class})
@Local(value={IMEManagerLocal.class})
@Stateless
@TransactionAttribute
public class MEManager
implements IMEManager {
    private static final Logger logger = Logger.getLogger(MEManager.class);
    private static final long MAX_NAME_LENGTH = 4000L;
    private static final String TITLE_NAME_XPATH = "/Fields/Title/DisplayTitle/Value";
    private static final String TITLE_YEAR_XPATH = "/Fields/CreationInfo/PublicationDate";
    private static final String TITLE_TYPE_XPATH = "/Fields/ShowType";
    private static final String TITLE_ACTOR_DISPLAYNAME_XPATH = "/Fields/Sources/Source/Contact/DisplayName";
    private static final String FORCE_CONFLICT_RESOLUTION = "ForceConflictResolution";
    private static final String TRUE = "true";
    private static final String SEARCH_FAILED_MISSING_REQUIRED_FIELDS = "Search failed - required plugin field value(s) missing: ";
    private static final String IO_EXCEPTION = "IOException";
    private static final String ME_CONNECT_EXCEPTION = "MEConnectException";
    private static final String CONNECT_EXCEPTION = "ConnectException";
    @EJB
    private IMEPluginManagerLocal mePluginManager;
    @EJB
    private IMEEntityManagerLocal entityManager;
    @EJB
    private IMEHazelcastManagerLocal hazelcastManager;
    @EJB(name="cms/SubscriptionProfileProvider/local")
    private ISubscriptionProfileProvider rulesSubscriptionProfileProvider;
    @EJB(name="cms/TitleManagerProxy/local")
    private ITitleManager titleManager;
    private static final Collection<IMetadataEnhancementProvidersChangeListener> metadataEnhancementProvidersChangeListeners = new ArrayList<IMetadataEnhancementProvidersChangeListener>();

    @PostConstruct
    public void initialize() {
        this.hazelcastManager.addMEProviderChangeListerner((MessageListener)new MessageListener<MEProviderChangedMessage>(){

            public void onMessage(MEProviderChangedMessage paramE) {
                MEManager.this.notifyMetadataEhancementProvidersChangeListeners();
            }
        });
    }

    public boolean searchEnhancement(Collection<Long> subscriptionProfileIds, Long titleId, String workOrderRequestKey) throws MetadataEnhancementException {
        if (titleId == null) {
            MetadataEnhancementException mee = this.fail("TitleId cannot be null");
            logger.error((Object)mee, (Throwable)mee);
            throw mee;
        }
        return this.searchEnhancement(subscriptionProfileIds, this.titleManager.get(titleId), workOrderRequestKey);
    }

    public boolean searchEnhancement(Collection<Long> subscriptionProfileIds, Title title, String workOrderRequestKey) throws MetadataEnhancementException {
        logger.debug((Object)"searchEnhancement entered");
        boolean isConflictResolutionRequired = false;
        try {
            HashSet<CacheResult> results = new HashSet<CacheResult>();
            String pluginName = null;
            if (workOrderRequestKey == null || workOrderRequestKey.isEmpty()) {
                MetadataEnhancementException mee = this.fail("Undefined work order request key");
                logger.error((Object)mee, (Throwable)mee);
                throw mee;
            }
            if ((subscriptionProfileIds == null || subscriptionProfileIds.isEmpty()) && ((subscriptionProfileIds = this.rulesSubscriptionProfileProvider.getSubscriptionProfiles(title)) == null || subscriptionProfileIds.isEmpty())) {
                MetadataEnhancementException mee = this.fail("Undefined Subscription profiles");
                logger.error((Object)mee, (Throwable)mee);
                throw mee;
            }
            if (this.requestExists(workOrderRequestKey)) {
                logger.info((Object)("Request '" + workOrderRequestKey + "' already existed, deleting it"));
                this.deleteRequest(workOrderRequestKey);
            }
            for (Long profileId : subscriptionProfileIds) {
                MetadataEnhancementException mee;
                SubscriptionProfile profile = this.getSubscriptionProfile(profileId);
                if (profile == null) {
                    mee = this.fail("Subscription profile does not exist");
                    logger.error((Object)mee, (Throwable)mee);
                    throw mee;
                }
                pluginName = profile.getPluginName();
                if (pluginName == null || pluginName.isEmpty()) {
                    mee = this.fail("Subscription profile plugin is undefined");
                    logger.error((Object)mee, (Throwable)mee);
                    throw mee;
                }
                List<CacheResult> conflicts = this.search(profile, title, pluginName, workOrderRequestKey);
                if (conflicts == null) continue;
                boolean forceConflictResolution = conflicts.size() > 0 && this.forceConflictResolution(profile);
                boolean bl = isConflictResolutionRequired = isConflictResolutionRequired || conflicts.size() > 1 || forceConflictResolution;
                if (conflicts.size() == 1) {
                    for (CacheResult cr : conflicts) {
                        cr.setStatus(CacheResultStatus.SELECTED.toString());
                    }
                }
                results.addAll(conflicts);
            }
            if (results != null && results.size() > 0) {
                Request request = new Request();
                request.setRequestKey(workOrderRequestKey);
                request.setCacheResults(results);
                for (CacheResult cacheResult : results) {
                    cacheResult.setRequest(request);
                }
                request.setTitle(title);
                this.saveRequest(request);
            } else {
                logger.info((Object)"Search returned no results - no request/results entries created.");
            }
            logger.debug((Object)("Is conflict resolution required:" + isConflictResolutionRequired));
            logger.warn((Object)"searchEnhancement exited");
        }
        catch (MetadataEnhancementException mee) {
            throw mee;
        }
        catch (Exception e) {
            MetadataEnhancementException mee = this.fail(e);
            logger.error((Object)mee, (Throwable)mee);
            throw mee;
        }
        return isConflictResolutionRequired;
    }

    private boolean forceConflictResolution(SubscriptionProfile profile) {
        if (profile != null) {
            for (SubscriptionProfileParam spp : profile.getParams()) {
                if (!FORCE_CONFLICT_RESOLUTION.equalsIgnoreCase(spp.getName()) || !TRUE.equalsIgnoreCase(spp.getValue())) continue;
                return true;
            }
        }
        return false;
    }

    private void saveRequest(Request request) {
        if (request != null) {
            MERequest meRequest = null;
            MECacheResult meCacheResult = null;
            MESubsProfile meSubsProfile = null;
            HashMap<Long, MESubsProfile> profiles = new HashMap<Long, MESubsProfile>();
            try {
                for (MESubsProfile msp : this.entityManager.getMeSubsProfiles()) {
                    profiles.put(msp.getId(), msp);
                }
                meRequest = request.toMeRequest();
                Iterator i$ = meRequest.getMeCacheResults().iterator();
                while (i$.hasNext()) {
                    MECacheResult mcr;
                    meCacheResult = mcr = (MECacheResult)i$.next();
                    meSubsProfile = mcr.getMeSubsProfile();
                    Long profileId = meSubsProfile.getId();
                    meSubsProfile = (MESubsProfile)profiles.get(profileId);
                    meCacheResult.setMeSubsProfile(meSubsProfile);
                    meCacheResult.setMeRequest(meRequest);
                }
                this.entityManager.saveMeRequest(meRequest);
            }
            catch (MetadataEnhancementException mee) {
                throw mee;
            }
            catch (Exception e) {
                MetadataEnhancementException mee = this.fail("Error saving request[" + meRequest == null ? null : meRequest.getRequestKey() + "]: ", e);
                logger.error((Object)mee, (Throwable)mee);
                throw mee;
            }
        }
    }

    private List<CacheResult> search(SubscriptionProfile profile, Title title, String pluginName, String workOrderRequestKey) {
        List results = null;
        try {
            Set identifierKeys = profile.getSearchCriteria();
            Set<SearchFieldCriteria> metadataValues = this.getMetadataValues(title, identifierKeys);
            profile.setSearchCriteria(metadataValues);
            this.validateRequiredValues(pluginName, profile.getSearchCriteria());
            IMEPlugin plugin = this.mePluginManager.getMEPlugin(pluginName);
            plugin.initialize();
            results = plugin.search(profile);
            if (results != null && results.size() > 0) {
                for (CacheResult cacheResult : results) {
                    cacheResult.setProfile(profile);
                }
            }
        }
        catch (MetadataEnhancementException mee) {
            throw mee;
        }
        catch (Exception e) {
            if (this.lastCause(e).contains(IO_EXCEPTION)) {
                MetadataEnhancementException mee = this.fail("Enhancement search failed while trying to communicate with the provider - please check profile configuration parameters and network connectivity.");
                logger.error((Object)mee, (Throwable)e);
                throw mee;
            }
            if (this.lastCause(e).contains(ME_CONNECT_EXCEPTION)) {
                MetadataEnhancementException mee = this.fail(e.getCause().getMessage());
                logger.error((Object)mee, (Throwable)e);
                throw mee;
            }
            if (this.lastCause(e).contains(CONNECT_EXCEPTION)) {
                MetadataEnhancementException mee = this.fail("Connection timed out during enhancement search request - please check profile configuration parameters and network connectivity.");
                logger.error((Object)mee, (Throwable)e);
                throw mee;
            }
            MetadataEnhancementException mee = this.fail("search(profile=" + profile == null ? null : profile.getName() + ", title=" + title + ", plugin=" + pluginName + ", request=" + workOrderRequestKey + ") failed with: ", e);
            logger.error((Object)mee, (Throwable)mee);
            throw mee;
        }
        return results;
    }

    private void validateRequiredValues(String pluginName, Set<SearchFieldCriteria> criteria) {
        HashMap<String, Set<Fields>> pluginFields = this.getECMFFieldMappings(pluginName);
        HashSet<String> missingValues = new HashSet<String>();
        Collection<Set<Fields>> pluginMappings = pluginFields.values();
        if (pluginMappings != null) {
            for (Set<Fields> mappingFields : pluginMappings) {
                if (mappingFields == null) continue;
                for (Fields f : mappingFields) {
                    String fname = f.getName();
                    if (!f.isRequired()) continue;
                    if (criteria == null) {
                        missingValues.add(fname);
                        continue;
                    }
                    boolean found = false;
                    for (SearchFieldCriteria sfc : criteria) {
                        String sfcname = sfc.getField().getDisplayName();
                        String sfcvalue = sfc.getValue();
                        if (!fname.equals(sfcname)) continue;
                        found = true;
                        if (sfcvalue != null && sfcvalue.trim().length() >= 1) break;
                        missingValues.add(fname);
                        break;
                    }
                    if (found) continue;
                    missingValues.add(fname);
                }
            }
        }
        if (missingValues.size() > 0) {
            MetadataEnhancementException mee = this.fail(SEARCH_FAILED_MISSING_REQUIRED_FIELDS + ((Object)missingValues).toString());
            logger.error((Object)mee, (Throwable)mee);
            throw mee;
        }
    }

    public MECacheResult toMeCacheResult(MESubsProfile profile, long titleId, String requestKey, CacheResult result) throws CacheResultException {
        MECacheResult mcr = null;
        if (result != null) {
            mcr = result.toMeCacheResult();
            if (requestKey != null) {
                MERequest meRequest = this.entityManager.getMeRequest(requestKey);
                mcr.setMeRequest(meRequest);
            }
            if (profile != null) {
                mcr.setMeSubsProfile(profile);
            }
        }
        return mcr;
    }

    public MECacheResult toMeCacheResult(MESubsProfile profile, String requestKey, CacheResult result) throws CacheResultException {
        return this.toMeCacheResult(profile, -1L, requestKey, result);
    }

    public SubscriptionProfile getSubscriptionProfile(String profileName) throws MetadataEnhancementException {
        SubscriptionProfile result = null;
        MESubsProfile meSubsProfile = this.entityManager.getMeSubsProfile(profileName);
        if (meSubsProfile != null) {
            result = new SubscriptionProfile(meSubsProfile);
        }
        return result;
    }

    public SubscriptionProfile getSubscriptionProfile(Long profileId) throws MetadataEnhancementException {
        SubscriptionProfile result = null;
        MESubsProfile meSubsProfile = this.entityManager.findProfileById(profileId.longValue());
        if (meSubsProfile != null) {
            result = new SubscriptionProfile(meSubsProfile);
        }
        return result;
    }

    public SubscriptionProfile getSubscriptionProfile(long id) throws MetadataEnhancementException {
        return SubscriptionProfile.toSubscriptionProfile((MESubsProfile)this.entityManager.getMeSubsProfile(id));
    }

    public void saveSubscriptionProfile(SubscriptionProfile profile) throws SubsProfileValidationException, MetadataEnhancementException {
        try {
            this.validateSubsProfile(profile);
            if (profile != null) {
                MESubsProfile meSubsProfile = profile.toMESubsProfile();
                this.entityManager.saveMeSubsProfile(meSubsProfile);
                this.hazelcastManager.getMEProviderChangedTopic().publish((Object)new MEProviderChangedMessage());
            }
        }
        catch (SubsProfileValidationException spve) {
            logger.warn((Object)("Validation failed for profile '" + profile.getName() + "'"));
            for (String error : spve.getValidationErrors()) {
                logger.warn((Object)error);
            }
            throw spve;
        }
    }

    public void deleteSubscriptionProfile(Long id) throws MetadataEnhancementException {
        if (id == null) {
            MetadataEnhancementException mee = this.fail("Subscription profile id is null, delete failed");
            logger.error((Object)mee, (Throwable)mee);
            throw mee;
        }
        if (this.profileInUseByRule(id)) {
            MetadataEnhancementException mee = this.fail("Rules is using the subscription profile with id '" + id + "', delete failed");
            logger.error((Object)mee, (Throwable)mee);
            throw mee;
        }
        try {
            this.entityManager.deleteMeSubsProfile(id.longValue());
            this.hazelcastManager.getMEProviderChangedTopic().publish((Object)new MEProviderChangedMessage());
        }
        catch (MetadataEnhancementException mee) {
            throw mee;
        }
        catch (Exception e) {
            MetadataEnhancementException mee = this.fail("deleteSubscriptionProfile() failed with: ", e);
            logger.error((Object)mee, (Throwable)mee);
            throw mee;
        }
    }

    private void notifyMetadataEhancementProvidersChangeListeners() {
        if (metadataEnhancementProvidersChangeListeners != null) {
            for (IMetadataEnhancementProvidersChangeListener listener : metadataEnhancementProvidersChangeListeners) {
                try {
                    listener.metadataEnhancementProvidersChanged();
                }
                catch (Exception e) {
                    logger.warn((Object)"ME Providers Changed listener call failed - ignored.");
                }
            }
        }
    }

    public Collection<RuleSetSubscriptionProfile> getAllRulesUsingThisProfile(Long profileId) {
        return this.rulesSubscriptionProfileProvider.getAllRulesUsingThisProfile(profileId);
    }

    private boolean profileInUseByRule(Long id) {
        logger.info((Object)"validateDeleteSubscriptionProfile() entered");
        logger.info((Object)("validating if rules is using the profile with id:" + id));
        boolean isRulesUsing = false;
        try {
            Collection rulesSet;
            MESubsProfile profile = this.entityManager.findProfileById(id.longValue());
            if (profile != null && (rulesSet = this.rulesSubscriptionProfileProvider.getAllRulesUsingThisProfile(id)).size() > 0) {
                isRulesUsing = true;
            }
        }
        catch (MetadataEnhancementException mee) {
            throw mee;
        }
        catch (Exception e) {
            MetadataEnhancementException mee = this.fail("Exception while validating if rules is using this profile: ", e);
            logger.error((Object)mee, (Throwable)mee);
            throw mee;
        }
        logger.info((Object)("isRulesUsing:" + isRulesUsing));
        logger.info((Object)"validateDeleteSubscriptionProfile() exiting ");
        return isRulesUsing;
    }

    private Set<SearchFieldCriteria> getMetadataValues(Title title, Set<SearchFieldCriteria> identifierKeys) {
        Asset titleAsset = title.getAsset();
        HashSet<SearchFieldCriteria> metadataValues = null;
        if (titleAsset != null && identifierKeys != null) {
            metadataValues = new HashSet<SearchFieldCriteria>();
            for (SearchFieldCriteria identifierKey : identifierKeys) {
                String path = identifierKey.getValue();
                String assetType = identifierKey.getAssetType() == null ? "PACKAGE/TITLE" : identifierKey.getAssetType();
                List fields = titleAsset.getAllFieldsForXpath(Arrays.asList(assetType.split("/")), path);
                String val = null;
                if (fields != null && !fields.isEmpty()) {
                    val = ((Field)fields.get(0)).getValue();
                    SearchFieldCriteria metadataValue = new SearchFieldCriteria();
                    metadataValue.setField(identifierKey.getField());
                    metadataValue.setValue(val);
                    metadataValues.add(metadataValue);
                    continue;
                }
                logger.warn((Object)"field is null in MEManager.getMetadataValues()");
            }
        }
        return metadataValues;
    }

    public List<SubscriptionProfile> getMESubscriptionProfiles() throws MetadataEnhancementException {
        ArrayList<SubscriptionProfile> result = null;
        List meProfiles = this.entityManager.getMeSubsProfiles();
        if (meProfiles != null) {
            result = new ArrayList<SubscriptionProfile>();
            for (MESubsProfile meProfile : meProfiles) {
                result.add(new SubscriptionProfile(meProfile));
            }
        }
        return result;
    }

    public List<ISubscriptionProfile> getSubscriptionProfiles() {
        List<SubscriptionProfile> profiles;
        ArrayList<SubscriptionProfile> result = null;
        try {
            profiles = this.getMESubscriptionProfiles();
        }
        catch (MetadataEnhancementException e) {
            throw new RuntimeException(e);
        }
        if (profiles != null) {
            result = new ArrayList<SubscriptionProfile>();
            result.addAll(profiles);
        }
        return result;
    }

    public boolean validateSubsProfile(SubscriptionProfile profile) throws SubsProfileValidationException, MetadataEnhancementException {
        ArrayList<String> validationErrors = new ArrayList<String>();
        boolean valid = true;
        if (profile != null) {
            IMEPlugin plugin;
            String profileName = profile.getName();
            if (profileName == null || profileName.trim().length() < 1) {
                valid = false;
                validationErrors.add("Profile Name is a required field");
            } else {
                long profileId = -1L;
                try {
                    if (profile.getId() != null) {
                        profileId = profile.getId();
                    }
                }
                catch (NumberFormatException nfe) {
                    logger.debug((Object)("Profile ID is not a valid long value (" + profile.getId() + ")"));
                }
                if ((long)profileName.length() > 4000L) {
                    valid = false;
                    validationErrors.add("Profile Name exceeds maximum length of 4000");
                }
                if (profileId < 1L && this.getSubscriptionProfile(profileName) != null) {
                    valid = false;
                    validationErrors.add("Profile named '" + profileName + "' already exists");
                }
            }
            String pluginName = profile.getPluginName();
            if (pluginName == null || pluginName.trim().length() < 1) {
                valid = false;
                validationErrors.add("Plugin Name is a required field");
            }
            Set fieldCriteria = profile.getSearchCriteria();
            ArrayList<String> fieldNames = new ArrayList<String>();
            if (fieldCriteria == null || fieldCriteria.size() < 1) {
                valid = false;
                validationErrors.add("There must be at least one Search Field Mapping configured");
            } else {
                for (SearchFieldCriteria criteria : fieldCriteria) {
                    fieldNames.add(criteria.getField().getName());
                }
                for (SearchFieldCriteria criteria : fieldCriteria) {
                    int fieldCount = 0;
                    for (String field : fieldNames) {
                        if (!criteria.getField().getName().equals(field)) continue;
                        ++fieldCount;
                    }
                    if (fieldCount <= true) continue;
                    valid = false;
                    validationErrors.add(criteria.getField().getName() + " is duplicated in Search Field Mapping section");
                    break;
                }
            }
            Set enhancedFields = profile.getEnhancedFields();
            ArrayList<String> enhancedFieldNames = new ArrayList<String>();
            if (enhancedFields == null || enhancedFields.size() < 1) {
                valid = false;
                validationErrors.add("There must be at least one enhanced field configured");
            } else {
                for (EnhancedField enhancedField : enhancedFields) {
                    enhancedFieldNames.add(enhancedField.getFieldDefinition().getName());
                }
                for (EnhancedField enhancedField : enhancedFields) {
                    int fieldCount = 0;
                    for (String field : enhancedFieldNames) {
                        if (!enhancedField.getFieldDefinition().getName().equals(field)) continue;
                        ++fieldCount;
                    }
                    if (fieldCount <= true) continue;
                    valid = false;
                    validationErrors.add(enhancedField.getFieldDefinition().getName() + " is duplicated in Enhancement Fields section");
                    break;
                }
            }
            Set profileParams = profile.getParams();
            if (profileParams != null) {
                for (SubscriptionProfileParam curParam : profileParams) {
                    String paramValue = curParam.getValue();
                    if (paramValue == null || !paramValue.startsWith(" ") && !paramValue.endsWith(" ")) continue;
                    validationErrors.add(curParam.getName() + " contains leading or trailing whitespace");
                    valid = false;
                }
            }
            if ((plugin = this.mePluginManager.getMEPlugin(profile.getPluginName())) != null) {
                try {
                    plugin.validateProfile(profile);
                }
                catch (SubsProfileValidationException spve) {
                    valid = false;
                    validationErrors.addAll(spve.getValidationErrors());
                }
            }
        } else {
            valid = false;
            validationErrors.add("Profile is null");
        }
        if (!valid) {
            throw new SubsProfileValidationException(validationErrors);
        }
        return valid;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Collection<FieldValue<?>> getFieldValues(Long subscriptionProfileId, String fieldName, String requestKey) {
        Set meCacheResults;
        ArrayList<TimeFieldValue> result = null;
        logger.info((Object)("getFieldValues(profileId=" + subscriptionProfileId + ", fieldName=" + fieldName + ", requestKey=" + requestKey));
        MESubsProfile meSubsProfile = this.entityManager.findProfileById(subscriptionProfileId.longValue());
        if (meSubsProfile == null) return result;
        SubscriptionProfile subscriptionProfile = SubscriptionProfile.toSubscriptionProfile((MESubsProfile)meSubsProfile);
        Set enhancedFields = subscriptionProfile.getEnhancedFields();
        if (subscriptionProfileId == null || fieldName == null || requestKey == null) return result;
        FieldDefinition definition = null;
        DataTypes datatype = null;
        String mappingType = null;
        if (enhancedFields != null) {
            for (EnhancedField enhancedField : enhancedFields) {
                if (!fieldName.equals(enhancedField.getFieldDefinition().getName())) continue;
                definition = enhancedField.getFieldDefinition();
                datatype = definition.getDataType();
                mappingType = definition.getDatatype();
                break;
            }
        }
        if (datatype == null || (meCacheResults = this.entityManager.getMeCacheResults(subscriptionProfileId, requestKey)) == null) return result;
        result = new ArrayList<TimeFieldValue>();
        for (MECacheResult meCacheResult : meCacheResults) {
            if (!CacheResultStatus.SELECTED.toString().equals(meCacheResult.getStatus())) continue;
            Object fieldResult = null;
            try {
                CacheResult cacheResult = CacheResult.toCacheResult((MECacheResult)meCacheResult);
                Map otherMetadata = cacheResult.getOtherMetadata();
                fieldResult = otherMetadata.get(fieldName);
                if (fieldResult == null) continue;
                TimeFieldValue fieldValue = null;
                if (fieldResult instanceof Collection) {
                    for (Object value : (Collection)fieldResult) {
                        fieldValue = DataTypes.TIME.equals((Object)datatype) ? this.getTimeFieldValue(this.getDuration(value, mappingType)) : this.getFieldValue(datatype, value);
                        if (fieldValue == null) continue;
                        result.add(fieldValue);
                    }
                    continue;
                }
                fieldValue = DataTypes.TIME.equals((Object)datatype) ? this.getTimeFieldValue(this.getDuration((Object)fieldResult, mappingType)) : this.getFieldValue(datatype, fieldResult);
                if (fieldValue == null) continue;
                result.add(fieldValue);
            }
            catch (MetadataEnhancementException mee) {
                throw mee;
            }
            catch (Exception e) {
                MetadataEnhancementException mee = this.fail("getFieldValues() failed - definition=" + definition == null ? null : (definition.getDisplayName() + " selectedResult=" + meCacheResult == null ? null : meCacheResult.getTitle() + "/" + meCacheResult.getYear() + " datatype=" + datatype + " fieldResult=" + fieldResult + ": "), e);
                logger.error((Object)mee, (Throwable)mee);
                throw mee;
                return result;
            }
        }
    }

    private TimeFieldValue getTimeFieldValue(Duration d) {
        TimeFieldValue result = null;
        if (d != null) {
            result = new TimeFieldValue(d.toHHmmss());
        }
        return result;
    }

    private Duration getDuration(Object o, String mappingType) {
        Duration result = null;
        if (o != null) {
            if (o instanceof String) {
                result = this.getDuration((String)o);
            } else if (o instanceof Number) {
                result = this.getDuration(this.doubleOf(o), mappingType);
            }
        }
        return result;
    }

    private Duration getDuration(String s) {
        Duration result = null;
        if (s != null) {
            try {
                result = Duration.getDuration((String)s);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return result;
    }

    private Duration getDuration(Double d, String mappingType) {
        Duration result = null;
        if (d != null && mappingType != null) {
            result = new Duration();
            if ("hours".equalsIgnoreCase(mappingType)) {
                result.setHours(d.doubleValue());
            } else if ("minutes".equalsIgnoreCase(mappingType)) {
                result.setMinutes(d.doubleValue());
            } else if ("seconds".equalsIgnoreCase(mappingType)) {
                result.setSeconds(d.doubleValue());
            }
        }
        return result;
    }

    private Double doubleOf(Object o) {
        if (o != null) {
            if (o instanceof Number) {
                return this.doubleOf((Number)o);
            }
            if (o instanceof String) {
                return this.doubleOf((String)o);
            }
        }
        return null;
    }

    private Double doubleOf(Number n) {
        return new Double(n.doubleValue());
    }

    private Double doubleOf(String s) {
        try {
            return new Double(s);
        }
        catch (Exception e) {
            return null;
        }
    }

    public Collection<String> getFieldValuesAsStrings(Long profileId, String fieldName, String requestKey) {
        ArrayList<String> result = null;
        Collection<FieldValue<?>> fieldValues = this.getFieldValues(profileId, fieldName, requestKey);
        if (fieldValues != null) {
            result = new ArrayList<String>();
            for (FieldValue<?> fieldValue : fieldValues) {
                result.add(this.toString(fieldValue));
            }
        }
        return result;
    }

    private String toString(FieldValue<?> fieldValue) {
        return fieldValue.getClass() + "=" + fieldValue.getValue();
    }

    private FieldValue<?> getFieldValue(DataTypes datatype, Object value) {
        StringFieldValue result = null;
        if (value != null) {
            String val = null;
            val = value instanceof String ? (String)value : "" + value;
            if (val.trim().length() > 0 || datatype.equals((Object)DataTypes.STRING)) {
                try {
                    switch (datatype) {
                        case LONG: {
                            result = new LongFieldValue(Long.parseLong(val));
                            break;
                        }
                        case FLOAT: {
                            result = new FloatFieldValue(Float.parseFloat(val));
                            break;
                        }
                        case BOOLEAN: {
                            result = new BooleanFieldValue(Boolean.parseBoolean(val));
                            break;
                        }
                        case STRING: {
                            result = new StringFieldValue(val);
                            break;
                        }
                        case DATE: {
                            result = new DateFieldValue(this.formatDate(val));
                            break;
                        }
                        case TIME: {
                            result = new TimeFieldValue(val);
                            break;
                        }
                        case COMPLEX: {
                            result = new ComplexFieldValue(val);
                        }
                    }
                }
                catch (IllegalArgumentException e) {
                    MetadataEnhancementException mee = this.fail("Conversion failed for defined datatype value: datatype=" + datatype + " value=" + value + " cause:", e);
                    throw mee;
                }
                catch (ParseException e) {
                    MetadataEnhancementException mee = this.fail("Conversion failed for defined datatype value: datatype=" + datatype + " value=" + value + " cause:", e);
                    throw mee;
                }
                catch (Exception e) {
                    MetadataEnhancementException mee = this.fail("Conversion failed for defined datatype value: datatype=" + datatype + " value=" + value + " cause:", e);
                    throw mee;
                }
            }
        }
        return result;
    }

    private Date formatDate(String date) throws ParseException {
        String datePattern = "yyyy-MM-dd";
        SimpleDateFormat formatter = new SimpleDateFormat(datePattern);
        return formatter.parse(date);
    }

    public List<CacheResult> getConflictsToResolve(Long profileId, String requestKey) throws MetadataEnhancementException {
        ArrayList<CacheResult> conflicts = null;
        Set meCacheResults = this.entityManager.getMeCacheResults(profileId, requestKey);
        if (meCacheResults != null) {
            conflicts = new ArrayList<CacheResult>();
            for (MECacheResult meCacheResult : meCacheResults) {
                conflicts.add(new CacheResult(meCacheResult));
            }
        }
        return conflicts == null || conflicts.size() == 0 ? null : new ArrayList(conflicts);
    }

    public Set<SubscriptionProfile> getProfilesInConflict(String requestKey) throws MetadataEnhancementException {
        Set<SubscriptionProfile> result = null;
        if (this.requiresConflictResolution(requestKey)) {
            result = this.toSubscriptionProfile(this.entityManager.getMeSubsProfiles(this.entityManager.getMeCacheResults(requestKey)));
        }
        return result;
    }

    private Set<SubscriptionProfile> toSubscriptionProfile(Set<MESubsProfile> meSubscriptionProfiles) {
        HashSet<SubscriptionProfile> result = null;
        if (meSubscriptionProfiles != null) {
            result = new HashSet<SubscriptionProfile>();
            for (MESubsProfile meSubscriptionProfile : meSubscriptionProfiles) {
                result.add(new SubscriptionProfile(meSubscriptionProfile));
            }
        }
        return result;
    }

    public Map<SubscriptionProfile, Set<CacheResult>> getConflictsToResolve(String requestKey) throws MetadataEnhancementException {
        HashMap<SubscriptionProfile, HashSet<CacheResult>> result = null;
        if (requestKey != null) {
            result = new HashMap<SubscriptionProfile, HashSet<CacheResult>>();
            Set requestResults = this.entityManager.getMeCacheResults(requestKey);
            if (requestResults != null) {
                for (MECacheResult requestResult : requestResults) {
                    SubscriptionProfile profile = new SubscriptionProfile(requestResult.getMeSubsProfile());
                    HashSet<CacheResult> profileResult = (HashSet<CacheResult>)result.get(profile);
                    if (profileResult == null) {
                        profileResult = new HashSet<CacheResult>();
                        result.put(profile, profileResult);
                    }
                    profileResult.add(new CacheResult(requestResult));
                }
            }
        }
        return result;
    }

    public List<String> getAllPlugins() {
        logger.debug((Object)"Entering getAllPlugins()");
        ArrayList<String> pluginsList = new ArrayList<String>();
        Set plugins = this.mePluginManager.getJPFPlugins();
        for (JPFPlugin plugin : plugins) {
            pluginsList.add(plugin.getName());
        }
        logger.debug((Object)("Plugins Name List: " + ((Object)pluginsList).toString()));
        logger.debug((Object)"Exting getAllPlugins()");
        return pluginsList;
    }

    public HashMap<String, Set<Fields>> getECMFFieldMappings(String pluginName) {
        if (pluginName.isEmpty() || pluginName == null) {
            return null;
        }
        return this.mePluginManager.getECMFFieldMappings(pluginName);
    }

    public String toString(Title title) throws IOException {
        String result = null;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        oos.writeObject(title);
        oos.flush();
        oos.close();
        result = DatatypeConverter.printBase64Binary((byte[])bos.toByteArray());
        return result;
    }

    public Title toTitle(String title) throws IOException, ClassNotFoundException {
        Title result = null;
        ByteArrayInputStream bis = new ByteArrayInputStream(DatatypeConverter.parseBase64Binary((String)title));
        ObjectInputStream ois = new ObjectInputStream(bis);
        result = (Title)ois.readObject();
        ois.close();
        return result;
    }

    public boolean requestExists(String requestKey) {
        return this.entityManager.meRequestExists(requestKey);
    }

    public Request getRequest(String requestKey) {
        MERequest meRequest = this.entityManager.getMeRequest(requestKey);
        Request request = new Request(meRequest);
        HashMap<MESubsProfile, SubscriptionProfile> profiles = new HashMap<MESubsProfile, SubscriptionProfile>();
        if (meRequest.getMeCacheResults() != null) {
            HashSet cacheResults = new HashSet();
            request.setCacheResults(cacheResults);
            for (MECacheResult meCacheResult : meRequest.getMeCacheResults()) {
                MESubsProfile meSubsProfile = meCacheResult.getMeSubsProfile();
                CacheResult cacheResult = new CacheResult(meCacheResult);
                if (profiles.get(meSubsProfile) != null) {
                    cacheResult.setProfile((SubscriptionProfile)profiles.get(meSubsProfile));
                    continue;
                }
                cacheResult.setProfile(new SubscriptionProfile(meSubsProfile));
                profiles.put(meSubsProfile, cacheResult.getProfile());
            }
        }
        return request;
    }

    public List<CacheResult> getMetadataEnhancements(String subscriptionProfileName, String requestKey) throws MetadataEnhancementException {
        Set meCacheResults;
        MESubsProfile profile;
        ArrayList<CacheResult> results = null;
        if (subscriptionProfileName != null && requestKey != null && (profile = this.entityManager.getMeSubsProfile(subscriptionProfileName)) != null && (meCacheResults = this.entityManager.getMeCacheResults(profile.getId(), requestKey)) != null) {
            results = new ArrayList<CacheResult>();
            for (MECacheResult meCacheResult : meCacheResults) {
                results.add(new CacheResult(meCacheResult));
            }
        }
        return results;
    }

    public Collection<SubscriptionProfile> getResultProfiles(String requestKey) throws MetadataEnhancementException {
        HashSet<SubscriptionProfile> result = null;
        Set meSubsProfiles = this.entityManager.getMeSubsProfiles(this.entityManager.getMeCacheResults(requestKey));
        if (meSubsProfiles != null) {
            result = new HashSet<SubscriptionProfile>();
            for (MESubsProfile meSubsProfile : meSubsProfiles) {
                result.add(new SubscriptionProfile(meSubsProfile));
            }
        }
        return result;
    }

    public Collection<Long> getResultProfileIds(String requestKey) throws MetadataEnhancementException {
        return this.entityManager.getMeCacheResultsProfileIds(requestKey);
    }

    public boolean requiresConflictResolution(Long profileId, String requestKey) throws MetadataEnhancementException {
        Set meCacheResults = this.entityManager.getMeCacheResults(profileId, requestKey);
        if (meCacheResults != null && meCacheResults.size() > 1) {
            for (MECacheResult meCacheResult : meCacheResults) {
                if (meCacheResult.getStatus() == null || CacheResultStatus.AVAILABLE.toString().equals(meCacheResult.getStatus())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean requiresConflictResolution(String requestKey) throws MetadataEnhancementException {
        Collection profileIds = this.entityManager.getMeCacheResultsProfileIds(requestKey);
        if (profileIds != null) {
            for (Long profileId : profileIds) {
                if (!this.requiresConflictResolution(profileId, requestKey)) continue;
                return true;
            }
        }
        return false;
    }

    public void deleteRequest(String requestKey) throws MetadataEnhancementException {
        try {
            this.entityManager.deleteMeRequest(requestKey);
        }
        catch (Exception e) {
            if (e instanceof MetadataEnhancementException) {
                throw (MetadataEnhancementException)((Object)e);
            }
            MetadataEnhancementException mee = this.fail("deleteRequest(" + requestKey + ") failed: ", e);
            logger.error((Object)mee, (Throwable)mee);
            throw mee;
        }
    }

    public TitleSummary getRequestTitleSummary(String requestKey) throws MetadataEnhancementException {
        return this.getRequestTitle(requestKey);
    }

    public TitleSummary getRequestTitle(String requestKey) throws MetadataEnhancementException {
        logger.debug((Object)"Entering getRequestTitle()");
        TitleSummary titleSummary = null;
        MERequest request = this.entityManager.getMeRequest(requestKey);
        try {
            List assets;
            if (request != null) {
                String serializedTitle = request.getTitle();
                Title title = this.toTitle(serializedTitle);
                assets = title.getAssets("TITLE");
                if (assets == null || assets.isEmpty()) {
                    return null;
                }
            } else {
                MetadataEnhancementException mee = this.fail("Request title not found: " + requestKey);
                logger.error((Object)mee, (Throwable)mee);
                throw mee;
            }
            Asset titleAsset = (Asset)assets.get(0);
            String titleName = this.getTitleFieldValue(titleAsset, TITLE_NAME_XPATH);
            String year = this.getTitleFieldValue(titleAsset, TITLE_YEAR_XPATH);
            String type = this.getTitleFieldValue(titleAsset, TITLE_TYPE_XPATH);
            String actors = this.getTitleFieldValue(titleAsset, TITLE_ACTOR_DISPLAYNAME_XPATH);
            titleSummary = new TitleSummary(titleName, year, type, actors);
        }
        catch (MetadataEnhancementException mee) {
            throw mee;
        }
        catch (Exception e) {
            MetadataEnhancementException mee = this.fail("getRequestTitle(" + requestKey + ") failed: ", e);
            logger.error((Object)mee, (Throwable)mee);
            throw mee;
        }
        logger.debug((Object)titleSummary.toString());
        logger.debug((Object)"Exiting getRequestTitle()");
        return titleSummary;
    }

    private String getTitleFieldValue(Asset titleAsset, String fieldName) {
        Field field = titleAsset.getField(fieldName);
        if (field == null) {
            return null;
        }
        return field.getValue();
    }

    public void updateMeCacheResultStatus(String requestKey, Long subscriptionProfileId, Long meCacheResultId, String status) throws MetadataEnhancementException {
        logger.debug((Object)"Entering updateMeCacheResultStatus()");
        if (requestKey == null || requestKey.isEmpty()) {
            MetadataEnhancementException mee = this.fail("Can not update cache result status, null request key");
            logger.error((Object)mee, (Throwable)mee);
            throw mee;
        }
        logger.debug((Object)("updating status for: requestKey:" + requestKey + " SubscriptionProfileId: " + subscriptionProfileId + "  CacheResultId: " + meCacheResultId + " Status:" + status));
        try {
            MERequest meRequest = this.entityManager.getMeRequest(requestKey);
            if (meRequest != null) {
                HashSet<MECacheResult> updatedCache = new HashSet<MECacheResult>();
                Set results = meRequest.getMeCacheResults();
                if (results != null) {
                    for (MECacheResult cache : results) {
                        if (subscriptionProfileId != null && subscriptionProfileId.equals(cache.getMeSubsProfile().getId())) {
                            if (CacheResultStatus.IGNORED.toString().equals(status)) {
                                cache.setStatus(status);
                            } else if (meCacheResultId != null && meCacheResultId.equals(cache.getId())) {
                                cache.setStatus(status);
                            } else {
                                cache.setStatus(CacheResultStatus.AVAILABLE.toString());
                            }
                        }
                        cache.setMeRequest(meRequest);
                        updatedCache.add(cache);
                    }
                }
                meRequest.getMeCacheResults().clear();
                meRequest.getMeCacheResults().addAll(updatedCache);
                this.entityManager.updateMeRequest(meRequest);
                logger.debug((Object)("updateMeCacheResultStatus(" + requestKey + ") success"));
            }
        }
        catch (MetadataEnhancementException mee) {
            throw mee;
        }
        catch (Exception e) {
            MetadataEnhancementException mee = this.fail("updateMeCacheResultStatus(" + requestKey + ") failed: ", e);
            logger.error((Object)mee, (Throwable)mee);
            throw mee;
        }
        logger.debug((Object)"Exiting updateMeCacheResultStatus()");
    }

    public void updateMeCacheResultStatus(String requestKey, String status) throws MetadataEnhancementException {
        logger.debug((Object)"Exiting updateMeCacheResultStatus()");
        if (requestKey == null || requestKey.isEmpty()) {
            MetadataEnhancementException mee = this.fail("Can not update cache result status, null request key");
            logger.error((Object)mee, (Throwable)mee);
            throw mee;
        }
        if (status == null || status.isEmpty()) {
            MetadataEnhancementException mee = this.fail("Can not set null status in cache for request key(" + requestKey + ")");
            logger.error((Object)mee, (Throwable)mee);
            throw mee;
        }
        logger.debug((Object)("updating status for: requestKey:" + requestKey + "  Status:" + status));
        try {
            MERequest meRequest = this.entityManager.getMeRequest(requestKey);
            if (meRequest != null) {
                HashSet<MECacheResult> updatedCache = new HashSet<MECacheResult>();
                Set results = meRequest.getMeCacheResults();
                if (results != null) {
                    for (MECacheResult cache : results) {
                        cache.setStatus(status);
                        cache.setMeRequest(meRequest);
                        updatedCache.add(cache);
                    }
                }
                meRequest.getMeCacheResults().clear();
                meRequest.getMeCacheResults().addAll(updatedCache);
                this.entityManager.updateMeRequest(meRequest);
                logger.debug((Object)("updateMeCacheResultStatus(" + requestKey + ") success"));
            }
        }
        catch (MetadataEnhancementException mee) {
            throw mee;
        }
        catch (Exception e) {
            MetadataEnhancementException mee = this.fail("updateMeCacheResultStatus(" + requestKey + ")", e);
            logger.error((Object)mee, (Throwable)mee);
            throw mee;
        }
        logger.debug((Object)"Exiting updateMeCacheResultStatus()");
    }

    public Set<String> getPluginProfileParameters(String pluginName) {
        IMEPlugin plugin = this.mePluginManager.getMEPlugin(pluginName);
        if (plugin != null) {
            return plugin.getSupportedProfileParams();
        }
        return null;
    }

    public Set<String> getProfileFieldsUsed(Long profileId) {
        HashSet<String> fieldNames = new HashSet<String>();
        Collection<RuleSetSubscriptionProfile> ruleSets = this.getAllRulesUsingThisProfile(profileId);
        for (RuleSetSubscriptionProfile ruleSet : ruleSets) {
            if (ruleSet.getFieldIdentifiers() == null) continue;
            fieldNames.addAll(ruleSet.getFieldIdentifiers());
        }
        return fieldNames;
    }

    private MetadataEnhancementException fail(String message) {
        return new MetadataEnhancementException(message);
    }

    private MetadataEnhancementException fail(Exception e) {
        return this.fail("Unexpected exception: " + e, e);
    }

    private MetadataEnhancementException fail(String message, Exception e) {
        if (e instanceof MetadataEnhancementException) {
            return (MetadataEnhancementException)((Object)e);
        }
        return new MetadataEnhancementException(message + " " + this.lastCause(e), (Throwable)e);
    }

    private String lastCause(Throwable e) {
        String cause = null;
        if (e != null) {
            cause = e.getCause() != null ? this.lastCause(e.getCause()) : e.toString();
        }
        return cause;
    }

    public void addMetadataEnhancementProvidersChangeListener(IMetadataEnhancementProvidersChangeListener listener) {
        try {
            metadataEnhancementProvidersChangeListeners.add(listener);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void dropMetadataEnhancementProvidersChangeListener(IMetadataEnhancementProvidersChangeListener listener) {
        try {
            metadataEnhancementProvidersChangeListeners.remove(listener);
        }
        catch (NullPointerException npe) {
        }
        catch (ClassCastException cce) {
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    static {
        metadataEnhancementProvidersChangeListeners.add(new IMetadataEnhancementProvidersChangeListener(){

            public void metadataEnhancementProvidersChanged() {
                logger.debug((Object)(this.getClass() + " listener invoked metadataEnhancementProvidersChanged()"));
            }
        });
    }
}

