/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.marvin.actions;

import com.tandbergtv.marvin.actions.NormalizationActions;
import com.tandbergtv.marvin.engine.EvaluatorResults;
import com.tandbergtv.marvin.engine.MatchedItem;
import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.Field;
import com.tandbergtv.metadatamanager.model.FieldTreeNode;
import com.tandbergtv.metadatamanager.search.XpathNodeCardinality;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;

public class NormalizationAddFieldAction {
    private String sectionType;
    private String rootxpath;
    private String xpath;
    private Boolean forMatched;
    private String value;
    private EvaluatorResults evalResults;
    private Title title;

    public NormalizationAddFieldAction(String sectionType, String rootxpath, String xpath, Boolean forMatched, String value, EvaluatorResults evalResults, Title title) {
        this.sectionType = sectionType;
        this.rootxpath = rootxpath;
        this.xpath = xpath;
        this.forMatched = forMatched;
        this.value = value;
        this.evalResults = evalResults;
        this.title = title;
    }

    private List<XpathNodeCardinality> getNodeCardinality() {
        int i;
        List<XpathNodeCardinality> nodes = NormalizationActions.getXpathCardinality(this.sectionType, this.xpath);
        String firstNode = this.xpath.split("/")[1];
        for (i = 0; i < nodes.size() && !firstNode.equals(nodes.get(i).getNodeName()); ++i) {
        }
        nodes.subList(0, i).clear();
        return nodes;
    }

    public void add() {
        block7: {
            List<Asset> affectedAssets;
            List<XpathNodeCardinality> nodeCardinalities;
            List<String> tokenizededPath;
            block6: {
                tokenizededPath = this.tokenizeXpath(this.xpath);
                nodeCardinalities = this.getNodeCardinality();
                if (!this.forMatched.booleanValue() || this.rootxpath.isEmpty()) break block6;
                List<String> tokenizedRootXpath = this.tokenizeXpath(this.rootxpath);
                List<MatchedItem> matchedFieldTrees = this.evalResults.getMatchedItems();
                if (matchedFieldTrees == null) break block7;
                for (MatchedItem matchedItem : matchedFieldTrees) {
                    int i;
                    String assetType = matchedItem.getAssetPath();
                    FieldTreeNode root = matchedItem.getFieldTree().getRootElement();
                    if (!root.getName().equals(this.rootxpath) || !assetType.equals(this.sectionType)) continue;
                    Asset asset = this.getMatchedItemAsset(root);
                    FieldTreeNode startingNode = (FieldTreeNode)root.getChildren().get(0);
                    ArrayList<Integer> indices = new ArrayList<Integer>();
                    indices.add(1);
                    for (i = 1; i < tokenizedRootXpath.size() - 1; ++i) {
                        indices.add(startingNode.getCurrentIndex());
                        startingNode = (FieldTreeNode)startingNode.getChildren().get(0);
                    }
                    this.walkTree(i, tokenizededPath, nodeCardinalities, startingNode, this.xpath, this.value, indices, asset, false);
                }
                break block7;
            }
            if (this.forMatched.booleanValue()) {
                affectedAssets = new ArrayList();
                for (Asset a : this.evalResults.getMatchedAssets(this.sectionType)) {
                    affectedAssets.add(a);
                }
            } else {
                affectedAssets = this.title.getAsset().getAllAssetsWithLineage(Arrays.asList(this.sectionType.split("/")));
            }
            for (Asset affectedAsset : affectedAssets) {
                FieldTreeNode root = affectedAsset.getFieldTree().getRootElement();
                if (!root.getName().equals(tokenizededPath.get(0))) continue;
                this.walkTree(0, tokenizededPath, nodeCardinalities, root, this.xpath, this.value, new ArrayList<Integer>(), affectedAsset, true);
            }
        }
    }

    private Asset getMatchedItemAsset(FieldTreeNode node) {
        if (node.getField() != null) {
            return node.getField().getParentAsset();
        }
        if (node.getChildren() != null) {
            for (FieldTreeNode child : node.getChildren()) {
                Asset childResult = this.getMatchedItemAsset(child);
                if (childResult == null) continue;
                return childResult;
            }
        }
        return null;
    }

    private boolean walkTree(int listPos, List<String> tokenizedXpath, List<XpathNodeCardinality> nodeCardinalities, FieldTreeNode node, String xpath, String value, List<Integer> indices, Asset asset, boolean onlyAddOne) {
        boolean added = false;
        List children = node.getChildren();
        int numberNodes = 0;
        int newPos = listPos + 1;
        int newNodeCardinality = nodeCardinalities.get(newPos).getCardinality();
        indices.add(node.getCurrentIndex());
        String tokenXpath = tokenizedXpath.get(newPos);
        ArrayList<FieldTreeNode> matchingChildren = new ArrayList<FieldTreeNode>();
        if (children != null && children.size() > 0) {
            for (FieldTreeNode child : children) {
                if (child.isAttribute() && tokenXpath.startsWith("@")) {
                    tokenXpath = tokenXpath.substring(1);
                }
                if (!tokenXpath.equals(child.getName())) continue;
                ++numberNodes;
                matchingChildren.add(child);
            }
        }
        if (numberNodes < newNodeCardinality) {
            List<Integer> newIndices = this.cloneIndices(indices);
            int stopPos = tokenizedXpath.size();
            if (tokenizedXpath.get(tokenizedXpath.size() - 1).startsWith("@")) {
                --stopPos;
            }
            newIndices.add(numberNodes + 1);
            for (int i = newPos + 1; i < stopPos; ++i) {
                newIndices.add(1);
            }
            Field field = this.buildField(newIndices, xpath, value);
            asset.addField(field);
            this.evalResults.updateMatchedItems(field, tokenizedXpath);
            added = true;
        }
        if (!(onlyAddOne && added || newPos >= tokenizedXpath.size() - 1)) {
            for (FieldTreeNode child : matchingChildren) {
                if (!this.walkTree(newPos, tokenizedXpath, nodeCardinalities, child, xpath, value, indices, asset, onlyAddOne)) continue;
                added = true;
                if (!onlyAddOne) continue;
                break;
            }
        }
        indices.remove(indices.size() - 1);
        return added;
    }

    private Field buildField(List<Integer> indices, String xpath, String value) {
        Field field = new Field();
        field.setTtvXPath(xpath);
        field.setIndices(indices);
        field.setValue(value);
        return field;
    }

    private List<String> tokenizeXpath(String xpath) {
        ArrayList<String> tokens = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(xpath, "/", false);
        while (tokenizer.hasMoreTokens()) {
            String str = tokenizer.nextToken();
            if (str.startsWith("tns:")) {
                str = str.substring(4);
            }
            tokens.add(str);
        }
        return tokens;
    }

    private List<Integer> cloneIndices(List<Integer> indices) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (Integer index : indices) {
            result.add(index);
        }
        return result;
    }
}

