/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.marvin.authorization;

import com.tandbergtv.marvin.authorization.Messages;
import com.tandbergtv.neptune.authorization.entity.BasicModule;
import com.tandbergtv.neptune.authorization.entity.BasicPermission;
import com.tandbergtv.neptune.authorization.entity.IModule;
import com.tandbergtv.neptune.authorization.entity.IPermission;
import com.tandbergtv.neptune.authorization.service.IModuleProvider;
import com.tandbergtv.neptune.licensing.ILicenseManager;
import com.tandbergtv.neptune.util.InjectionUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class RulesModuleProvider
implements IModuleProvider {
    private static final String RCS_ONLY_LICENSE = "IsRCSOnly";
    private ILicenseManager neptuneLicenseManager = (ILicenseManager)InjectionUtil.injectInstance((String)"cms/LicenseManager/local", ILicenseManager.class);

    public Collection<IModule> getModules() {
        ArrayList<IModule> modules = new ArrayList<IModule>();
        if (this.isRCSOnlyDeployment()) {
            return modules;
        }
        modules.add(this.buildRulesModule());
        return modules;
    }

    private IModule buildRulesModule() {
        String moduleName = "RulesManagement";
        String displayName = Messages.getString("Rules.DisplayName");
        BasicModule module = new BasicModule(moduleName, displayName, this.getPermissions(moduleName));
        return module;
    }

    private IModule buildValidationModule() {
        String moduleName = "ValidationRulesManagement";
        String displayName = Messages.getString("Validation.Rules.DisplayName");
        BasicModule module = new BasicModule(moduleName, displayName, this.getPermissions(moduleName));
        return module;
    }

    private IModule buildNormalizationModule() {
        String moduleName = "NormalizationRulesManagement";
        String displayName = Messages.getString("Normalization.Rules.DisplayName");
        BasicModule module = new BasicModule(moduleName, displayName, this.getPermissions(moduleName));
        return module;
    }

    private IModule buildProcessingModule() {
        String moduleName = "RulesManagement";
        String displayName = Messages.getString("Processing.Rules.DisplayName");
        BasicModule module = new BasicModule(moduleName, displayName, this.getPermissions(moduleName));
        return module;
    }

    private IModule buildTargetingModule() {
        String moduleName = "TargetingRulesManagement";
        String displayName = Messages.getString("Targeting.Rules.DisplayName");
        BasicModule module = new BasicModule(moduleName, displayName, this.getPermissions(moduleName));
        return module;
    }

    private List<IPermission> getPermissions(String moduleName) {
        ArrayList<IPermission> permissions = new ArrayList<IPermission>();
        String displayName = Messages.getString("Rules.Permissions.View");
        permissions.add((IPermission)new BasicPermission("View", displayName, moduleName));
        displayName = Messages.getString("Rules.Permissions.Create");
        permissions.add((IPermission)new BasicPermission("Create", displayName, moduleName));
        displayName = Messages.getString("Rules.Permissions.Modify");
        permissions.add((IPermission)new BasicPermission("Modify", displayName, moduleName));
        displayName = Messages.getString("Rules.Permissions.Delete");
        permissions.add((IPermission)new BasicPermission("Delete", displayName, moduleName));
        return permissions;
    }

    private boolean isRCSOnlyDeployment() {
        String value = "false";
        try {
            value = this.neptuneLicenseManager.getProperty(RCS_ONLY_LICENSE);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (value == null || value.trim().isEmpty()) {
            return false;
        }
        return Boolean.parseBoolean(value);
    }
}

