/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.marvin.engine;

import com.tandbergtv.metadatamanager.model.Field;
import com.tandbergtv.metadatamanager.model.FieldTree;
import com.tandbergtv.metadatamanager.model.FieldTreeNode;
import com.tandbergtv.metadatamanager.model.IField;
import java.util.ArrayList;
import java.util.List;

public class EvalUtil {
    public static List<IField> getFields(List<FieldTree> fieldTrees, String xpath, boolean includeChildren) {
        if (fieldTrees == null) {
            return new ArrayList<IField>();
        }
        ArrayList<IField> fields = new ArrayList<IField>();
        for (FieldTree fieldTree : fieldTrees) {
            FieldTreeNode root = fieldTree.getRootElement();
            EvalUtil.getFieldsRec(root, xpath, fields, includeChildren);
        }
        return fields;
    }

    public static List<IField> getFields(FieldTree fieldTree, String xpath, boolean includeChildren) {
        if (fieldTree == null) {
            return new ArrayList<IField>();
        }
        FieldTreeNode root = fieldTree.getRootElement();
        ArrayList<IField> fields = new ArrayList<IField>();
        EvalUtil.getFieldsRec(root, xpath, fields, includeChildren);
        return fields;
    }

    private static void getFieldsRec(FieldTreeNode fieldTreeNode, String xpath, List<IField> fields, boolean includeChildren) {
        List children = fieldTreeNode.getChildren();
        if (fieldTreeNode.getField() != null) {
            Field field = fieldTreeNode.getField();
            String fieldXpath = field.getTtvXPath();
            if (fieldXpath.equals(xpath)) {
                fields.add((IField)field);
            } else if (includeChildren && (fieldXpath + "/").startsWith(xpath + "/")) {
                fields.add((IField)field);
            }
        }
        if (children != null) {
            for (FieldTreeNode childNode : children) {
                EvalUtil.getFieldsRec(childNode, xpath, fields, includeChildren);
            }
        }
    }
}

