/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.marvin.engine;

import com.ericsson.cms.criteria.ExpNode;
import com.ericsson.cms.criteria.FieldType;
import com.ericsson.cms.criteria.LogicalOperator;
import com.ericsson.cms.criteria.Predicate;
import com.ericsson.cms.criteria.PredicateComplex;
import com.ericsson.cms.criteria.PredicateRightField;
import com.ericsson.cms.criteria.ret.RetNode;
import com.ericsson.cms.criteria.ret.RetOperand;
import com.ericsson.cms.criteria.ret.RetOperator;
import com.ericsson.cms.criteria.ret.RetTree;
import com.tandbergtv.cms.rules.customrules.CustomNormalizationRule;
import com.tandbergtv.cms.rules.customrules.CustomRule;
import com.tandbergtv.cms.rules.customrules.CustomRuleParameter;
import com.tandbergtv.cms.rules.customrules.CustomValidationRule;
import com.tandbergtv.cms.titlefilter.CriteriaMode;
import com.tandbergtv.content.contentclass.service.ContentClassPersistenceException;
import com.tandbergtv.content.contentclass.service.IContentClassService;
import com.tandbergtv.marvin.engine.Actionator;
import com.tandbergtv.marvin.engine.Determinator;
import com.tandbergtv.marvin.engine.EvalUtil;
import com.tandbergtv.marvin.engine.EvaluatorException;
import com.tandbergtv.marvin.engine.EvaluatorResults;
import com.tandbergtv.marvin.engine.IllegalOperationException;
import com.tandbergtv.marvin.engine.MatchedItem;
import com.tandbergtv.marvin.engine.MultiFieldDeterminator;
import com.tandbergtv.marvin.engine.StrictFieldValidator;
import com.tandbergtv.marvin.engine.TitleExt;
import com.tandbergtv.marvin.services.customrules.CustomRuleLoadException;
import com.tandbergtv.marvin.services.customrules.CustomRuleProvider;
import com.tandbergtv.marvin.udt.NormalizationActionChange;
import com.tandbergtv.marvin.udt.RuleResults;
import com.tandbergtv.marvin.udt.TreAction;
import com.tandbergtv.marvin.udt.TreActionParameterValue;
import com.tandbergtv.marvin.udt.TreCustomRule;
import com.tandbergtv.marvin.udt.TreCustomRuleParameter;
import com.tandbergtv.marvin.udt.TreRule;
import com.tandbergtv.marvin.udt.TreStandardRule;
import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.ChangeListener;
import com.tandbergtv.metadatamanager.model.Field;
import com.tandbergtv.metadatamanager.model.FieldTree;
import com.tandbergtv.metadatamanager.model.IField;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import java.lang.reflect.InvocationTargetException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class Evaluator {
    private static final Logger logger = Logger.getLogger(Evaluator.class);
    private static final CustomRuleProvider customRuleProvider = CustomRuleProvider.getInstance();
    private static final SimpleDateFormat mdmCompFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");

    public void evaluateRules(final Integer ruleSetId, final String ruleSetName, List<TreRule> rules, TitleExt title, final RuleResults result) throws EvaluatorException, IllegalOperationException, IllegalArgumentException, IllegalAccessException, InvocationTargetException, ClassNotFoundException, InstantiationException {
        String titleIdStr = "";
        if (logger.isDebugEnabled()) {
            titleIdStr = title.getTitle().getId() != null ? title.getTitle().getId().toString() : "NEW TITLE";
        }
        for (final TreRule rule : rules) {
            EvaluatorResults evalResults;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Starting Evaluation of rule " + rule.getRuleId() + " titleId = " + titleIdStr));
            }
            if (rule.getRuleType().equals((Object)TreRule.RuleType.STANDARD_RULE)) {
                long t0 = System.currentTimeMillis();
                ExpNode expnode = ((TreStandardRule)rule).getConditions();
                RetNode node = null;
                if (expnode != null) {
                    RetTree tree = ((TreStandardRule)rule).getConditionAsTree();
                    node = tree.getRoot();
                }
                long t1 = System.currentTimeMillis();
                logger.debug((Object)("********** getConditions = " + (t1 - t0) + " ms" + " RuleId = " + rule.getRuleId() + " titleID = " + title.getTitle().getId()));
                evalResults = this.evaluateNode(node, title);
                long t2 = System.currentTimeMillis();
                logger.debug((Object)("********** evaluateNode = " + (t2 - t1) + " ms" + " RuleId = " + rule.getRuleId() + " titleID = " + title.getTitle().getId()));
                if (evalResults.passed()) {
                    this.triggerAction(rule, title, evalResults, result, rule.getRuleId(), ruleSetId, ruleSetName);
                    long t3 = System.currentTimeMillis();
                    logger.debug((Object)("********** triggerAction = " + (t3 - t2) + " ms" + " RuleId = " + rule.getRuleId() + " titleID = " + title.getTitle().getId()));
                }
            } else {
                TreCustomRule customRule = (TreCustomRule)rule;
                String className = customRule.getClassName();
                List params = customRule.getParameters();
                CustomRule crInstance = customRuleProvider.getCustomRuleInstance(className);
                Map<String, Object> rParams = this.buildCustomRuleParameters(crInstance, params);
                if (crInstance instanceof CustomValidationRule) {
                    CustomValidationRule cvr = (CustomValidationRule)crInstance;
                    if (cvr.evalulteCriteria(rParams, title.getTitle())) {
                        evalResults = new EvaluatorResults(true);
                        this.triggerAction(rule, title, evalResults, result, rule.getRuleId(), ruleSetId, ruleSetName);
                    }
                } else if (crInstance instanceof CustomNormalizationRule) {
                    ChangeListener changeListener = new ChangeListener(){

                        public void handleChange(String xpath, String assetPath, String previousValue, String newValue) {
                            result.addChange(new NormalizationActionChange(ruleSetId.intValue(), ruleSetName, rule.getRuleId().intValue(), "Custom Normalization Rule Actions", "custNormAction", assetPath, xpath, previousValue, newValue));
                        }
                    };
                    title.getTitle().getAsset().registerListener(changeListener);
                    CustomNormalizationRule cnr = (CustomNormalizationRule)crInstance;
                    result.merge(cnr.runRule(rParams, title.getTitle()));
                    title.getTitle().getAsset().unregisterListener(changeListener);
                }
            }
            if (!logger.isDebugEnabled()) continue;
            logger.debug((Object)("Finished Evaluation of rule " + rule.getRuleId() + " titleId = " + titleIdStr));
        }
        if (result.isAddedAssets()) {
            long t1 = System.currentTimeMillis();
            IContentClassService ccService = (IContentClassService)ServiceRegistry.getDefault().lookup(IContentClassService.class);
            try {
                ccService.applyContentClassMetadataForIngest(title.getTitle());
                long t2 = System.currentTimeMillis();
                logger.debug((Object)("********** applyContentClassMetadataForIngest = " + (t2 - t1) + " ms" + " titleId = " + title.getTitle().getId()));
            }
            catch (ContentClassPersistenceException e) {
                throw new EvaluatorException(e);
            }
        }
    }

    private Map<String, Object> buildCustomRuleParameters(CustomRule cr, List<TreCustomRuleParameter> params) throws CustomRuleLoadException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        List crParams = cr.getParameters(Locale.ENGLISH);
        if (crParams.size() != params.size()) {
            throw new CustomRuleLoadException("Parameters don't match for: " + cr.getClass());
        }
        block11: for (int i = 0; i < crParams.size(); ++i) {
            String key = ((CustomRuleParameter)crParams.get(i)).getKey();
            String value = params.get(i).getValue();
            if (!key.equals(params.get(i).getKey())) {
                throw new CustomRuleLoadException("Parameters don't match for: " + cr.getClass());
            }
            CustomRuleParameter.ParameterDataType dt = ((CustomRuleParameter)crParams.get(i)).getDataType();
            switch (dt) {
                case INTEGER: {
                    result.put(key, Integer.parseInt(value));
                    continue block11;
                }
                case BOOLEAN: {
                    result.put(key, Boolean.parseBoolean(value));
                    continue block11;
                }
                case FLOAT: {
                    result.put(key, Float.valueOf(Float.parseFloat(value)));
                    continue block11;
                }
                case LONG: {
                    result.put(key, Long.parseLong(value));
                    continue block11;
                }
                case DATE: {
                    try {
                        result.put(key, mdmCompFormatter.parse(value));
                        continue block11;
                    }
                    catch (ParseException e) {
                        throw new CustomRuleLoadException("unable to parse: " + value, e);
                    }
                }
                case TIME: {
                    result.put(key, value);
                    continue block11;
                }
                case STRING: {
                    result.put(key, value);
                    continue block11;
                }
                default: {
                    throw new CustomRuleLoadException("Unknown variable data type: " + dt.name());
                }
            }
        }
        return result;
    }

    public boolean evaluateTitleFilter(Integer ruleSetId, RetTree tree, TitleExt title, CriteriaMode criteriaMode) throws EvaluatorException, IllegalOperationException {
        if (!title.getTitleCriteriaMode().equals((Object)criteriaMode)) {
            return false;
        }
        if (!tree.hasCriteria()) {
            return true;
        }
        RetNode node = tree.getRoot();
        if (this.evaluateNode(node, title).passed()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Rule Set with Id: " + ruleSetId + " passed title filter."));
            }
            return true;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Rule Set with Id: " + ruleSetId + " failed title filter."));
        }
        return false;
    }

    public EvaluatorResults evaluateNode(RetNode node, TitleExt title) throws EvaluatorException, IllegalOperationException {
        if (node == null) {
            return new EvaluatorResults(true);
        }
        if (node instanceof RetOperand) {
            Predicate predicate = ((RetOperand)node).getPredicate();
            String xpath = predicate.getFieldLeft();
            String assetPath = predicate.getFieldLeftSectionType();
            FieldType fieldType = predicate.getFieldTypeLhs();
            if (title.isEvaluateAsset(fieldType, assetPath, xpath)) {
                List<Asset> assets = title.getAsset(assetPath);
                if (assets.size() == 0) {
                    return this.evaluatePredicateNoData(predicate);
                }
                return this.evaluatePredicateOnAssetWithAssets(predicate, assets, title);
            }
            if (predicate.getOperator().equals((Object)LogicalOperator.ISEMPTY) && fieldType.equals((Object)FieldType.ASSET) && !predicate.getNot().booleanValue()) {
                return this.handleIsEmpty(xpath, assetPath, title);
            }
            if (predicate.getOperator().equals((Object)LogicalOperator.FIELDINVALID)) {
                return this.handleFieldInvalid(predicate, title);
            }
            if (predicate.getOperator().isMultiField()) {
                return this.handleMultiField(predicate, title);
            }
            if (predicate instanceof PredicateRightField) {
                return this.evaluatePredicateRightField((PredicateRightField)predicate, title);
            }
            if (predicate instanceof PredicateComplex) {
                return this.evaluateComplex((PredicateComplex)predicate, title);
            }
            return this.evaluatePredicate(predicate, title);
        }
        EvaluatorResults result = new EvaluatorResults();
        RetOperator op = (RetOperator)node;
        EvaluatorResults left = this.evaluateNode(op.left, title);
        if (op.getOperator().equals("AND") && !left.passed()) {
            return result;
        }
        EvaluatorResults right = this.evaluateNode(op.right, title);
        if (op.getOperator().equals("AND") && !right.passed()) {
            return result;
        }
        if (left.passed() && right.passed()) {
            result = left;
            result.mergeResults(right);
        } else if (left.passed()) {
            result = left;
        } else if (right.passed()) {
            result = right;
        }
        return result;
    }

    private EvaluatorResults handleFieldInvalid(Predicate predicate, TitleExt title) throws EvaluatorException {
        String assetPath = predicate.getFieldLeftSectionType();
        String xpath = predicate.getFieldLeft();
        boolean not = predicate.getNot();
        boolean requiresMatched = title.requiresMatched(assetPath, xpath);
        if (TitleExt.dataTypeLookup(FieldType.ASSET, assetPath, xpath) == null || requiresMatched) {
            EvaluatorResults result = new EvaluatorResults(false);
            List<FieldTree> trees = title.getFieldTrees(assetPath, xpath);
            if (trees.isEmpty()) {
                return new EvaluatorResults(not);
            }
            for (FieldTree tree : trees) {
                boolean invalid = StrictFieldValidator.isInvalidFieldTreeValues(tree);
                if (invalid ^ not && requiresMatched) {
                    result.setPassed(true);
                    result.addMatchedItem(new MatchedItem(tree, assetPath));
                    continue;
                }
                if (!(invalid ^ not)) continue;
                result.setPassed(true);
                break;
            }
            return result;
        }
        List<? extends IField> fields = title.getFields(FieldType.ASSET, assetPath, xpath);
        if (fields.isEmpty()) {
            return new EvaluatorResults(not);
        }
        for (IField iField : fields) {
            if (!(StrictFieldValidator.isInvalidFieldValue(iField) ^ not)) continue;
            return new EvaluatorResults(true);
        }
        return new EvaluatorResults();
    }

    private boolean handleFieldInvalidEvalChild(Predicate predicate, Asset asset) throws EvaluatorException {
        String xpath;
        List<String> assetTypes = Arrays.asList(predicate.getFieldLeftSectionType().split("/"));
        List trees = asset.getFieldTreeForXpath(assetTypes = assetTypes.subList(assetTypes.size() - 1, assetTypes.size()), xpath = predicate.getFieldLeft());
        if (trees.isEmpty()) {
            return predicate.getNot();
        }
        boolean not = predicate.getNot();
        for (FieldTree t : trees) {
            if (!(StrictFieldValidator.isInvalidFieldTreeValues(t) ^ not)) continue;
            return true;
        }
        return false;
    }

    private boolean handleFieldInvalidEvalChild(Predicate predicate, FieldTree tree) throws EvaluatorException {
        List<FieldTree> trees = TitleExt.breakApartFieldTree(Arrays.asList(tree), predicate.getFieldLeft());
        boolean not = predicate.getNot();
        if (trees.isEmpty()) {
            return predicate.getNot();
        }
        for (FieldTree t : trees) {
            if (!(StrictFieldValidator.isInvalidFieldTreeValues(t) ^ not)) continue;
            return true;
        }
        return false;
    }

    private EvaluatorResults handleMultiField(Predicate predicate, TitleExt title) throws EvaluatorException {
        EvaluatorResults result = new EvaluatorResults();
        if (predicate.getFieldTypeLhs().equals((Object)FieldType.LICENSE)) {
            result.setPassed(MultiFieldDeterminator.determineIFieldList(predicate, title.getFields(predicate.getFieldTypeLhs(), predicate.getFieldLeftSectionType(), predicate.getFieldLeft())));
        } else {
            result.setPassed(MultiFieldDeterminator.determineFieldTreeList(predicate, title.getFieldTrees(predicate.getFieldLeftSectionType(), predicate.getFieldLeft())));
        }
        return result;
    }

    private EvaluatorResults evaluatePredicateRightField(PredicateRightField predicate, TitleExt title) throws EvaluatorException, IllegalOperationException {
        String xpathLhs = predicate.getFieldLeft();
        String assetPathLhs = predicate.getFieldLeftSectionType();
        FieldType fieldTypeLhs = predicate.getFieldTypeLhs();
        boolean requiresMatchedLhs = false;
        if (title.requiresMatched(fieldTypeLhs, assetPathLhs, xpathLhs)) {
            requiresMatchedLhs = true;
        }
        List<? extends IField> fieldsLhs = title.getFields(fieldTypeLhs, assetPathLhs, xpathLhs);
        String xpathRhs = predicate.getFieldRight();
        String assetPathRhs = predicate.getFieldRightSectionType();
        FieldType fieldTypeRhs = predicate.getFieldTypeRhs();
        boolean requiresMatchedRhs = false;
        if (title.requiresMatched(fieldTypeRhs, assetPathRhs, xpathRhs)) {
            requiresMatchedRhs = true;
        }
        List<? extends IField> fieldsRhs = title.getFields(fieldTypeRhs, assetPathRhs, xpathRhs);
        EvaluatorResults evalResults = new EvaluatorResults();
        if (requiresMatchedLhs && fieldsLhs.size() > 0) {
            for (IField iField : fieldsLhs) {
                if (requiresMatchedRhs && fieldsRhs.size() > 0) {
                    boolean alreadyAddedLhs = false;
                    for (IField iField2 : fieldsRhs) {
                        if (!this.evaluatePredicateRightFieldHelper(predicate, Arrays.asList(iField), Arrays.asList(iField2)).booleanValue()) continue;
                        evalResults.setPassed(true);
                        if (!alreadyAddedLhs) {
                            evalResults.addMatchedField((Field)iField);
                            alreadyAddedLhs = true;
                        }
                        evalResults.addMatchedField((Field)iField2);
                    }
                    continue;
                }
                if (!this.evaluatePredicateRightFieldHelper(predicate, Arrays.asList(iField), fieldsRhs).booleanValue()) continue;
                evalResults.setPassed(true);
                evalResults.addMatchedField((Field)iField);
            }
        } else {
            evalResults.setPassed(this.evaluatePredicateRightFieldHelper(predicate, fieldsLhs, fieldsRhs));
        }
        return evalResults;
    }

    private Boolean evaluatePredicateRightFieldHelper(PredicateRightField predicate, List<? extends IField> fieldsLhs, List<? extends IField> fieldsRhs) throws EvaluatorException, IllegalOperationException {
        if (fieldsLhs.isEmpty() && fieldsRhs.isEmpty()) {
            return Determinator.determine((Predicate)predicate, null, null);
        }
        if (fieldsRhs.isEmpty()) {
            for (IField iField : fieldsLhs) {
                if (!Determinator.determine((Predicate)predicate, iField, null)) continue;
                return true;
            }
        } else if (fieldsLhs.isEmpty()) {
            for (IField iField : fieldsRhs) {
                if (!Determinator.determine((Predicate)predicate, null, iField)) continue;
                return true;
            }
        } else {
            for (IField iField : fieldsLhs) {
                for (IField iField2 : fieldsRhs) {
                    if (!Determinator.determine((Predicate)predicate, iField, iField2)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private EvaluatorResults handleIsEmpty(String xpath, String assetPath, TitleExt title) {
        List<Asset> assets = title.getAsset(assetPath);
        EvaluatorResults res = new EvaluatorResults();
        for (Asset a : assets) {
            List flds = a.getAllFieldsForXpath(Arrays.asList(a.getAssetType()), xpath);
            if (!flds.isEmpty() && !((Field)flds.get(0)).getValue().isEmpty()) continue;
            res.setPassed(true);
            boolean requiresMatched = title.requiresMatched(assetPath, xpath);
            if (!requiresMatched) continue;
            List<FieldTree> trees = title.getFieldTreesWithEmptyValue(assetPath, xpath);
            if (trees.isEmpty()) {
                return res;
            }
            for (FieldTree tree : trees) {
                res.addMatchedItem(new MatchedItem(tree, assetPath));
            }
            Field f = a.updateFieldValue(xpath, "");
            res.addMatchedField(f);
        }
        return res;
    }

    private EvaluatorResults evaluatePredicateNoData(Predicate predicate) throws EvaluatorException, IllegalOperationException {
        EvaluatorResults result = new EvaluatorResults();
        if (predicate.getOperator().isMultiField()) {
            result.setPassed(MultiFieldDeterminator.determine(predicate));
        } else if (predicate instanceof PredicateComplex) {
            PredicateComplex complexPredicate = (PredicateComplex)predicate;
            result.setPassed(true);
            for (Predicate pred : complexPredicate.getChildren()) {
                if (pred.getOperator().isMultiField()) {
                    result.setPassed(MultiFieldDeterminator.determine(pred));
                    continue;
                }
                if (pred.getOperator().equals((Object)LogicalOperator.FIELDINVALID)) {
                    return new EvaluatorResults(pred.getNot());
                }
                if (Determinator.determine(pred)) continue;
                result.setPassed(false);
            }
        } else {
            result.setPassed(Determinator.determine(predicate));
        }
        return result;
    }

    private EvaluatorResults evaluatePredicateOnAssetWithAssets(Predicate predicate, List<Asset> assets, TitleExt title) throws EvaluatorException, IllegalOperationException {
        EvaluatorResults result = new EvaluatorResults();
        if (predicate.getOperator().isMultiField()) {
            result.setPassed(MultiFieldDeterminator.determineAssets(predicate, assets));
            return result;
        }
        for (Asset asset : assets) {
            boolean passes = true;
            if (predicate instanceof PredicateComplex) {
                passes = this.evaluateComplex((PredicateComplex)predicate, asset, title);
            } else if (!Determinator.determine(predicate, asset)) {
                passes = false;
            }
            if (!passes) continue;
            result.setPassed(passes);
            result.addMatchedAsset(asset);
        }
        return result;
    }

    private ArrayList<IField> getFieldsForXpath(Asset asset, String xpath) {
        ArrayList<IField> list = new ArrayList<IField>();
        for (Field f : asset.getFields()) {
            if (!f.getTtvXPath().startsWith(xpath)) continue;
            list.add((IField)f);
        }
        return list;
    }

    private EvaluatorResults evaluatePredicate(Predicate predicate, TitleExt title) throws EvaluatorException, IllegalOperationException {
        EvaluatorResults result = new EvaluatorResults();
        String xpathLhs = predicate.getFieldLeft();
        String assetPathLhs = predicate.getFieldLeftSectionType();
        FieldType fieldTypeLhs = predicate.getFieldTypeLhs();
        List<? extends IField> fieldsLhs = null;
        List<FieldTree> fieldTreesLhs = null;
        boolean requiresMatched = false;
        if (title.requiresMatched(fieldTypeLhs, assetPathLhs, xpathLhs)) {
            requiresMatched = true;
        }
        if (requiresMatched && TitleExt.dataTypeLookup(fieldTypeLhs, assetPathLhs, xpathLhs) == null) {
            fieldTreesLhs = title.getFieldTrees(assetPathLhs, xpathLhs);
        } else {
            fieldsLhs = title.getFields(fieldTypeLhs, assetPathLhs, xpathLhs);
        }
        if (fieldTreesLhs != null) {
            for (FieldTree ftree : fieldTreesLhs) {
                boolean passes = true;
                String xpath = predicate.getFieldLeft();
                List<IField> fields = EvalUtil.getFields(ftree, xpath, true);
                passes = this.evaluateComplexHelper(predicate, fields);
                if (!passes) continue;
                result.setPassed(passes);
                result.addMatchedItem(new MatchedItem(ftree, predicate.getFieldLeftSectionType()));
            }
        } else if (requiresMatched) {
            this.evaluateComplexHelperWMatched(predicate, fieldsLhs, result);
        } else {
            result.setPassed(this.evaluateComplexHelper(predicate, fieldsLhs));
        }
        return result;
    }

    private boolean evaluateComplex(PredicateComplex complexPredicate, Asset asset, TitleExt title) throws IllegalOperationException, EvaluatorException {
        for (Predicate pred : complexPredicate.getChildren()) {
            if (pred instanceof PredicateComplex) {
                logger.error((Object)"DUDE, you can't have complex within complex. It makes my brain hurt.");
                return false;
            }
            if (pred.getFieldLeft().isEmpty()) {
                if (pred.getOperator().isMultiField() && !MultiFieldDeterminator.determineAssets(pred, Arrays.asList(asset))) {
                    return false;
                }
                if (pred.getOperator().isMultiField() || Determinator.determine(pred, asset)) continue;
                return false;
            }
            if (pred.getOperator().equals((Object)LogicalOperator.FIELDINVALID)) {
                if (this.handleFieldInvalidEvalChild(pred, asset)) continue;
                return false;
            }
            if (pred.getOperator().isMultiField()) {
                String xpath;
                int end;
                List<String> assetTypes = pred.getFieldLeftSectionTypeAsList();
                List baseSectionType = complexPredicate.getFieldLeftSectionTypeAsList();
                int start = baseSectionType.size() - 1;
                if (MultiFieldDeterminator.determineFieldTreeList(pred, TitleExt.getFieldTrees(asset, assetTypes = assetTypes.subList(start, end = assetTypes.size()), xpath = pred.getFieldLeft()))) continue;
                return false;
            }
            ArrayList<IField> fieldsLhs = this.getFieldsForXpath(asset, pred.getFieldLeft());
            if (pred instanceof PredicateRightField && !this.handlePredicateRightFieldInCompex(fieldsLhs, (PredicateRightField)pred, title)) {
                return false;
            }
            if (this.evaluateComplexHelper(pred, fieldsLhs)) continue;
            return false;
        }
        return true;
    }

    private EvaluatorResults evaluateComplex(PredicateComplex complexPredicate, TitleExt title) throws IllegalOperationException, EvaluatorException {
        String xpath;
        String assetPath = complexPredicate.getFieldLeftSectionType();
        List<FieldTree> fieldTrees = title.getFieldTrees(assetPath, xpath = complexPredicate.getFieldLeft());
        if (fieldTrees.isEmpty()) {
            for (Predicate pred : complexPredicate.getChildren()) {
                if (pred.getOperator().isMultiField()) {
                    if (MultiFieldDeterminator.determine(pred)) continue;
                    return new EvaluatorResults(false);
                }
                if (pred.getOperator().equals((Object)LogicalOperator.FIELDINVALID)) {
                    return new EvaluatorResults(pred.getNot());
                }
                if (Determinator.determine(pred)) continue;
                return new EvaluatorResults(false);
            }
        }
        boolean requiresMatched = title.requiresMatched(assetPath, xpath);
        EvaluatorResults evalResults = new EvaluatorResults();
        for (FieldTree ftree : fieldTrees) {
            boolean passed = true;
            for (Predicate pred : complexPredicate.getChildren()) {
                if (pred instanceof PredicateComplex) {
                    logger.error((Object)"DUDE, you can't have complex within complex. It makes my brain hurt.");
                    return new EvaluatorResults(false);
                }
                if (pred.getOperator().isMultiField()) {
                    if (MultiFieldDeterminator.determineFieldTree(pred, ftree)) continue;
                    passed = false;
                    break;
                }
                if (pred.getOperator().equals((Object)LogicalOperator.FIELDINVALID)) {
                    if (this.handleFieldInvalidEvalChild(pred, ftree)) continue;
                    passed = false;
                    break;
                }
                List<IField> fieldsLhs = EvalUtil.getFields(ftree, pred.getFieldLeft(), true);
                if (pred instanceof PredicateRightField && !this.handlePredicateRightFieldInCompex(fieldsLhs, (PredicateRightField)pred, title)) {
                    passed = false;
                    continue;
                }
                if (this.evaluateComplexHelper(pred, fieldsLhs)) continue;
                passed = false;
                break;
            }
            if (passed && requiresMatched) {
                evalResults.addMatchedItem(new MatchedItem(ftree, assetPath));
                evalResults.setPassed(true);
                continue;
            }
            if (!passed) continue;
            evalResults.setPassed(true);
            break;
        }
        return evalResults;
    }

    private boolean handlePredicateRightFieldInCompex(List<IField> fieldsLhs, PredicateRightField predicate, TitleExt title) throws EvaluatorException, IllegalOperationException {
        String xpathRhs = predicate.getFieldLeft();
        String assetPathRhs = predicate.getFieldLeftSectionType();
        FieldType fieldTypeRhs = predicate.getFieldTypeLhs();
        List<? extends IField> fieldsRhs = title.getFields(fieldTypeRhs, assetPathRhs, xpathRhs);
        return this.evaluatePredicateRightFieldHelper(predicate, fieldsLhs, fieldsRhs);
    }

    private boolean evaluateComplexHelper(Predicate predicate, List<? extends IField> fields) throws IllegalOperationException, EvaluatorException {
        if (fields.size() == 0) {
            return Determinator.determine(predicate);
        }
        for (IField iField : fields) {
            if (!Determinator.determine(predicate, iField)) continue;
            return true;
        }
        return false;
    }

    private void evaluateComplexHelperWMatched(Predicate predicate, List<? extends IField> fields, EvaluatorResults result) throws IllegalOperationException, EvaluatorException {
        if (fields.size() == 0) {
            result.setPassed(Determinator.determine(predicate));
        } else {
            for (IField iField : fields) {
                if (!Determinator.determine(predicate, iField)) continue;
                result.addMatchedField((Field)iField);
                result.setPassed(true);
            }
        }
    }

    private void triggerAction(TreRule rule, TitleExt title, EvaluatorResults evalResults, RuleResults result, int ruleId, int ruleSetId, String ruleSetName) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, ClassNotFoundException, InstantiationException {
        List actions = rule.getActions();
        for (TreAction action : actions) {
            logger.debug((Object)action.getMethod());
            List params = action.getParams();
            for (TreActionParameterValue param : params) {
                if (!logger.isEnabledFor((Priority)Level.TRACE)) continue;
                logger.trace((Object)(param.getValueId() + param.getName() + " " + param.getValue()));
            }
        }
        Actionator.getActionator().actionate(actions, title, evalResults, result, ruleId, ruleSetId, ruleSetName);
    }
}

