/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.marvin.engine;

import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.FieldTree;
import com.tandbergtv.metadatamanager.model.FieldTreeNode;

public class MatchedItem {
    private Asset asset;
    private FieldTree fieldTree;
    private String assetPath;

    public MatchedItem(FieldTree fieldTree, String assetPath) {
        this.setAssetPath(assetPath);
        this.asset = this.getFieldTreeAsset(fieldTree.getRootElement());
        this.fieldTree = fieldTree;
    }

    private Asset getFieldTreeAsset(FieldTreeNode ftree) {
        if (ftree.getField() != null) {
            return ftree.getField().getParentAsset();
        }
        if (ftree.getChildren() != null) {
            for (FieldTreeNode ftn : ftree.getChildren()) {
                Asset result = this.getFieldTreeAsset(ftn);
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }

    public Asset getAsset() {
        return this.asset;
    }

    public FieldTree getFieldTree() {
        return this.fieldTree;
    }

    public void setFieldTree(FieldTree fieldTree) {
        this.fieldTree = fieldTree;
    }

    public void setAssetPath(String assetPath) {
        this.assetPath = assetPath;
    }

    public String getAssetPath() {
        return this.assetPath;
    }
}

