/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.marvin.engine;

import com.ericsson.cms.criteria.LogicalOperator;
import com.ericsson.cms.criteria.Predicate;
import com.ericsson.cms.criteria.PredicateRightValue;
import com.tandbergtv.marvin.engine.EvalUtil;
import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.FieldTree;
import com.tandbergtv.metadatamanager.model.FieldTreeNode;
import com.tandbergtv.metadatamanager.model.IField;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class MultiFieldDeterminator {
    public static boolean determineAssets(Predicate predicate, List<Asset> assets) {
        int count = assets.size();
        int rhsValue = Integer.parseInt((String)((PredicateRightValue)predicate).getValue().get(0));
        boolean result = false;
        LogicalOperator operator = predicate.getOperator();
        switch (operator) {
            case NUMINSTANCESEQUAL: {
                result = count == rhsValue;
                break;
            }
            case NUMINSTANCESGREATERTHAN: {
                result = count > rhsValue;
                break;
            }
            case NUMINSTANCESLESSTHAN: {
                boolean bl = result = count < rhsValue;
            }
        }
        if (predicate.getNot().booleanValue()) {
            return !result;
        }
        return result;
    }

    public static boolean determineFieldTreeList(Predicate predicate, List<FieldTree> fieldTrees) {
        return MultiFieldDeterminator.determineHelper(predicate, fieldTrees);
    }

    public static boolean determineIFieldList(Predicate predicate, List<? extends IField> fields) {
        int rhsValue = Integer.parseInt((String)((PredicateRightValue)predicate).getValue().get(0));
        LogicalOperator operator = predicate.getOperator();
        boolean result = false;
        String fieldLeft = predicate.getFieldLeft();
        switch (operator) {
            case NUMINSTANCESEQUAL: {
                result = fields.size() == rhsValue;
                break;
            }
            case NUMINSTANCESGREATERTHAN: {
                result = fields.size() > rhsValue;
                break;
            }
            case NUMINSTANCESLESSTHAN: {
                result = fields.size() < rhsValue;
                break;
            }
            case TOTALLENGTHEQUALS: {
                result = MultiFieldDeterminator.getFieldLength(fieldLeft, fields) == rhsValue;
                break;
            }
            case TOTALLENGTHGREATERTHAN: {
                result = MultiFieldDeterminator.getFieldLength(fieldLeft, fields) > rhsValue;
                break;
            }
            case TOTALLENGTHLESSTHAN: {
                boolean bl = result = MultiFieldDeterminator.getFieldLength(fieldLeft, fields) < rhsValue;
            }
        }
        if (predicate.getNot().booleanValue()) {
            return !result;
        }
        return result;
    }

    public static boolean determineFieldTree(Predicate predicate, FieldTree fieldTree) {
        ArrayList<FieldTree> ftrees = new ArrayList<FieldTree>();
        ftrees.add(fieldTree);
        return MultiFieldDeterminator.determineHelper(predicate, ftrees);
    }

    public static boolean determine(Predicate predicate) {
        return MultiFieldDeterminator.determineHelper(predicate, new ArrayList<FieldTree>());
    }

    private static boolean determineHelper(Predicate predicate, List<FieldTree> fieldTrees) {
        int rhsValue = Integer.parseInt((String)((PredicateRightValue)predicate).getValue().get(0));
        LogicalOperator operator = predicate.getOperator();
        boolean result = false;
        String fieldLeft = predicate.getFieldLeft();
        switch (operator) {
            case NUMINSTANCESEQUAL: {
                result = MultiFieldDeterminator.getFieldCount(fieldLeft, fieldTrees) == rhsValue;
                break;
            }
            case NUMINSTANCESGREATERTHAN: {
                result = MultiFieldDeterminator.getFieldCount(fieldLeft, fieldTrees) > rhsValue;
                break;
            }
            case NUMINSTANCESLESSTHAN: {
                result = MultiFieldDeterminator.getFieldCount(fieldLeft, fieldTrees) < rhsValue;
                break;
            }
            case TOTALLENGTHEQUALS: {
                result = MultiFieldDeterminator.getLength(fieldLeft, fieldTrees) == rhsValue;
                break;
            }
            case TOTALLENGTHGREATERTHAN: {
                result = MultiFieldDeterminator.getLength(fieldLeft, fieldTrees) > rhsValue;
                break;
            }
            case TOTALLENGTHLESSTHAN: {
                boolean bl = result = MultiFieldDeterminator.getLength(fieldLeft, fieldTrees) < rhsValue;
            }
        }
        if (predicate.getNot().booleanValue()) {
            return !result;
        }
        return result;
    }

    private static int getFieldCount(String fieldLeft, List<FieldTree> fieldTrees) {
        int cnt = 0;
        for (FieldTree fieldTree : fieldTrees) {
            FieldTreeNode root = fieldTree.getRootElement();
            List<String> tokens = MultiFieldDeterminator.tokenizeXpath(fieldLeft);
            cnt += MultiFieldDeterminator.getFieldCount(tokens, 1, root.getChildren());
        }
        return cnt;
    }

    private static int getFieldCount(List<String> tokens, int pos, List<FieldTreeNode> nodes) {
        int cnt = 0;
        for (FieldTreeNode child : nodes) {
            String token = tokens.get(pos);
            if (!child.getName().equals(token) && (!token.startsWith("@") || token.length() <= 1 || !token.substring(1).equals(child.getName()))) continue;
            if (tokens.size() - 1 == pos) {
                ++cnt;
                continue;
            }
            cnt += MultiFieldDeterminator.getFieldCount(tokens, pos + 1, child.getChildren());
        }
        return cnt;
    }

    private static List<String> tokenizeXpath(String xpath) {
        ArrayList<String> tokens = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(xpath, "/", false);
        while (tokenizer.hasMoreTokens()) {
            String str = tokenizer.nextToken();
            if (str.startsWith("tns:")) {
                str = str.substring(4);
            }
            tokens.add(str);
        }
        return tokens;
    }

    private static int getLength(String fieldLeft, List<FieldTree> fieldTrees) {
        List<IField> fields = EvalUtil.getFields(fieldTrees, fieldLeft, false);
        return MultiFieldDeterminator.getFieldLength(fieldLeft, fields);
    }

    private static int getFieldLength(String fieldLeft, List<? extends IField> fields) {
        int length = 0;
        for (IField iField : fields) {
            length += iField.getValue().length();
        }
        return length;
    }
}

