/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.marvin.engine;

import com.hazelcast.core.Hazelcast;
import com.tandbergtv.cms.rules.service.category.IPackageManager;
import com.tandbergtv.cms.rules.service.category.IRuleManagerCache;
import com.tandbergtv.cms.rules.service.category.TreRuleSetCachable;
import com.tandbergtv.marvin.engine.UpdateRulesCacheMessage;
import com.tandbergtv.marvin.udt.TrePackage;
import com.tandbergtv.marvin.udt.TreRuleSet;
import com.tandbergtv.neptune.util.InjectionUtil;
import com.tandbergtv.workflow.core.service.Cluster;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.core.service.internal.DistributedTopic;
import com.tandbergtv.workflow.core.service.topic.ITopicMessageListener;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.ejb.Local;
import javax.naming.InitialContext;
import javax.transaction.TransactionManager;
import org.apache.log4j.Logger;
import org.jboss.ejb3.annotation.Depends;
import org.jboss.ejb3.annotation.Service;

@Service
@Local(value={IRuleManagerCache.class})
@Depends(value={"Neptune:service=com.tandbergtv.neptune.clustermgmt.service.IClusterConfigurationService"})
public class RuleManagerCache
implements IRuleManagerCache,
ITopicMessageListener<UpdateRulesCacheMessage> {
    private static final String DISTRIBUTED_RULES_TOPIC_NAME = "DistributedRulesTopic";
    private Map<String, List<TreRuleSetCachable>> rulesByPackage = new HashMap<String, List<TreRuleSetCachable>>();
    private Map<Integer, TreRuleSetCachable> rulesById = new HashMap<Integer, TreRuleSetCachable>();
    private static final Logger logger = Logger.getLogger(RuleManagerCache.class);
    private TransactionManager transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
    private IPackageManager packageManager = (IPackageManager)InjectionUtil.injectInstance((String)"cms/PackageManagerImpl/local", IPackageManager.class);
    private DistributedTopic<UpdateRulesCacheMessage> distributedTitleTopic;

    public RuleManagerCache() throws Exception {
        boolean isTransactionOwner;
        logger.info((Object)"Bringing up the RuleManagerCache.");
        if (Hazelcast.getConfig() != null) {
            logger.info((Object)("RuleManagerCache is a part of cluster: " + Hazelcast.getConfig().getGroupConfig().getName()));
        }
        this.distributedTitleTopic = new DistributedTopic(DISTRIBUTED_RULES_TOPIC_NAME);
        ServiceRegistry.getDefault().register(this.distributedTitleTopic.getServiceName(), this.distributedTitleTopic);
        this.distributedTitleTopic.start();
        this.distributedTitleTopic.subscribe((ITopicMessageListener)this);
        boolean bl = isTransactionOwner = this.transactionManager.getTransaction() == null;
        if (!isTransactionOwner) {
            this.load();
        } else {
            this.transactionManager.begin();
            this.load();
            this.transactionManager.commit();
        }
    }

    public void onMessage(UpdateRulesCacheMessage msg) {
        logger.info((Object)("Got message rulesCache message from " + msg.getSender()));
        if (Cluster.isLocalMemberAddress((InetSocketAddress)msg.getSender())) {
            logger.info((Object)("Skipping local message from " + msg.getSender()));
            return;
        }
        try {
            this.transactionManager.begin();
            TrePackage pack = this.packageManager.getPackageByNameFirstMatching(msg.getPackageToReload());
            this.loadCacheHelper(pack);
            msg.setPackageToReload(pack.getName());
            this.transactionManager.commit();
        }
        catch (Exception e) {
            try {
                this.transactionManager.rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
            logger.error((Object)e);
        }
    }

    private void load() {
        List packs = this.packageManager.getPackages();
        for (TrePackage p : packs) {
            this.loadCacheHelper(p);
        }
    }

    private synchronized void loadCacheHelper(TrePackage pack) {
        if (pack == null) {
            return;
        }
        HashMap<Integer, TreRuleSetCachable> tempRulesById = new HashMap<Integer, TreRuleSetCachable>();
        ArrayList<TreRuleSetCachable> newPack = new ArrayList<TreRuleSetCachable>();
        if (pack.getRuleSets() != null) {
            for (TreRuleSet treRuleSet : pack.getRuleSets()) {
                TreRuleSetCachable rsc = new TreRuleSetCachable(treRuleSet);
                newPack.add(rsc);
            }
        }
        this.rulesByPackage.put(pack.getName(), newPack);
        for (Map.Entry entry : this.rulesByPackage.entrySet()) {
            for (TreRuleSetCachable rs : (List)entry.getValue()) {
                tempRulesById.put(rs.getRuleSetId(), rs);
            }
        }
        this.rulesById = tempRulesById;
    }

    public void loadCache(String packageName) {
        UpdateRulesCacheMessage msg = new UpdateRulesCacheMessage();
        boolean triedToCreateTransaction = false;
        try {
            if (this.transactionManager.getStatus() == 0) {
                TrePackage pack = this.packageManager.getPackageByNameFirstMatching(packageName);
                this.loadCacheHelper(pack);
                msg.setPackageToReload(pack.getName());
            } else {
                triedToCreateTransaction = true;
                this.transactionManager.begin();
                TrePackage pack = this.packageManager.getPackageByNameFirstMatching(packageName);
                this.loadCacheHelper(pack);
                msg.setPackageToReload(pack.getName());
                this.transactionManager.commit();
            }
            this.distributedTitleTopic.publish((Object)msg);
        }
        catch (Exception e) {
            if (triedToCreateTransaction) {
                try {
                    this.transactionManager.rollback();
                }
                catch (Exception e1) {
                    // empty catch block
                }
            }
            throw new RuntimeException(e);
        }
    }

    public TreRuleSetCachable getRuleSet(Integer ruleSetId) {
        return this.rulesById.get(ruleSetId);
    }

    public Collection<TreRuleSetCachable> getRuleSets(Collection<Integer> ruleSetIds) {
        LinkedList<TreRuleSetCachable> result = new LinkedList<TreRuleSetCachable>();
        for (Integer id : ruleSetIds) {
            TreRuleSetCachable rs = this.rulesById.get(id);
            if (rs == null) continue;
            boolean inserted = false;
            for (int i = 0; !inserted && i < result.size(); ++i) {
                TreRuleSetCachable current = (TreRuleSetCachable)result.get(i);
                if (current.getOrder() <= rs.getOrder()) continue;
                result.add(i, rs);
                inserted = true;
            }
            if (inserted) continue;
            result.add(rs);
        }
        return result;
    }

    public List<TreRuleSetCachable> getRuleSetsByPackage(String packageName) {
        return this.rulesByPackage.get(packageName);
    }
}

