/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.marvin.scheduler;

import com.ericsson.cms.scheduler.IRecoveryService;
import com.ericsson.cms.scheduler.ISchedulerCallback;
import com.tandbergtv.marvin.event.EventHandlerJob;
import com.tandbergtv.marvin.event.MessageHelper;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.naming.InitialContext;
import javax.transaction.TransactionManager;
import org.apache.log4j.Logger;

public class RuleSetSchedulerCallback
implements ISchedulerCallback {
    private static final Logger logger = Logger.getLogger(RuleSetSchedulerCallback.class);
    private static final String ASSOCIATED_ENTITY_TYPE_RULESET = "ruleset";

    public void performAction(long jobId, String associatedEntityType, Set<Long> associatedEntityIds, String filterName, Date filterValue, Date execDate, IRecoveryService rs) {
        logger.info((Object)("performAction() called with jobId : " + jobId + ", associatedEntityType : " + associatedEntityType + ", associatedEntityIds : " + associatedEntityIds + ", filterName : " + filterName + ", filterValue : " + filterValue + ", execDate : " + execDate));
        if (ASSOCIATED_ENTITY_TYPE_RULESET.equals(associatedEntityType)) {
            ArrayList<Long> associatedEntityIdsList = new ArrayList<Long>();
            associatedEntityIdsList.addAll(associatedEntityIds);
            String ruleSetIds = MessageHelper.marshallList(associatedEntityIdsList);
            TransactionManager transactionManager = null;
            try {
                List<Integer> rsIds = MessageHelper.unmarshallListInts(ruleSetIds);
                EventHandlerJob job = new EventHandlerJob();
                String correlationId = "jobs" + String.valueOf(jobId) + "|" + execDate.getTime();
                job.runRules(rsIds, null, correlationId);
            }
            catch (Exception e) {
                logger.error((Object)"Exception occurred while running rules.", (Throwable)e);
            }
            try {
                transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
                transactionManager.begin();
                rs.markDone();
                transactionManager.commit();
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        } else {
            logger.warn((Object)"Associated entityType other than ruleset is not handled by RuleSetSchedulerCallback.");
        }
    }
}

