/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.marvin.services;

import com.ericsson.rules.contract.ILicensingRule;
import com.ericsson.rules.contract.LicensingRule;
import com.tandbergtv.cms.rules.service.category.IRuleExecutionHandler;
import com.tandbergtv.marvin.udt.RuleResults;
import com.tandbergtv.marvin.udt.TrePackage;
import com.tandbergtv.marvin.udt.TreRuleSet;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.title.ITitleManager;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;

@Stateless
public class LicensingRuleImpl
implements ILicensingRule {
    @EJB
    private IRuleExecutionHandler eventHandler;
    @EJB
    private ITitleManager titleManager;
    @PersistenceContext(unitName="rulesds")
    private EntityManager entityManager;

    @TransactionAttribute
    public LicensingRule getLicensingRule(long licenseId) {
        TreRuleSet ruleSet = this.getRuleSet(licenseId);
        if (ruleSet == null) {
            return null;
        }
        return new LicensingRule(ruleSet.getRuleSetId(), ruleSet.getRuleName(), ruleSet.getEnabled(), ruleSet.getUpdateDate());
    }

    public List<Long> identifyLicenses(long titleId) {
        Title title = this.titleManager.get(Long.valueOf(titleId));
        RuleResults result = this.eventHandler.runRuler(title, new TrePackage("LICENSING"));
        return result.getLicenseIds();
    }

    @TransactionAttribute
    public boolean deleteAssignedLicensingRule(long licenseId) {
        TreRuleSet ruleSet = this.getRuleSet(licenseId);
        if (ruleSet != null) {
            TrePackage tpack = ruleSet.getTpackage();
            tpack.getRuleSets().remove(ruleSet);
        }
        return false;
    }

    private TreRuleSet getRuleSet(long licenseId) {
        String queryString = "SELECT rs FROM\tTreRuleSet rs JOIN\trs.rules r JOIN\tr.actions a JOIN\ta.params apv WHERE apv.name = :name AND\tapv.value = :value";
        Query query = this.entityManager.createQuery(queryString);
        query.setParameter("name", (Object)"licenseId");
        query.setParameter("value", (Object)String.valueOf(licenseId));
        List result = query.getResultList();
        if (result.size() == 1) {
            return (TreRuleSet)result.get(0);
        }
        return null;
    }

    public Set<Long> getAllAssigendLicences() {
        String queryString = "SELECT apv.value FROM\tTreActionParameterValue apv WHERE apv.name = :name ";
        Query query = this.entityManager.createQuery(queryString);
        query.setParameter("name", (Object)"licenseId");
        List result = query.getResultList();
        HashSet<Long> licIds = new HashSet<Long>(result.size());
        for (String str : result) {
            licIds.add(Long.valueOf(str));
        }
        return licIds;
    }
}

