/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.marvin.services;

import com.tandbergtv.cms.rules.service.category.IPackageManager;
import com.tandbergtv.cms.rules.service.category.PackageRetrievalException;
import com.tandbergtv.marvin.udt.TrePackage;
import java.util.Date;
import java.util.List;
import javax.annotation.security.RolesAllowed;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;

@Stateless
public class PackageManagerImpl
implements IPackageManager {
    @PersistenceContext(unitName="rulesds")
    private EntityManager entityManager;

    @TransactionAttribute
    public List<TrePackage> getPackages() {
        List result = this.entityManager.createQuery("select p FROM TrePackage p ").getResultList();
        return result;
    }

    @TransactionAttribute
    private List<TrePackage> getPackageByName(String packageName) {
        Query query = this.entityManager.createQuery("select p FROM TrePackage p where name = :packName ");
        query.setParameter("packName", (Object)packageName.toUpperCase());
        return query.getResultList();
    }

    @TransactionAttribute
    public TrePackage getPackageById(int packageId) {
        Query query = this.entityManager.createQuery("select p FROM TrePackage p where packageId = :packId ");
        query.setParameter("packId", (Object)packageId);
        TrePackage result = (TrePackage)query.getSingleResult();
        return result;
    }

    @RolesAllowed(value={"RulesManagement_Modify"})
    @TransactionAttribute
    public void updatePackage(TrePackage pack) {
        this.entityManager.merge((Object)pack);
    }

    @TransactionAttribute
    public TrePackage getPackageByNameFirstMatching(String packageName) throws PackageRetrievalException {
        List<TrePackage> results = this.getPackageByName(packageName);
        if (results.size() > 0) {
            return results.get(0);
        }
        throw new PackageRetrievalException("There are no packages with the name: " + packageName);
    }

    @TransactionAttribute
    public Date getLastUpdateTime(String packageName) {
        Query query = this.entityManager.createNativeQuery("select updatedate from tre_package where name = ?");
        query.setParameter(0, (Object)packageName);
        return (Date)query.getSingleResult();
    }

    @TransactionAttribute
    public Date getMaxUpdateTimeOfAll() {
        Query query = this.entityManager.createNativeQuery("select max(updatedate) from tre_package");
        return (Date)query.getSingleResult();
    }
}

