/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.marvin.services.customrules;

import com.ericsson.cms.criteria.ExpList;
import com.ericsson.cms.criteria.ExpNode;
import com.ericsson.cms.criteria.ExpValue;
import com.ericsson.cms.criteria.PredicateRightValue;
import com.tandbergtv.marvin.services.customrules.CustomRuleReplacement;
import com.tandbergtv.marvin.services.customrules.ICustomRuleTerminator;
import com.tandbergtv.marvin.udt.TreAction;
import com.tandbergtv.marvin.udt.TreActionParameterValue;
import com.tandbergtv.marvin.udt.TreCustomRule;
import com.tandbergtv.marvin.udt.TreCustomRuleParameter;
import com.tandbergtv.marvin.udt.TreRule;
import com.tandbergtv.marvin.udt.TreRuleSet;
import com.tandbergtv.marvin.udt.TreStandardRule;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.List;
import javax.naming.InitialContext;
import javax.persistence.EntityManager;
import javax.persistence.FlushModeType;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.transaction.TransactionManager;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import org.apache.log4j.Logger;
import org.jboss.ejb3.annotation.Service;

@Service
public class CustomRuleTerminator
implements ICustomRuleTerminator {
    private static final Logger logger = Logger.getLogger(CustomRuleTerminator.class);
    private static final String PRODUCT_DIR = "com.tandbergtv.cms.product.dir";
    private static final String PLUGIN_FOLDER_RELATIVE_PATH = "plugins" + File.separator + "rules" + File.separator + "ruleReplacements";
    @PersistenceContext(unitName="rulesds")
    private EntityManager entityManager;

    @Override
    public void start() throws Exception {
        this.replaceCustomRules();
    }

    private TransactionManager getCurrentTransaction() {
        TransactionManager transactionManager = null;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
        }
        catch (Exception e) {
            logger.error((Object)"Failed to get current transaction manager", (Throwable)e);
        }
        return transactionManager;
    }

    @Override
    public void replaceCustomRules() {
        File[] replacements;
        for (File ruleFile : replacements = this.getFiles()) {
            TransactionManager t = this.getCurrentTransaction();
            try {
                t.begin();
                JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{CustomRuleReplacement.class});
                Unmarshaller u = jc.createUnmarshaller();
                CustomRuleReplacement ruleReplacement = (CustomRuleReplacement)u.unmarshal(ruleFile);
                String custRuleName = ruleReplacement.getCustomRuleSignature();
                List<TreRuleSet> ruleSets = this.getRuleSetsWCustRule(custRuleName);
                for (TreRuleSet rs : ruleSets) {
                    List rules = rs.getRules();
                    int i = 0;
                    while (i < rules.size()) {
                        TreRule r = (TreRule)rules.get(i);
                        if (r instanceof TreCustomRule && ((TreCustomRule)r).getClassName().equals(custRuleName)) {
                            List<TreStandardRule> rRules = this.convertRule(ruleReplacement, (TreCustomRule)r);
                            rules.remove(i);
                            for (TreStandardRule rRule : rRules) {
                                rules.add(i++, rRule);
                            }
                            continue;
                        }
                        ++i;
                    }
                }
                t.commit();
                File newFile = new File(ruleFile.getAbsoluteFile() + ".upgraded");
                if (newFile.exists()) {
                    logger.debug((Object)("What the fudge, you already had a file: " + newFile.getAbsolutePath()));
                    newFile.delete();
                }
                ruleFile.renameTo(newFile);
            }
            catch (Exception e) {
                logger.error((Object)("I don't think this is going to have a happy ending, error while trying to process custom rule replacement file: " + ruleFile.getAbsolutePath()), (Throwable)e);
                try {
                    t.rollback();
                }
                catch (Exception e1) {
                    logger.error((Object)("I told you this wouldn't have a happy ending, error while trying to rollback: " + ruleFile.getAbsolutePath()), (Throwable)e1);
                }
            }
        }
    }

    private File[] getFiles() {
        String installFolder = System.getProperty(PRODUCT_DIR);
        File pluginDir = new File(installFolder + File.separator + PLUGIN_FOLDER_RELATIVE_PATH);
        if (!pluginDir.exists()) {
            return new File[0];
        }
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".xml");
            }
        };
        return pluginDir.listFiles(filter);
    }

    private List<TreStandardRule> convertRule(CustomRuleReplacement replacement, TreCustomRule currRule) {
        ArrayList<TreStandardRule> results = new ArrayList<TreStandardRule>();
        List parameters = currRule.getParameters();
        for (TreStandardRule r : replacement.getRules()) {
            TreStandardRule tsr = r.clone();
            for (TreCustomRuleParameter crParam : parameters) {
                for (TreAction action : tsr.getActions()) {
                    for (TreActionParameterValue param : action.getParams()) {
                        if (param.getValue() == null || !param.getValue().contains("{" + crParam.getKey() + "}")) continue;
                        param.setValue(param.getValue().replace("{" + crParam.getKey() + "}", crParam.getValue()));
                    }
                }
                if (tsr.getConditions() == null) continue;
                this.navigateExpNodes(tsr.getConditions(), crParam);
            }
            results.add(tsr);
        }
        return results;
    }

    private void navigateExpNodes(ExpNode node, TreCustomRuleParameter crParam) {
        block3: {
            block2: {
                if (!(node instanceof ExpValue) || !(((ExpValue)node).getPredicate() instanceof PredicateRightValue)) break block2;
                PredicateRightValue prv = (PredicateRightValue)((ExpValue)node).getPredicate();
                List values = prv.getValue();
                for (int i = 0; i < values.size(); ++i) {
                    if (!((String)values.get(i)).contains("{" + crParam.getKey() + "}")) continue;
                    values.set(i, ((String)values.get(i)).replace("{" + crParam.getKey() + "}", crParam.getValue()));
                }
                break block3;
            }
            if (!(node instanceof ExpList)) break block3;
            List children = ((ExpList)node).getNodes();
            for (ExpNode child : children) {
                this.navigateExpNodes(child, crParam);
            }
        }
    }

    private List<TreRuleSet> getRuleSetsWCustRule(String customRule) {
        StringBuffer str = new StringBuffer();
        str.append("SELECT rs ");
        str.append("FROM\tTreRuleSet rs ");
        str.append("JOIN\trs.rules cr ");
        str.append("WHERE\tcr.className = :customRule");
        Query query = this.entityManager.createQuery(str.toString());
        query.setFlushMode(FlushModeType.COMMIT);
        query.setParameter("customRule", (Object)customRule);
        List result = query.getResultList();
        return result;
    }
}

