/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.scheduler;

import com.ericsson.cms.scheduler.ActionContext;
import com.ericsson.cms.scheduler.ExecutionContext;
import com.ericsson.cms.scheduler.IRecoveryService;
import com.ericsson.cms.scheduler.ISchedulerCallback;
import com.ericsson.cms.scheduler.IWOScheduler;
import com.ericsson.cms.scheduler.IWOSchedulerClient;
import com.ericsson.cms.scheduler.entities.WOJob;
import com.tandbergtv.metadatamanager.model.Field;
import com.tandbergtv.neptune.util.InjectionUtil;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.title.ITitleManager;
import com.tandbergtv.watchpoint.pmm.util.XMLDocumentUtility;
import com.tandbergtv.workflow.comm.routing.IRoutingService;
import com.tandbergtv.workflow.comm.routing.RoutingServiceFactory;
import com.tandbergtv.workflow.message.IMessage;
import com.tandbergtv.workflow.message.IPayload;
import com.tandbergtv.workflow.message.MessageImpl;
import com.tandbergtv.workflow.message.StringPayload;
import com.tandbergtv.workflow.message.WPCLCommand;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.message.WorkflowMessageFactory;
import com.tandbergtv.workflow.message.WorkflowPayload;
import com.tandbergtv.workflow.message.util.Marshaller;
import java.io.InvalidClassException;
import java.io.NotSerializableException;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.InitialContext;
import javax.transaction.TransactionManager;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class WOSchedulerCallback
implements ISchedulerCallback {
    private static final Logger logger = Logger.getLogger(WOSchedulerCallback.class);
    private static final String REFERENCE_PREFIX = "$";
    private static final String EXEC_DATE = "General.Job Execution Date";
    private static final String TITLE_METADATA_PREFIX = "Title Metadata.";
    private static final String TITLE_ID = "titleId";
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    private static final String PROCESSED_ENTITY_IDS = "ProcessedEntityIds";
    private static final String PROCESSED_ENTITY_TITLE_IDS = "ProcessedEntityTitleIdMap";
    private static final Long NO_ENTITY_ID = -1L;

    public void performAction(long jobId, String associatedEntityType, Set<Long> associatedEntityIds, String filterName, Date filterValue, Date execDate, IRecoveryService rs) {
        logger.debug((Object)("WOSchedulerCallback: " + associatedEntityType + " | " + associatedEntityIds + " | " + filterName + " | " + filterValue + " | " + execDate));
        if (associatedEntityIds == null || associatedEntityIds.isEmpty()) {
            associatedEntityIds = new HashSet<Long>();
            associatedEntityIds.add(null);
        }
        if (filterName == null) {
            this.processTitleIndependentJob(jobId, associatedEntityType, associatedEntityIds, execDate, rs);
        } else {
            this.processTitleDependentJob(jobId, associatedEntityType, associatedEntityIds, filterName, filterValue, execDate, rs);
        }
        TransactionManager transactionManager = null;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            transactionManager.begin();
            rs.deleteAll();
            rs.markDone();
            transactionManager.commit();
        }
        catch (Throwable t) {
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                logger.error((Object)"Could not rollback transaction: ", (Throwable)e1);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processTitleDependentJob(long jobId, String associatedEntityType, Set<Long> associatedEntityIds, String filterName, Date filterValue, Date execDate, IRecoveryService rs) {
        IWOSchedulerClient client = this.getWOScheduler().getClientByName(associatedEntityType);
        WOJob woJob = this.getWOScheduler().getScheduleByJobIdInternal(jobId);
        if (rs.isRecovering()) {
            try {
                associatedEntityIds = this.getPendingAssociationIds(associatedEntityIds, rs);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Error while reading processedIds: ", e);
            }
        }
        for (Long associatedEntityId : associatedEntityIds) {
            ExecutionContext ec = client.getExecutionContext(associatedEntityId, filterName, filterValue);
            if (ec.getActionContexts() != null) {
                List<ActionContext> acs = ec.getActionContexts();
                if (rs.isRecovering()) {
                    acs = associatedEntityId == null ? this.getPendingContexts(NO_ENTITY_ID, acs, rs) : this.getPendingContexts(associatedEntityId, acs, rs);
                }
                for (ActionContext ac : acs) {
                    HashMap<String, String> variables = new HashMap<String, String>();
                    if (woJob.getWoMappingParams() != null) {
                        for (Map.Entry entry : woJob.getWoMappingParams().entrySet()) {
                            String paramValue = null;
                            if (((String)entry.getKey()).equals(TITLE_ID)) {
                                paramValue = Long.toString(ac.getTitleId());
                            } else if (entry.getValue() != null) {
                                if (((String)entry.getValue()).startsWith(REFERENCE_PREFIX)) {
                                    String reference = ((String)entry.getValue()).substring(REFERENCE_PREFIX.length());
                                    if (reference.equals(EXEC_DATE)) {
                                        paramValue = DATE_FORMAT.format(execDate);
                                    } else if (reference.startsWith(TITLE_METADATA_PREFIX)) {
                                        String titleReference = reference.substring(TITLE_METADATA_PREFIX.length());
                                        Title title = this.getTitleManager().get(Long.valueOf(ac.getTitleId()));
                                        paramValue = this.evaluate(title, titleReference);
                                    } else if (ac.getWorkOrderMappingParams() != null && ac.getWorkOrderMappingParams().containsKey(reference)) {
                                        paramValue = (String)ac.getWorkOrderMappingParams().get(reference);
                                    } else {
                                        if (ec.getCommonWOParams() == null || !ec.getCommonWOParams().containsKey(reference)) throw new RuntimeException("Invalid workorder mapping reference parameter. WOJobId: " + woJob.getId() + " | Param Value: " + (String)entry.getValue());
                                        paramValue = (String)ec.getCommonWOParams().get(reference);
                                    }
                                } else {
                                    paramValue = (String)entry.getValue();
                                }
                            }
                            variables.put((String)entry.getKey(), paramValue);
                        }
                    }
                    TransactionManager transactionManager = null;
                    try {
                        transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
                        transactionManager.begin();
                        boolean woRequestSubmitted = this.createWorkOrder(woJob.getTemplateName(), woJob.getPriority(), variables);
                        if (!woRequestSubmitted) continue;
                        if (associatedEntityId == null) {
                            this.saveProcessedTitleId(NO_ENTITY_ID, ac.getTitleId(), rs);
                        } else {
                            this.saveProcessedTitleId(associatedEntityId, ac.getTitleId(), rs);
                        }
                        transactionManager.commit();
                    }
                    catch (Throwable t) {
                        logger.error((Object)"Error while saving processed titleId: ", t);
                        try {
                            transactionManager.rollback();
                            throw new RuntimeException("Error while saving processed titleId: " + t.getMessage());
                        }
                        catch (Exception e1) {
                            logger.error((Object)"Could not rollback transaction: ", (Throwable)e1);
                        }
                        throw new RuntimeException("Error while saving processed titleId: " + t.getMessage());
                    }
                }
            }
            TransactionManager transactionManager = null;
            try {
                transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
                transactionManager.begin();
                if (associatedEntityId == null) {
                    this.saveEntityId(NO_ENTITY_ID, rs);
                } else {
                    this.saveEntityId(associatedEntityId, rs);
                }
                transactionManager.commit();
            }
            catch (Throwable t) {
                logger.error((Object)"Error while saving associatedEntityId: ", t);
                try {
                    transactionManager.rollback();
                    throw new RuntimeException("Error while saving associatedEntityId: " + t.getMessage());
                }
                catch (Exception e1) {
                    logger.error((Object)"Could not rollback transaction: ", (Throwable)e1);
                }
                throw new RuntimeException("Error while saving associatedEntityId: " + t.getMessage());
            }
        }
    }

    private List<ActionContext> getPendingContexts(Long associatedEntityId, List<ActionContext> acs, IRecoveryService rs) {
        TransactionManager transactionManager = null;
        List<Object> pendingAcs = new ArrayList();
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            transactionManager.begin();
            Map processedEntityTitleIds = (Map)((Object)rs.get(PROCESSED_ENTITY_TITLE_IDS));
            if (processedEntityTitleIds == null) {
                pendingAcs = acs;
            } else {
                Set processedTitles = (Set)processedEntityTitleIds.get(associatedEntityId);
                if (processedTitles == null) {
                    pendingAcs = acs;
                } else {
                    for (ActionContext ac : acs) {
                        if (processedTitles.contains(ac.getTitleId())) continue;
                        pendingAcs.add(ac);
                    }
                }
            }
            transactionManager.commit();
            return pendingAcs;
        }
        catch (Throwable t) {
            try {
                if (transactionManager != null && transactionManager.getTransaction() != null) {
                    transactionManager.getTransaction().rollback();
                }
            }
            catch (Exception e) {
                logger.error((Object)"Error while rolling back tx: ", t);
            }
            throw new RuntimeException("Error while reading persisted state: " + t);
        }
    }

    private void saveProcessedTitleId(long entityId, long titleId, IRecoveryService rs) throws InvalidClassException, NotSerializableException, ClassNotFoundException {
        HashSet<Long> processedTitleIds;
        HashMap processedEntityTitleIds = (HashMap)rs.get(PROCESSED_ENTITY_TITLE_IDS);
        if (processedEntityTitleIds == null) {
            processedEntityTitleIds = new HashMap();
            processedTitleIds = new HashSet<Long>();
            processedTitleIds.add(titleId);
        } else {
            processedTitleIds = (HashSet<Long>)processedEntityTitleIds.get(entityId);
            if (processedTitleIds == null) {
                processedTitleIds = new HashSet();
            }
            processedTitleIds.add(titleId);
        }
        processedEntityTitleIds.put(entityId, processedTitleIds);
        rs.save(PROCESSED_ENTITY_TITLE_IDS, (Serializable)processedEntityTitleIds);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processTitleIndependentJob(long jobId, String associatedEntityType, Set<Long> associatedEntityIds, Date execDate, IRecoveryService rs) {
        IWOSchedulerClient client = this.getWOScheduler().getClientByName(associatedEntityType);
        WOJob woJob = this.getWOScheduler().getScheduleByJobIdInternal(jobId);
        Set<Long> pendingAssociatedEntityIds = associatedEntityIds;
        if (rs.isRecovering()) {
            logger.debug((Object)("Recovering WO job: " + jobId));
            try {
                pendingAssociatedEntityIds = this.getPendingAssociationIds(associatedEntityIds, rs);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Error while reading processedIds: ", e);
            }
        }
        for (Long associatedEntityId : pendingAssociatedEntityIds) {
            HashMap<String, String> variables = new HashMap<String, String>();
            if (woJob.getWoMappingParams() != null) {
                Map clientParamValues = client.getParameterValuesForWorkOrderMapping(associatedEntityId);
                for (Map.Entry entry : woJob.getWoMappingParams().entrySet()) {
                    String paramValue = null;
                    if (entry.getValue() != null) {
                        if (((String)entry.getValue()).startsWith(REFERENCE_PREFIX)) {
                            String reference = ((String)entry.getValue()).substring(REFERENCE_PREFIX.length());
                            if (reference.equals(EXEC_DATE)) {
                                paramValue = DATE_FORMAT.format(execDate);
                            } else {
                                if (clientParamValues == null || !clientParamValues.containsKey(reference)) throw new RuntimeException("Invalid workorder mapping reference parameter. WOJobId: " + woJob.getId() + " | Param Value: " + (String)entry.getValue());
                                paramValue = (String)clientParamValues.get(reference);
                            }
                        } else {
                            paramValue = (String)entry.getValue();
                        }
                    }
                    variables.put((String)entry.getKey(), paramValue);
                }
            }
            TransactionManager transactionManager = null;
            try {
                transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
                transactionManager.begin();
                boolean woRequestSubmitted = this.createWorkOrder(woJob.getTemplateName(), woJob.getPriority(), variables);
                if (woRequestSubmitted) {
                    this.saveEntityId(associatedEntityId, rs);
                }
                transactionManager.commit();
            }
            catch (Throwable t) {
                try {
                    transactionManager.rollback();
                }
                catch (Exception e1) {
                    logger.error((Object)"Could not rollback transaction: ", (Throwable)e1);
                }
            }
        }
    }

    private void saveEntityId(Long associatedEntityId, IRecoveryService rs) throws ClassNotFoundException, InvalidClassException, NotSerializableException {
        HashSet<Long> peIds = (HashSet<Long>)rs.get(PROCESSED_ENTITY_IDS);
        if (peIds == null) {
            peIds = new HashSet<Long>();
        }
        if (associatedEntityId == null) {
            peIds.add(NO_ENTITY_ID);
        } else {
            peIds.add(associatedEntityId);
        }
        rs.save(PROCESSED_ENTITY_IDS, peIds);
    }

    private Set<Long> getPendingAssociationIds(Set<Long> associatedEntityIds, IRecoveryService rs) throws ClassNotFoundException {
        TransactionManager transactionManager = null;
        try {
            Set<Long> pendingIds;
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            transactionManager.begin();
            HashSet processedEntityIds = (HashSet)rs.get(PROCESSED_ENTITY_IDS);
            if (processedEntityIds == null) {
                pendingIds = associatedEntityIds;
            } else if (associatedEntityIds.size() == 1 && associatedEntityIds.contains(null) && processedEntityIds.contains(NO_ENTITY_ID)) {
                pendingIds = new HashSet<Long>();
            } else {
                pendingIds = new HashSet<Long>();
                for (Long id : associatedEntityIds) {
                    if (processedEntityIds.contains(id)) continue;
                    pendingIds.add(id);
                }
            }
            transactionManager.commit();
            if (pendingIds != null) {
                logger.debug((Object)("Pending association ids: " + pendingIds.toArray().toString()));
            }
            return pendingIds;
        }
        catch (Throwable t) {
            try {
                if (transactionManager != null && transactionManager.getTransaction() != null) {
                    transactionManager.getTransaction().rollback();
                }
            }
            catch (Exception e) {
                logger.error((Object)"Error while rolling back tx: ", t);
            }
            throw new RuntimeException("Error while reading persisted state: " + t);
        }
    }

    private String evaluate(Title title, String titleReference) {
        int xpathDelimIndex = titleReference.lastIndexOf(46);
        String assetReference = titleReference.substring(0, xpathDelimIndex);
        String[] assetTypes = assetReference.split("\\.");
        List<String> assetTypesList = Arrays.asList(assetTypes);
        String xpath = titleReference.substring(xpathDelimIndex + 1);
        List fields = title.getAsset().getAllFieldsForXpath(assetTypesList, xpath);
        if (fields == null || fields.isEmpty()) {
            return null;
        }
        return ((Field)fields.get(0)).getValue();
    }

    private boolean createWorkOrder(String templateName, String priority, Map<String, String> variables) {
        MessageImpl message = null;
        try {
            WorkflowMessage workflowMessage = WorkflowMessageFactory.createControlMessage((String)"PM0111");
            WPCLCommand command = new WPCLCommand("create");
            command.addParameter("_template", templateName);
            if (!priority.equals("_rules")) {
                command.addParameter("priority", priority);
            }
            workflowMessage.setCommand(command);
            WorkflowPayload workflowPayload = workflowMessage.getPayload();
            for (Map.Entry<String, String> variable : variables.entrySet()) {
                workflowPayload.putValue(variable.getKey(), variable.getValue());
            }
            Document document = Marshaller.newMarshaller().marshal(workflowMessage);
            StringPayload strPayload = new StringPayload(XMLDocumentUtility.convertToString((Node)document));
            message = new MessageImpl((IPayload)strPayload, workflowMessage.getAttachment());
        }
        catch (Exception e) {
            logger.error((Object)"Exception when preparing create workorder message to workflow.", (Throwable)e);
            return false;
        }
        try {
            IRoutingService router = RoutingServiceFactory.newInstance().createRoutingService();
            router.send((IMessage)message);
            logger.debug((Object)("Dropped WPCL: " + message.toString()));
        }
        catch (Exception e) {
            logger.error((Object)"Exception when sending create workorder message to workflow.", (Throwable)e);
            return false;
        }
        return true;
    }

    private IWOScheduler getWOScheduler() {
        return (IWOScheduler)InjectionUtil.injectInstance((String)"/cms/WOScheduler/local", IWOScheduler.class);
    }

    private ITitleManager getTitleManager() {
        return (ITitleManager)InjectionUtil.injectInstance((String)"/cms/TitleManagerProxy/local", ITitleManager.class);
    }
}

