/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.scheduler.authorization;

import com.ericsson.cms.scheduler.authorization.ISchedulerLicenseManager;
import com.ericsson.cms.scheduler.authorization.Messages;
import com.tandbergtv.neptune.authorization.entity.BasicModule;
import com.tandbergtv.neptune.authorization.entity.BasicPermission;
import com.tandbergtv.neptune.authorization.entity.IModule;
import com.tandbergtv.neptune.authorization.service.IModuleProvider;
import com.tandbergtv.neptune.licensing.InvalidLicenseException;
import com.tandbergtv.neptune.util.InjectionUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;

public class SchedulerModuleProvider
implements IModuleProvider {
    private static Logger logger = Logger.getLogger(SchedulerModuleProvider.class);
    private ISchedulerLicenseManager schedulerLicenseManager = (ISchedulerLicenseManager)InjectionUtil.injectInstance((String)"cms/SchedulerLicenseManager/local", ISchedulerLicenseManager.class);

    public Collection<IModule> getModules() {
        ArrayList<IModule> modules = new ArrayList<IModule>();
        try {
            boolean isLicensed = this.schedulerLicenseManager.isLicensed();
            if (isLicensed) {
                String moduleName = "Scheduler";
                String displayName = Messages.getString("SchedulerModule.DisplayName");
                BasicModule module = new BasicModule(moduleName, displayName);
                List permissions = module.getPermissions();
                displayName = Messages.getString("SchedulerModule.Permissions.View");
                permissions.add(new BasicPermission("View", displayName, moduleName));
                displayName = Messages.getString("SchedulerModule.Permissions.Create");
                permissions.add(new BasicPermission("Create", displayName, moduleName));
                displayName = Messages.getString("SchedulerModule.Permissions.Modify");
                permissions.add(new BasicPermission("Modify", displayName, moduleName));
                displayName = Messages.getString("SchedulerModule.Permissions.Delete");
                permissions.add(new BasicPermission("Delete", displayName, moduleName));
                displayName = Messages.getString("SchedulerModule.Permissions.Execute");
                permissions.add(new BasicPermission("Execute", displayName, moduleName));
                modules.add((IModule)module);
            }
        }
        catch (InvalidLicenseException e) {
            logger.error((Object)("Error while obtaining the Scheduler License : " + (Object)((Object)e)), (Throwable)e);
        }
        return modules;
    }
}

