/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.scheduler.quartz;

import com.ericsson.cms.scheduler.IRecoveryService;
import com.ericsson.cms.scheduler.IScheduler;
import com.ericsson.cms.scheduler.ISchedulerCallback;
import com.ericsson.cms.scheduler.RecoveryService;
import com.ericsson.cms.scheduler.entities.PastExecution;
import com.ericsson.cms.scheduler.entities.ScheduleRule;
import com.ericsson.cms.scheduler.entities.ScheduleRuleType;
import com.tandbergtv.watchpoint.pmm.dao.hibernate.HibernateContext;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.TransactionManager;
import org.apache.log4j.Logger;
import org.hibernate.Query;
import org.hibernate.Session;
import org.quartz.Job;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class QuartzCallback
implements Job {
    private static final Logger logger = Logger.getLogger(QuartzCallback.class);

    public void execute(JobExecutionContext execContext) throws JobExecutionException {
        JobDetail jobDetail = execContext.getJobDetail();
        Date lastExecDate = null;
        if (execContext.isRecovering()) {
            lastExecDate = new Date(execContext.getMergedJobDataMap().getLongValueFromString("QRTZ_FAILED_JOB_ORIG_TRIGGER_FIRETIME_IN_MILLISECONDS_AS_STRING"));
        }
        this.execute(jobDetail.getName(), execContext.getScheduledFireTime(), execContext.isRecovering(), lastExecDate);
    }

    public void execute(String jobName, Date execDate) {
        this.execute(jobName, execDate, false, null);
    }

    private void execute(String jobName, Date execDate, boolean recovering, Date lastExecDate) {
        ISchedulerCallback callback;
        com.ericsson.cms.scheduler.entities.Job job = this.getScheduler().getInternal(Long.parseLong(jobName));
        if (job == null) {
            logger.error((Object)("Exception while trying to execute the job: " + jobName + " | Job not found."));
            return;
        }
        if (!job.isActive() && !recovering) {
            return;
        }
        logger.info((Object)((recovering ? "Recovering" : "Executing") + " job: " + jobName));
        if (!recovering && job.getDisabledTimes().contains(execDate.getTime())) {
            logger.info((Object)("Job execution is disabled. | Job: " + job + ". Scheduled execution time: " + execDate));
            PastExecution pe = new PastExecution(job, execDate, execDate, false);
            pe.setFinished(true);
            this.save(pe);
            return;
        }
        Date origExecDate = execDate;
        PastExecution currentExecution = null;
        TransactionManager transactionManager = null;
        if (recovering) {
            try {
                transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
                transactionManager.begin();
                PastExecution lastExecution = null;
                List<PastExecution> pastExecutions = this.findUnfinishedExecution(job.getId(), lastExecDate);
                if (pastExecutions == null || pastExecutions.isEmpty()) {
                    logger.error((Object)("Cannot recover job: " + job + " | Reason: Cannot find unfinished past executions with last execution time: " + lastExecDate));
                    return;
                }
                if (pastExecutions.size() > 1) {
                    logger.error((Object)("Cannot recover job: " + job + " | Reason: Found multiple unfinished past executions with last execution time: " + lastExecDate));
                    return;
                }
                lastExecution = pastExecutions.get(0);
                origExecDate = lastExecution.getOriginalExecutionTime();
                currentExecution = new PastExecution(job, origExecDate, execDate, true);
                for (Map.Entry e : lastExecution.getData().entrySet()) {
                    currentExecution.putValue((String)e.getKey(), (byte[])e.getValue());
                }
                this.getSession().saveOrUpdate((Object)currentExecution);
                lastExecution.removeAllData();
                this.getSession().saveOrUpdate((Object)lastExecution);
            }
            catch (Exception e) {
                try {
                    transactionManager.setRollbackOnly();
                }
                catch (Exception e1) {
                    logger.error((Object)"Unable to set the transaction to rollback only", (Throwable)e1);
                }
                throw new RuntimeException(e);
            }
            finally {
                if (transactionManager != null) {
                    try {
                        if (transactionManager.getStatus() == 1) {
                            transactionManager.rollback();
                        } else {
                            transactionManager.commit();
                        }
                    }
                    catch (Exception e) {
                        logger.error((Object)"Unable to finalize the transaction (get status, commit/rollback)", (Throwable)e);
                    }
                }
            }
        }
        currentExecution = new PastExecution(job, origExecDate, execDate, true);
        this.save(currentExecution);
        Class callbackClass = job.getCallbackClass();
        try {
            callback = (ISchedulerCallback)callbackClass.newInstance();
        }
        catch (Exception e) {
            logger.error((Object)("Exception while trying to execute the job: " + jobName + " | Could not instantiate the callback class."), (Throwable)e);
            return;
        }
        String filterName = null;
        Date filterValue = null;
        ScheduleRule rule = job.getRule();
        if (rule.getType() == ScheduleRuleType.N_DAYS_FROM_METADATA) {
            filterName = rule.getParam(3).getValue();
            filterValue = this.getDate(rule.getParam(1).getValue(), rule.getParam(2).getValue(), origExecDate);
        }
        RecoveryService rs = new RecoveryService(recovering, currentExecution.getId());
        try {
            callback.performAction(job.getId().longValue(), job.getAssociatedEntityType(), job.getAssociatedEntities(), filterName, filterValue, origExecDate, (IRecoveryService)rs);
        }
        catch (Throwable t) {
            logger.error((Object)("Exception while trying to execute the job: " + jobName + " | Callback class threw an exception."), t);
        }
    }

    private List<PastExecution> findUnfinishedExecution(long jobId, Date lastExecDate) {
        String queryStr = "from PastExecution where job.id = :jobId and executionTime = :executionTime and finished = false";
        Session session = this.getSession();
        Query query = session.createQuery(queryStr);
        query.setLong("jobId", jobId);
        query.setTimestamp("executionTime", lastExecDate);
        return query.list();
    }

    private void save(PastExecution pe) {
        try {
            TransactionManager transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            transactionManager.begin();
            this.getSession().saveOrUpdate((Object)pe);
            transactionManager.commit();
        }
        catch (Exception e) {
            throw new RuntimeException("Exception while saving execution record.", e);
        }
    }

    private IScheduler getScheduler() {
        try {
            return (IScheduler)new InitialContext().lookup("/cms/Scheduler/local");
        }
        catch (NamingException e) {
            throw new RuntimeException("Scheduler cannot be obtained.", e);
        }
    }

    private Date getDate(String numDays, String beforeAfter, Date execDate) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(execDate);
        int numberOfDays = Integer.parseInt(numDays);
        if (beforeAfter.equalsIgnoreCase("after")) {
            calendar.add(5, -numberOfDays);
        } else if (beforeAfter.equalsIgnoreCase("before")) {
            calendar.add(5, numberOfDays);
        }
        return calendar.getTime();
    }

    private Session getSession() {
        return HibernateContext.getContext().getCurrentSession();
    }
}

