/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.sites.core;

import com.ericsson.cms.sites.core.ISiteManager;
import com.ericsson.cms.sites.core.entities.DistributionSiteTitle;
import com.ericsson.cms.sites.core.entities.DistributionStatus;
import com.ericsson.cms.sites.core.entities.SiteDistributionCacheObject;
import com.ericsson.cms.sites.core.entities.TrackingSiteTitle;
import com.ericsson.cms.sites.core.entities.TrackingStatus;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.tandbergtv.neptune.util.InjectionUtil;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import javax.naming.InitialContext;
import javax.transaction.TransactionManager;
import org.apache.log4j.Logger;

public class DistTimeoutManager
implements Serializable {
    private static final long serialVersionUID = 7005953599128236728L;
    private static final Logger logger = Logger.getLogger(DistTimeoutManager.class);
    private static DistTimeoutManager _instance;
    private Timer timer;
    private Map<DistributionSiteTitle, TimerTask> dstTimerTasksMap = Collections.synchronizedMap(new HashMap());
    private Map<TrackingSiteTitle, TimerTask> tstTimerTasksMap = Collections.synchronizedMap(new HashMap());
    private HazelcastInstance haz;
    private Map<DistributionSiteTitle, String> dstSiteTitleMapHaz;
    private Map<TrackingSiteTitle, String> trackingSiteTitleMapHaz;

    private DistTimeoutManager() {
        this.timer = new Timer();
        this.haz = Hazelcast.getDefaultInstance();
        this.dstSiteTitleMapHaz = this.haz.getMap("dstSiteTitleMapHaz");
        this.trackingSiteTitleMapHaz = this.haz.getMap("dstTrackingSiteTitleMapHaz");
    }

    public static synchronized DistTimeoutManager getInstance() {
        if (_instance == null) {
            _instance = new DistTimeoutManager();
        }
        return _instance;
    }

    public synchronized void errorOut(final DistributionSiteTitle dst, int timeoutMinutes) {
        TimerTask task = this.dstTimerTasksMap.get(dst);
        if (task != null) {
            task.cancel();
        }
        task = new TimerTask(){

            @Override
            public void run() {
                DistributionSiteTitle currentDST = null;
                TransactionManager transactionManager = null;
                try {
                    transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
                    transactionManager.begin();
                    DistTimeoutManager.this.dstTimerTasksMap.remove(dst);
                    DistTimeoutManager.this.dstSiteTitleMapHaz.remove(dst);
                    ISiteManager siteManager = DistTimeoutManager.this.getSiteManager();
                    currentDST = siteManager.getDistributionSiteTitleById(dst.getId().longValue());
                    if (currentDST == null) {
                        logger.error((Object)("Unable to set the Distribution Status | Reason: No DistributionStatusTitle found with id: " + dst.getId()));
                    } else if (currentDST.getStatus() != DistributionStatus.IN_PROGRESS) {
                        logger.debug((Object)("Not setting the Distribution Status for title: " + currentDST.getTitle().getId() + " in distribution site: " + currentDST.getDistributionSite().getId() + " to: " + DistributionStatus.FAILED + " | Reason: It is in status: " + currentDST.getStatus()));
                    } else {
                        siteManager.updateDistributionStatus(currentDST.getTitle().getId().longValue(), DistributionStatus.FAILED);
                    }
                    transactionManager.commit();
                }
                catch (Throwable t) {
                    logger.error((Object)("Unable to set the status for Distribution Status Title: " + dst.getId() + " to: " + DistributionStatus.FAILED), t);
                    try {
                        transactionManager.rollback();
                    }
                    catch (Exception e1) {
                        logger.error((Object)"Could not rollback transaction: ", (Throwable)e1);
                    }
                }
            }
        };
        this.dstTimerTasksMap.put(dst, task);
        String localAddress = this.haz.getCluster().getLocalMember().getInetSocketAddress().getAddress().getHostAddress();
        SiteDistributionCacheObject dstObj = new SiteDistributionCacheObject(dst.getId(), dst.getDistributionSite().getAlertDelayPeriod());
        this.dstSiteTitleMapHaz.put(dst, localAddress);
        Long to = (long)(timeoutMinutes * 60) * 1000L;
        this.timer.schedule(task, to);
        logger.info((Object)("Scheduling timer for distribution site title : " + dst.getDistributionSite().getId() + " on server: " + localAddress));
    }

    public synchronized void errorOut(final TrackingSiteTitle tst, int timeoutMinutes) {
        TimerTask task = this.tstTimerTasksMap.get(tst);
        if (task != null) {
            task.cancel();
        }
        task = new TimerTask(){

            @Override
            public void run() {
                TrackingSiteTitle currentTST = null;
                TransactionManager transactionManager = null;
                try {
                    transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
                    transactionManager.begin();
                    DistTimeoutManager.this.tstTimerTasksMap.remove(tst);
                    DistTimeoutManager.this.trackingSiteTitleMapHaz.remove(tst);
                    ISiteManager siteManager = DistTimeoutManager.this.getSiteManager();
                    currentTST = siteManager.getTrackingSiteTitle(tst.getTitle().getId().longValue(), tst.getTrackingSite().getId().intValue());
                    if (currentTST == null) {
                        logger.error((Object)("Unable to set the Tracking Status | Reason: No TrackingStatusTitle found for titleId: " + tst.getTitle().getId() + " and trackingSiteId: " + tst.getTrackingSite().getId()));
                    } else if (currentTST.getStatus() != TrackingStatus.DEPLOYMENT_IN_PROGRESS) {
                        logger.debug((Object)("Not setting the Tracking Status for title: " + currentTST.getTitle().getId() + " in tracking site: " + currentTST.getTrackingSite().getId() + " to: " + TrackingStatus.DEPLOYMENT_FAILED + " | Reason: It is in status: " + currentTST.getStatus()));
                    } else {
                        siteManager.updateTrackingStatus(currentTST.getTrackingSite().getId().intValue(), currentTST.getTitle().getId().longValue(), TrackingStatus.DEPLOYMENT_FAILED);
                    }
                    transactionManager.commit();
                }
                catch (Throwable t) {
                    logger.error((Object)("Unable to set the Tracking Status for title: " + tst.getTitle().getId() + " in tracking site: " + tst.getTrackingSite().getId() + " to: " + TrackingStatus.DEPLOYMENT_FAILED), t);
                    try {
                        transactionManager.rollback();
                    }
                    catch (Exception e1) {
                        logger.error((Object)"Could not rollback transaction: ", (Throwable)e1);
                    }
                }
            }
        };
        this.tstTimerTasksMap.put(tst, task);
        String localAddress = this.haz.getCluster().getLocalMember().getInetSocketAddress().getAddress().getHostAddress();
        this.trackingSiteTitleMapHaz.put(tst, localAddress);
        Long to = (long)(timeoutMinutes * 60) * 1000L;
        this.timer.schedule(task, to);
        logger.info((Object)("Scheduling timer for tracking site title : " + tst.getTitle().getId() + " on server: " + localAddress));
    }

    private ISiteManager getSiteManager() {
        return (ISiteManager)InjectionUtil.injectInstance((String)"cms/SiteManager/local", ISiteManager.class);
    }

    public synchronized void rescheduleTrackingSiteTitles(String failedAddress) {
        if (this.trackingSiteTitleMapHaz != null) {
            for (Map.Entry<TrackingSiteTitle, String> entry : this.trackingSiteTitleMapHaz.entrySet()) {
                final TrackingSiteTitle tst = entry.getKey();
                String address = entry.getValue();
                if (!failedAddress.equalsIgnoreCase(address)) continue;
                TimerTask task = this.tstTimerTasksMap.get(tst);
                int timeoutMinutes = tst.getTrackingSite().getAlertDelayPeriod();
                if (task != null) {
                    task.cancel();
                }
                task = new TimerTask(){

                    @Override
                    public void run() {
                        TrackingSiteTitle currentTST = null;
                        TransactionManager transactionManager = null;
                        try {
                            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
                            transactionManager.begin();
                            DistTimeoutManager.this.tstTimerTasksMap.remove(tst);
                            DistTimeoutManager.this.trackingSiteTitleMapHaz.remove(tst);
                            ISiteManager siteManager = DistTimeoutManager.this.getSiteManager();
                            currentTST = siteManager.getTrackingSiteTitle(tst.getTitle().getId().longValue(), tst.getTrackingSite().getId().intValue());
                            if (currentTST == null) {
                                logger.error((Object)("Unable to set the Tracking Status | Reason: No TrackingStatusTitle found for titleId: " + tst.getTitle().getId() + " and trackingSiteId: " + tst.getTrackingSite().getId()));
                            } else if (currentTST.getStatus() != TrackingStatus.DEPLOYMENT_IN_PROGRESS) {
                                logger.debug((Object)("Not setting the Tracking Status for title: " + currentTST.getTitle().getId() + " in tracking site: " + currentTST.getTrackingSite().getId() + " to: " + TrackingStatus.DEPLOYMENT_FAILED + " | Reason: It is in status: " + currentTST.getStatus()));
                            } else {
                                siteManager.updateTrackingStatus(currentTST.getTrackingSite().getId().intValue(), currentTST.getTitle().getId().longValue(), TrackingStatus.DEPLOYMENT_FAILED);
                            }
                            transactionManager.commit();
                        }
                        catch (Throwable t) {
                            logger.error((Object)("Unable to set the Tracking Status for title: " + tst.getTitle().getId() + " in tracking site: " + tst.getTrackingSite().getId() + " to: " + TrackingStatus.DEPLOYMENT_FAILED), t);
                            try {
                                transactionManager.rollback();
                            }
                            catch (Exception e1) {
                                logger.error((Object)"Could not rollback transaction: ", (Throwable)e1);
                            }
                        }
                    }
                };
                this.tstTimerTasksMap.put(tst, task);
                String localAddress = this.haz.getCluster().getLocalMember().getInetSocketAddress().getAddress().getHostAddress();
                this.trackingSiteTitleMapHaz.put(tst, localAddress);
                Long to = (long)(timeoutMinutes * 60) * 1000L;
                this.timer.schedule(task, to);
            }
        }
    }

    public synchronized void rescheduleDistSiteTitles(String failedAddress) {
        if (this.dstSiteTitleMapHaz != null) {
            for (Map.Entry<DistributionSiteTitle, String> entry : this.dstSiteTitleMapHaz.entrySet()) {
                final DistributionSiteTitle dst = entry.getKey();
                String address = entry.getValue();
                if (!failedAddress.equalsIgnoreCase(address)) continue;
                logger.info((Object)("re-schedule distribution timeout for failed address: " + failedAddress + " site title : " + dst.getDistributionSite().getId()));
                int timeoutMinutes = dst.getDistributionSite().getAlertDelayPeriod();
                TimerTask task = this.dstTimerTasksMap.get(dst);
                if (task != null) {
                    task.cancel();
                }
                task = new TimerTask(){

                    @Override
                    public void run() {
                        DistributionSiteTitle currentDST = null;
                        TransactionManager transactionManager = null;
                        try {
                            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
                            transactionManager.begin();
                            DistTimeoutManager.this.dstTimerTasksMap.remove(dst);
                            DistTimeoutManager.this.dstSiteTitleMapHaz.remove(dst);
                            ISiteManager siteManager = DistTimeoutManager.this.getSiteManager();
                            currentDST = siteManager.getDistributionSiteTitleById(dst.getId().longValue());
                            if (currentDST == null) {
                                logger.error((Object)("Unable to set the Distribution Status | Reason: No DistributionStatusTitle found with id: " + dst.getId()));
                            } else if (currentDST.getStatus() != DistributionStatus.IN_PROGRESS) {
                                logger.debug((Object)("Not setting the Distribution Status for title: " + currentDST.getTitle().getId() + " in distribution site: " + currentDST.getDistributionSite().getId() + " to: " + DistributionStatus.FAILED + " | Reason: It is in status: " + currentDST.getStatus()));
                            } else {
                                siteManager.updateDistributionStatus(currentDST.getTitle().getId().longValue(), DistributionStatus.FAILED);
                            }
                            transactionManager.commit();
                        }
                        catch (Throwable t) {
                            logger.error((Object)("Unable to set the status for Distribution Status Title: " + dst.getId() + " to: " + DistributionStatus.FAILED), t);
                            try {
                                transactionManager.rollback();
                            }
                            catch (Exception e1) {
                                logger.error((Object)"Could not rollback transaction: ", (Throwable)e1);
                            }
                        }
                    }
                };
                this.dstTimerTasksMap.put(dst, task);
                String localAddress = this.haz.getCluster().getLocalMember().getInetSocketAddress().getAddress().getHostAddress();
                this.dstSiteTitleMapHaz.put(dst, localAddress);
                Long to = (long)(timeoutMinutes * 60) * 1000L;
                this.timer.schedule(task, to);
            }
        }
    }
}

