/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.sites.distribution;

import com.ericsson.cms.sites.distribution.TemplateInfo;
import com.ericsson.cms.sites.distribution.TemplateVariable;
import com.ericsson.cms.sites.distribution.TemplateVariableDataType;
import com.ericsson.cms.sites.distribution.jaxb.DistributionTemplates;
import com.tandbergtv.neptune.configuration.service.IConfigurationService;
import com.tandbergtv.neptune.util.InjectionUtil;
import com.tandbergtv.watchpoint.pmm.title.template.ITitleTemplateProvider;
import com.tandbergtv.watchpoint.pmm.util.XMLDocumentUtility;
import com.tandbergtv.workflow.comm.routing.IRoutingService;
import com.tandbergtv.workflow.comm.routing.RoutingServiceFactory;
import com.tandbergtv.workflow.core.Datatype;
import com.tandbergtv.workflow.core.TaskVariable;
import com.tandbergtv.workflow.core.WorkflowTemplate;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.message.IMessage;
import com.tandbergtv.workflow.message.IPayload;
import com.tandbergtv.workflow.message.MessageImpl;
import com.tandbergtv.workflow.message.StringPayload;
import com.tandbergtv.workflow.message.WPCLCommand;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.message.WorkflowMessageFactory;
import com.tandbergtv.workflow.message.WorkflowPayload;
import com.tandbergtv.workflow.message.util.Marshaller;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class DistributionManager {
    private static final Logger logger = Logger.getLogger(DistributionManager.class);
    private static final String SITES_CONFIG_DIR = "site";
    private static final String CONFIG_FILE_PATH = "dist-templates.xml";
    private static final String VAR_SITEID = "siteId";
    private static final String VAR_TITLEID = "titleId";
    private static final String VAR_PROVIDERID = "providerId";
    private static DistributionManager _instance;
    private File configFile;
    private List<DistributionTemplates.DistributionTemplate> templateConfigurations;
    private long loadedFileModifiedTime;
    private IConfigurationService configReaderService = (IConfigurationService)InjectionUtil.injectInstance((String)"cms/ConfigurationService/local", IConfigurationService.class);

    private DistributionManager() {
        this.configFile = this.configReaderService.getFile(SITES_CONFIG_DIR, CONFIG_FILE_PATH);
    }

    public static synchronized DistributionManager getInstance() {
        if (_instance == null) {
            _instance = new DistributionManager();
        }
        return _instance;
    }

    public Set<TemplateInfo> getDistributionTemplatesInfo() throws RuntimeException {
        this.loadConfigurationIfModified();
        return this.fetchTemplateInfo();
    }

    public Set<TemplateInfo> getDistributionTemplateInfoByName(String templateName, String groupName) {
        HashSet<TemplateInfo> templateInfos = new HashSet<TemplateInfo>();
        WorkflowTemplate definition = this.getTemplate(templateName);
        if (definition == null) {
            logger.error((Object)("The template is not found in Workflow System. Template Name: " + templateName));
            return null;
        }
        TemplateInfo ti = new TemplateInfo();
        ti.setTemplateName(templateName);
        ti.setAssociatedResourceGroupName(groupName);
        for (TaskVariable variable : definition.getStartTaskVariables()) {
            if (!variable.isRequired()) continue;
            String variableName = variable.getVariableName();
            String mappedName = variable.getMappedName();
            Datatype dataType = variable.getDatatype();
            if (VAR_SITEID.equals(variableName) || VAR_TITLEID.equals(variableName) || VAR_PROVIDERID.equals(variableName)) continue;
            TemplateVariable templateVariable = new TemplateVariable();
            templateVariable.setMappedName(mappedName);
            templateVariable.setDataType(this.getTemplateVariableDateType(dataType));
            ti.addRequiredVariable(variable.getVariableName(), templateVariable);
        }
        if (!templateInfos.add(ti)) {
            logger.error((Object)("Ignoring duplicate distribution template configuration. Template Name: " + ti.getTemplateName()));
        }
        return templateInfos;
    }

    public Set<String> getDistributionTemplateNames() throws RuntimeException {
        HashSet<String> templateNames = new HashSet<String>();
        for (TemplateInfo ti : this.getDistributionTemplatesInfo()) {
            templateNames.add(ti.getTemplateName());
        }
        return templateNames;
    }

    private boolean loadConfigurationIfModified() throws RuntimeException {
        if (!this.configFile.exists()) {
            throw new RuntimeException("File not found. Distribution templates config file: " + this.configFile);
        }
        if (this.configFile.lastModified() == this.loadedFileModifiedTime) {
            return false;
        }
        this.templateConfigurations = this.unmarshal(this.configFile);
        this.loadedFileModifiedTime = this.configFile.lastModified();
        return true;
    }

    public List<DistributionTemplates.DistributionTemplate> readTemplateConfigurations() {
        List<DistributionTemplates.DistributionTemplate> templateList = null;
        if (!this.configFile.exists()) {
            return null;
        }
        templateList = this.unmarshal(this.configFile);
        return templateList;
    }

    public List<DistributionTemplates.DistributionTemplate> unmarshal(File configFile) {
        logger.debug((Object)("Loading distribution templates conf from file: " + configFile));
        List<DistributionTemplates.DistributionTemplate> distTemplatesList = new ArrayList<DistributionTemplates.DistributionTemplate>();
        try {
            JAXBContext jc = JAXBContext.newInstance((String)(DistributionManager.class.getPackage().getName() + ".jaxb"));
            Unmarshaller unmarshaller = jc.createUnmarshaller();
            DistributionTemplates distTemplates = (DistributionTemplates)unmarshaller.unmarshal(configFile);
            distTemplatesList = distTemplates.getDistributionTemplate();
        }
        catch (Exception e) {
            logger.warn((Object)("Exception occured in loading distribution templates config from file: " + configFile), (Throwable)e);
        }
        return distTemplatesList;
    }

    public Set<TemplateInfo> getDistributionTemplateInfoByName(List<String> templateNames) {
        HashSet<TemplateInfo> templateInfos = new HashSet<TemplateInfo>();
        for (String templateName : templateNames) {
            WorkflowTemplate definition = this.getTemplate(templateName);
            if (definition == null) {
                logger.error((Object)("The template is not found in Workflow System. Template Name: " + templateName));
                continue;
            }
            TemplateInfo ti = new TemplateInfo();
            ti.setTemplateName(templateName);
            for (TaskVariable variable : definition.getStartTaskVariables()) {
                if (!variable.isRequired()) continue;
                String variableName = variable.getVariableName();
                String mappedName = variable.getMappedName();
                Datatype dataType = variable.getDatatype();
                if (VAR_SITEID.equals(variableName) || VAR_TITLEID.equals(variableName) || VAR_PROVIDERID.equals(variableName)) continue;
                TemplateVariable templateVariable = new TemplateVariable();
                templateVariable.setMappedName(mappedName);
                templateVariable.setDataType(this.getTemplateVariableDateType(dataType));
                ti.addRequiredVariable(variable.getVariableName(), templateVariable);
            }
            if (templateInfos.add(ti)) continue;
            logger.error((Object)("Ignoring duplicate distribution template configuration. Template Name: " + ti.getTemplateName()));
        }
        return templateInfos;
    }

    private Set<TemplateInfo> fetchTemplateInfo() throws RuntimeException {
        logger.debug((Object)"Fetching templates info from Workflow System");
        HashSet<TemplateInfo> templateInfos = new HashSet<TemplateInfo>();
        for (DistributionTemplates.DistributionTemplate templateConf : this.templateConfigurations) {
            WorkflowTemplate definition = this.getTemplate(templateConf.getTemplateName());
            if (definition == null) {
                logger.error((Object)("Ignoring distribution template configuration. Either the template does not have titleId as a start variable or the template is not found in Workflow System. Template Name: " + templateConf.getTemplateName()));
                continue;
            }
            TemplateInfo ti = new TemplateInfo();
            ti.setTemplateName(templateConf.getTemplateName());
            ti.setAssociatedResourceGroupName(templateConf.getAssociatedResourceGroupName());
            for (TaskVariable variable : definition.getStartTaskVariables()) {
                if (!variable.isRequired()) continue;
                String variableName = variable.getVariableName();
                String mappedName = variable.getMappedName();
                Datatype dataType = variable.getDatatype();
                if (VAR_SITEID.equals(variableName) || VAR_TITLEID.equals(variableName) || VAR_PROVIDERID.equals(variableName)) continue;
                TemplateVariable templateVariable = new TemplateVariable();
                templateVariable.setMappedName(mappedName);
                templateVariable.setDataType(this.getTemplateVariableDateType(dataType));
                ti.addRequiredVariable(variable.getVariableName(), templateVariable);
            }
            if (templateInfos.add(ti)) continue;
            logger.error((Object)("Ignoring duplicate distribution template configuration. Template Name: " + ti.getTemplateName()));
        }
        return templateInfos;
    }

    private WorkflowTemplate getTemplate(String name) throws RuntimeException {
        ITitleTemplateProvider service = (ITitleTemplateProvider)ServiceRegistry.getDefault().lookup(ITitleTemplateProvider.class);
        if (service == null) {
            throw new RuntimeException("Unable to get ITitleTemplateProvider service");
        }
        Collection allTitleTemplates = service.getTemplates();
        if (allTitleTemplates != null) {
            for (WorkflowTemplate template : allTitleTemplates) {
                if (!template.getName().equals(name)) continue;
                return template;
            }
        }
        return null;
    }

    private TemplateVariableDataType getTemplateVariableDateType(Datatype datatype) {
        TemplateVariableDataType templateVariableDataType = TemplateVariableDataType.STRING;
        switch (datatype) {
            case INT: {
                templateVariableDataType = TemplateVariableDataType.INTEGER;
                break;
            }
            case BOOLEAN: {
                templateVariableDataType = TemplateVariableDataType.BOOLEAN;
                break;
            }
            case DATE: {
                templateVariableDataType = TemplateVariableDataType.DATE;
                break;
            }
        }
        return templateVariableDataType;
    }

    public void distribute(int siteId, long titleId, String templateName, String associatedResourceConnStr, Map<String, String> requiredTemplateVariables) {
        HashMap<String, String> allVariables = new HashMap<String, String>();
        allVariables.putAll(requiredTemplateVariables);
        allVariables.put(VAR_SITEID, Integer.toString(siteId));
        allVariables.put(VAR_TITLEID, Long.toString(titleId));
        if (associatedResourceConnStr != null) {
            allVariables.put("associatedResource", associatedResourceConnStr);
        }
        WorkflowMessage message = this.createWorkFlowMessage(templateName, allVariables);
        IRoutingService router = RoutingServiceFactory.newInstance().createRoutingService();
        try {
            IMessage msg = this.convert(message);
            router.send(msg);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private WorkflowMessage createWorkFlowMessage(String templateName, Map<String, String> variables) {
        WorkflowMessage message = WorkflowMessageFactory.createControlMessage((String)"SM0109");
        WPCLCommand command = new WPCLCommand("create");
        command.addParameter("_template", templateName);
        message.setCommand(command);
        WorkflowPayload payload = message.getPayload();
        for (Map.Entry<String, String> variable : variables.entrySet()) {
            payload.putValue(variable.getKey(), variable.getValue());
        }
        return message;
    }

    private IMessage convert(WorkflowMessage message) throws Exception {
        Document document = Marshaller.newMarshaller().marshal(message);
        StringPayload payload = new StringPayload(XMLDocumentUtility.convertToString((Node)document));
        return new MessageImpl((IPayload)payload, message.getAttachment());
    }

    public List<DistributionTemplates.DistributionTemplate> getTemplateConfigurations() {
        return this.templateConfigurations;
    }

    public void deleteConfigFile() {
        boolean success = this.configFile.delete();
        if (success) {
            logger.info((Object)"Config file has been deleted");
        } else {
            logger.info((Object)"Config file has NOT been deleted");
        }
    }
}

