/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.sites.distribution;

import com.ericsson.cms.criteria.SearchColumn;
import com.ericsson.cms.criteria.info.SortingInfo;
import com.ericsson.cms.sites.distribution.SiteActivitySearchQueryBuilder;
import com.tandbergtv.metadatamanager.search.oracle.AssetSearchQueryBuilder;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;

public class PgSiteActivitySearchQueryBuilder
extends SiteActivitySearchQueryBuilder {
    private static final Logger logger = Logger.getLogger(PgSiteActivitySearchQueryBuilder.class);

    @Override
    PreparedStatement prepareDistSiteStatement(Connection conn, Integer distSiteId, Collection<Long> partnerIds, int status, Date fromDate, Date toDate, Integer trackSiteId, List<SearchColumn> columns, SortingInfo sortInfo, AssetSearchQueryBuilder assetSearchQueryBuilder) throws SQLException {
        StringBuilder sb = new StringBuilder(1000);
        sb.append("SELECT * FROM (").append("SELECT row_number() over (PARTITION BY dst.siteid, dst.titleid ORDER BY dst.status_updated_time desc) AS rownumber, ").append("dst.siteid, s.name AS sitename, dst.titleid, dst.status, dst.status_updated_time ");
        this.addMetadataColumnsInSelect(assetSearchQueryBuilder, columns, sb);
        sb.append(" FROM SITES_DISTSITETITLE dst ").append("JOIN PMM_TITLE T ON (t.id_ = dst.titleid) ").append("JOIN MDM_METADATA mdm ON (mdm.document_id = t.mdmdocid) ").append("JOIN SITES_SITE s ON (s.id_ = dst.siteid) ");
        if (distSiteId == null && trackSiteId != null) {
            sb.append("JOIN SITES_SITELINK sl ON (sl.parent = s.id_) ");
        }
        sb.append("WHERE TITLESTATUSID <> 5 AND dst.STATUS_UPDATED_TIME BETWEEN ? AND ? ");
        if (distSiteId == null && trackSiteId != null) {
            sb.append("AND sl.child = ? ");
        }
        if (distSiteId != null) {
            sb.append("AND dst.siteid = ? ");
        }
        this.appendPartners(partnerIds.size(), sb);
        sb.append(") WHERE rownumber = 1 and status = ? ");
        sb.append("ORDER BY siteid ");
        this.addOrderByClause(sortInfo, columns, sb);
        String sql = sb.toString();
        logger.debug((Object)("sql: " + sql));
        PreparedStatement statement = conn.prepareStatement(sql);
        int bindVarIndex = 1;
        statement.setTimestamp(bindVarIndex++, new Timestamp(fromDate.getTime()));
        statement.setTimestamp(bindVarIndex++, new Timestamp(toDate.getTime()));
        if (distSiteId == null && trackSiteId != null) {
            statement.setInt(bindVarIndex++, trackSiteId);
        }
        if (distSiteId != null) {
            statement.setInt(bindVarIndex++, distSiteId);
        }
        for (Long partnerId : partnerIds) {
            statement.setLong(bindVarIndex++, partnerId);
        }
        statement.setInt(bindVarIndex++, status);
        return statement;
    }

    @Override
    PreparedStatement prepareTrackSiteStatement(Connection conn, Integer distSiteId, Collection<Long> partnerIds, int status, Date fromDate, Date toDate, Integer trackSiteId, List<SearchColumn> columns, SortingInfo sortInfo, AssetSearchQueryBuilder assetSearchQueryBuilder) throws SQLException {
        StringBuilder sb = new StringBuilder(1000);
        sb.append("SELECT * FROM (").append("SELECT row_number() over (PARTITION BY tst.siteid, tst.titleid ORDER BY tst.status_updated_time desc) AS rownumber, ").append("tst.siteid, s.name AS sitename, tst.titleid, tst.status, tst.status_updated_time ");
        this.addMetadataColumnsInSelect(assetSearchQueryBuilder, columns, sb);
        sb.append(" FROM SITES_TRACKSITETITLE tst ").append("JOIN PMM_TITLE T ON (t.id_ = tst.titleid) ").append("JOIN MDM_METADATA mdm ON (mdm.document_id = t.mdmdocid) ").append("JOIN SITES_SITE s ON (s.id_ = tst.siteid) ");
        if (distSiteId != null) {
            sb.append("JOIN SITES_DISTSITETITLE dst ON (dst.titleid = tst.titleid)");
        }
        sb.append("WHERE TITLESTATUSID <> 5 AND tst.STATUS_UPDATED_TIME BETWEEN ? AND ? ");
        if (distSiteId != null) {
            sb.append("AND dst.siteid = ? ");
        }
        if (trackSiteId != null) {
            sb.append("AND tst.siteid = ? ");
        }
        this.appendPartners(partnerIds.size(), sb);
        sb.append(") WHERE rownumber = 1 and status = ? ");
        sb.append("ORDER BY siteid ");
        this.addOrderByClause(sortInfo, columns, sb);
        String sql = sb.toString();
        logger.debug((Object)("sql: " + sql));
        PreparedStatement statement = conn.prepareStatement(sql);
        int bindVarIndex = 1;
        statement.setTimestamp(bindVarIndex++, new Timestamp(fromDate.getTime()));
        statement.setTimestamp(bindVarIndex++, new Timestamp(toDate.getTime()));
        if (distSiteId != null) {
            statement.setInt(bindVarIndex++, distSiteId);
        }
        if (trackSiteId != null) {
            statement.setInt(bindVarIndex++, trackSiteId);
        }
        for (Long partnerId : partnerIds) {
            statement.setLong(bindVarIndex++, partnerId);
        }
        statement.setInt(bindVarIndex++, status);
        return statement;
    }
}

