/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.sites.distribution;

import com.ericsson.cms.criteria.FieldType;
import com.ericsson.cms.criteria.SearchColumn;
import com.ericsson.cms.criteria.info.SortOrder;
import com.ericsson.cms.criteria.info.SortingInfo;
import com.tandbergtv.metadatamanager.search.oracle.AssetSearchQueryBuilder;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;

public class SiteActivitySearchQueryBuilder {
    protected static final String METADATA_COLUMN_DISP_NAME_PREFIX = "t";
    private static final Logger logger = Logger.getLogger(SiteActivitySearchQueryBuilder.class);
    private Date minFlashbackTime;

    PreparedStatement prepareDistSiteStatement(Connection conn, Integer distSiteId, Collection<Long> partnerIds, int status, Date fromDate, Date toDate, Integer trackSiteId, List<SearchColumn> columns, SortingInfo sortInfo, AssetSearchQueryBuilder assetSearchQueryBuilder) throws SQLException {
        StringBuilder sb = new StringBuilder(1000);
        sb.append("SELECT * FROM (").append("SELECT row_number() over (PARTITION BY dst.siteid, dst.titleid ORDER BY dst.status_updated_time desc) AS rownumber, ").append("versions_operation, dst.siteid, s.name AS sitename, dst.titleid, dst.status, dst.status_updated_time ");
        this.addMetadataColumnsInSelect(assetSearchQueryBuilder, columns, sb);
        sb.append(" FROM SITES_DISTSITETITLE VERSIONS BETWEEN TIMESTAMP ? AND maxvalue dst ").append("JOIN PMM_TITLE T ON (t.id_ = dst.titleid) ").append("JOIN MDM_METADATA mdm ON (extractvalue(sys_nc_rowinfo$, '/ECMFSpec/@documentId') = t.mdmdocid) ").append("JOIN SITES_SITE s ON (s.id_ = dst.siteid) ");
        if (distSiteId == null && trackSiteId != null) {
            sb.append("JOIN SITES_SITELINK sl ON (sl.parent = s.id_) ");
        }
        sb.append("WHERE TITLESTATUSID <> 5 AND dst.STATUS_UPDATED_TIME BETWEEN ? AND ? ");
        if (distSiteId == null && trackSiteId != null) {
            sb.append("AND sl.child = ? ");
        }
        if (distSiteId != null) {
            sb.append("AND dst.siteid = ? ");
        }
        this.appendPartners(partnerIds.size(), sb);
        sb.append(") WHERE rownumber = 1 and NVL(versions_operation, 'MH') <> 'D' and status = ? ");
        sb.append("ORDER BY siteid ");
        this.addOrderByClause(sortInfo, columns, sb);
        String sql = sb.toString();
        logger.debug((Object)("sql: " + sql));
        PreparedStatement statement = conn.prepareStatement(sql);
        int bindVarIndex = 1;
        Date versionsFromDate = this.getOldestFromDate(conn, fromDate);
        statement.setTimestamp(bindVarIndex++, new Timestamp(versionsFromDate.getTime()));
        statement.setTimestamp(bindVarIndex++, new Timestamp(fromDate.getTime()));
        statement.setTimestamp(bindVarIndex++, new Timestamp(toDate.getTime()));
        if (distSiteId == null && trackSiteId != null) {
            statement.setInt(bindVarIndex++, trackSiteId);
        }
        if (distSiteId != null) {
            statement.setInt(bindVarIndex++, distSiteId);
        }
        for (Long partnerId : partnerIds) {
            statement.setLong(bindVarIndex++, partnerId);
        }
        statement.setInt(bindVarIndex++, status);
        return statement;
    }

    private Date getOldestFromDate(Connection conn, Date fromDate) throws SQLException {
        Date oldestFromDate = this.getMinFlashbackTime(conn);
        if (fromDate.before(oldestFromDate)) {
            logger.debug((Object)("From date [" + fromDate + "] is earlier than the earliest time flash back is available [" + this.minFlashbackTime + "]. Changed to query only in the available time."));
        } else {
            oldestFromDate = fromDate;
        }
        return oldestFromDate;
    }

    PreparedStatement prepareTrackSiteStatement(Connection conn, Integer distSiteId, Collection<Long> partnerIds, int status, Date fromDate, Date toDate, Integer trackSiteId, List<SearchColumn> columns, SortingInfo sortInfo, AssetSearchQueryBuilder assetSearchQueryBuilder) throws SQLException {
        StringBuilder sb = new StringBuilder(1000);
        sb.append("SELECT * FROM (").append("SELECT row_number() over (PARTITION BY tst.siteid, tst.titleid ORDER BY tst.status_updated_time desc) AS rownumber, ").append("versions_operation, tst.siteid, s.name AS sitename, tst.titleid, tst.status, tst.status_updated_time ");
        this.addMetadataColumnsInSelect(assetSearchQueryBuilder, columns, sb);
        sb.append(" FROM SITES_TRACKSITETITLE VERSIONS BETWEEN TIMESTAMP ? AND maxvalue tst ").append("JOIN PMM_TITLE T ON (t.id_ = tst.titleid) ").append("JOIN MDM_METADATA mdm ON (extractvalue(sys_nc_rowinfo$, '/ECMFSpec/@documentId') = t.mdmdocid) ").append("JOIN SITES_SITE s ON (s.id_ = tst.siteid) ");
        if (distSiteId != null) {
            sb.append("JOIN SITES_DISTSITETITLE dst ON (dst.titleid = tst.titleid) ");
        }
        sb.append("WHERE TITLESTATUSID <> 5 AND tst.STATUS_UPDATED_TIME BETWEEN ? AND ? ");
        if (distSiteId != null) {
            sb.append("AND dst.siteid = ? ");
        }
        if (trackSiteId != null) {
            sb.append("AND tst.siteid = ? ");
        }
        this.appendPartners(partnerIds.size(), sb);
        sb.append(") WHERE rownumber = 1 and versions_operation <> 'D' and status = ? ");
        sb.append("ORDER BY siteid ");
        this.addOrderByClause(sortInfo, columns, sb);
        String sql = sb.toString();
        logger.debug((Object)("sql: " + sql));
        PreparedStatement statement = conn.prepareStatement(sql);
        int bindVarIndex = 1;
        Date versionsFromDate = this.getOldestFromDate(conn, fromDate);
        statement.setTimestamp(bindVarIndex++, new Timestamp(versionsFromDate.getTime()));
        statement.setTimestamp(bindVarIndex++, new Timestamp(fromDate.getTime()));
        statement.setTimestamp(bindVarIndex++, new Timestamp(toDate.getTime()));
        if (distSiteId != null) {
            statement.setInt(bindVarIndex++, distSiteId);
        }
        if (trackSiteId != null) {
            statement.setInt(bindVarIndex++, trackSiteId);
        }
        for (Long partnerId : partnerIds) {
            statement.setLong(bindVarIndex++, partnerId);
        }
        statement.setInt(bindVarIndex++, status);
        return statement;
    }

    protected void addMetadataColumnsInSelect(AssetSearchQueryBuilder assetSearchQueryBuilder, List<SearchColumn> columns, StringBuilder sb) {
        int i = 1;
        for (SearchColumn sc : columns) {
            if (sc.getFieldType() != FieldType.ASSET) continue;
            sb.append(", ").append(assetSearchQueryBuilder.getExtractValue(sc.getSectionType(), sc.getFieldName())).append(" AS t" + i++);
        }
    }

    protected void appendPartners(int partnerIdsCount, StringBuilder sb) {
        if (partnerIdsCount > 0) {
            sb.append(" AND T.Partner_Id in (?");
            for (int i = 1; i < partnerIdsCount; ++i) {
                sb.append(", ?");
            }
            sb.append(")");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void addOrderByClause(SortingInfo sortInfo, List<SearchColumn> columns, StringBuilder sb) {
        if (sortInfo == null) return;
        sb.append(", ");
        if (sortInfo.getFieldType() == FieldType.ASSET) {
            int matchingIndex = -1;
            int i = 1;
            for (SearchColumn sc : columns) {
                if (sc.getFieldType() != FieldType.ASSET) continue;
                if (sc.getSectionType() == sortInfo.getAssetType() && sc.getFieldName() == sortInfo.getSortItemName()) {
                    matchingIndex = i;
                    break;
                }
                ++i;
            }
            if (matchingIndex == -1) throw new RuntimeException("Cannot sort by the metadata field: [" + sortInfo.getAssetType() + " | " + sortInfo.getSortItemName() + "] as it is not selected");
            sb.append(METADATA_COLUMN_DISP_NAME_PREFIX + matchingIndex);
        } else {
            sb.append(sortInfo.getSortItemName());
        }
        if (sortInfo.getOrder() != SortOrder.DESCENDING) return;
        sb.append(" DESC");
    }

    private Date getMinFlashbackTime(Connection conn) throws SQLException {
        if (this.minFlashbackTime == null) {
            PreparedStatement statement = conn.prepareStatement("select min(TIME_DP) from SMON_SCN_TIME");
            ResultSet rs = statement.executeQuery();
            Timestamp minFlashbackTimeSQL = new Timestamp(0L);
            while (rs.next()) {
                minFlashbackTimeSQL = rs.getTimestamp(1);
            }
            this.minFlashbackTime = new Date(minFlashbackTimeSQL.getTime() + 1000L);
        }
        return this.minFlashbackTime;
    }
}

