/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.sites.distribution;

import com.ericsson.cms.criteria.FieldType;
import com.ericsson.cms.criteria.SearchColumn;
import com.ericsson.cms.criteria.info.SortingInfo;
import com.ericsson.cms.sites.core.entities.DistributionStatus;
import com.ericsson.cms.sites.core.entities.SiteActivity;
import com.ericsson.cms.sites.core.entities.SiteType;
import com.ericsson.cms.sites.core.entities.TrackingStatus;
import com.ericsson.cms.sites.distribution.ISitesActivityService;
import com.ericsson.cms.sites.distribution.SiteActivitySearchQueryBuilder;
import com.ericsson.cms.sites.distribution.SiteActivitySearchWorkFactory;
import com.tandbergtv.metadatamanager.search.ConditionBuilderFactory;
import com.tandbergtv.metadatamanager.search.QueryBuilderFactory;
import com.tandbergtv.metadatamanager.search.SearchSchemaHelper;
import com.tandbergtv.metadatamanager.search.oracle.AssetSearchQueryBuilder;
import com.tandbergtv.watchpoint.pmm.dao.hibernate.HibernateContext;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import org.hibernate.Session;
import org.hibernate.jdbc.Work;

@Stateless
@TransactionAttribute
public class SitesActivityService
implements ISitesActivityService {
    private static final String METADATA_COLUMN_DISP_NAME_PREFIX = "t";
    private AssetSearchQueryBuilder assetSearchQueryBuilder;
    private SiteActivitySearchQueryBuilder siteActivitySearchQueryBuilder;

    public List<SiteActivity> getDistributionSiteActivity(Integer distSiteId, DistributionStatus status, Date fromDate, Date toDate, Integer trackSiteId, Collection<Long> partnerIds, List<SearchColumn> columns, SortingInfo sortInfo) {
        return this.getActivity(SiteType.DISTRIBUTION, distSiteId, partnerIds, trackSiteId, status.ordinal(), fromDate, toDate, columns, sortInfo);
    }

    public List<SiteActivity> getTrackingSiteActivity(Integer trackSiteId, TrackingStatus status, Date fromDate, Date toDate, Integer distSiteId, Collection<Long> partnerIds, List<SearchColumn> columns, SortingInfo sortInfo) {
        return this.getActivity(SiteType.TRACKING, distSiteId, partnerIds, trackSiteId, status.ordinal(), fromDate, toDate, columns, sortInfo);
    }

    @PostConstruct
    public void initialize() {
        SearchSchemaHelper searchSchemaHelper = new SearchSchemaHelper();
        ConditionBuilderFactory conditionBuilderFactory = new ConditionBuilderFactory();
        conditionBuilderFactory.setSearchSchemaHelper(searchSchemaHelper);
        QueryBuilderFactory queryBuilderFactory = new QueryBuilderFactory();
        queryBuilderFactory.setCondidtionBuilderFactory(conditionBuilderFactory);
        queryBuilderFactory.setSchemaHelper(searchSchemaHelper);
        queryBuilderFactory.setSessionFactory(this.getSession().getSessionFactory());
        queryBuilderFactory.init();
        this.assetSearchQueryBuilder = queryBuilderFactory.getAssetSearchQueryBuilder();
        this.siteActivitySearchQueryBuilder = SiteActivitySearchWorkFactory.getQueryBuilder();
    }

    private List<SiteActivity> getActivity(final SiteType siteType, final Integer distSiteId, final Collection<Long> partnerIds, final Integer trackSiteId, final int status, final Date fromDate, final Date toDate, final List<SearchColumn> columns, final SortingInfo sortInfo) {
        final LinkedList<SiteActivity> activities = new LinkedList<SiteActivity>();
        Work work = new Work(){

            public void execute(Connection conn) throws SQLException {
                PreparedStatement statement = siteType == SiteType.DISTRIBUTION ? SitesActivityService.this.siteActivitySearchQueryBuilder.prepareDistSiteStatement(conn, distSiteId, partnerIds, status, fromDate, toDate, trackSiteId, columns, sortInfo, SitesActivityService.this.assetSearchQueryBuilder) : SitesActivityService.this.siteActivitySearchQueryBuilder.prepareTrackSiteStatement(conn, distSiteId, partnerIds, status, fromDate, toDate, trackSiteId, columns, sortInfo, SitesActivityService.this.assetSearchQueryBuilder);
                ResultSet results = statement.executeQuery();
                while (results.next()) {
                    activities.add(SitesActivityService.this.read(results, columns));
                }
            }
        };
        this.doWork(work);
        return activities;
    }

    private SiteActivity read(ResultSet results, List<SearchColumn> columns) throws SQLException {
        SiteActivity sa = new SiteActivity();
        sa.setSiteId(results.getInt("siteid"));
        sa.setSiteName(results.getString("sitename"));
        sa.setTitleId(results.getLong("titleid"));
        sa.setStatus(results.getInt("status"));
        sa.setStatusUpdatedTime(new Date(results.getTimestamp("status_updated_time").getTime()));
        int i = 1;
        for (SearchColumn sc : columns) {
            if (sc.getFieldType() != FieldType.ASSET) continue;
            sa.addTitleMetadataField(results.getString(METADATA_COLUMN_DISP_NAME_PREFIX + i++));
        }
        return sa;
    }

    private void doWork(Work work) {
        Session session = this.getSession();
        try {
            session.doWork(work);
        }
        catch (RuntimeException e) {
            try {
                session.cancelQuery();
            }
            catch (Exception e1) {
                // empty catch block
            }
            throw e;
        }
    }

    protected Session getSession() {
        return HibernateContext.getContext().getCurrentSession();
    }
}

