/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.sites.export;

import com.ericsson.cms.sites.core.ISiteManager;
import com.ericsson.cms.sites.core.SiteManagementException;
import com.ericsson.cms.sites.core.entities.DistributionSite;
import com.ericsson.cms.sites.core.entities.DistributionSiteTitle;
import com.ericsson.cms.sites.core.entities.DistributionStatus;
import com.ericsson.cms.sites.core.entities.Site;
import com.ericsson.cms.sites.core.entities.SiteType;
import com.ericsson.cms.sites.export.CloseProtectedStream;
import com.ericsson.cms.sites.export.ExportPlugin;
import com.ericsson.cms.sites.export.IExportPluginServiceManagement;
import com.ericsson.cms.sites.export.ISiteExportManager;
import com.ericsson.cms.sites.export.ISiteExporter;
import com.ericsson.cms.sites.export.ISiteExporterV2;
import com.ericsson.cms.sites.export.SiteExportException;
import com.tandbergtv.metadatamanager.JPFActivator;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.ejb.EJB;
import org.java.plugin.PluginClassLoader;
import org.java.plugin.PluginLifecycleException;
import org.java.plugin.PluginManager;
import org.java.plugin.registry.Extension;
import org.java.plugin.registry.ExtensionPoint;
import org.java.plugin.registry.PluginDescriptor;
import org.jboss.ejb3.annotation.Depends;
import org.jboss.ejb3.annotation.Service;
import org.jboss.ejb3.annotation.TransactionTimeout;

@Service(objectName="Sites:service=com.ericsson.cms.sites.export.ISiteExportManager")
@Depends(value={"ContentManagement:service=com.tandbergtv.cms.contentmgmt.activation.IServiceActivator"})
@TransactionTimeout(value=7200)
public class SiteExportManager
implements ISiteExportManager,
IExportPluginServiceManagement {
    private static final String PRODUCT_DIR = "com.tandbergtv.cms.product.dir";
    private static final String SITES_EXPORT_PLUGIN_FOLDER_RELATIVE_PATH = "plugins" + File.separator + "site" + File.separator + "export";
    private static final String JPF_PLUGIN_REPOSITORY_PROPERTY = "org.java.plugin.boot.pluginsRepositories";
    private static final String EXPORT_DIR = "Export Directory";
    @EJB
    ISiteManager siteManager;
    private Map<String, ExportPlugin> pluginsMap = new HashMap<String, ExportPlugin>();
    private Set<ExportPlugin> pluginsSet = new HashSet<ExportPlugin>();

    public void start() {
        Properties properties = new Properties();
        String productDir = System.getProperty(PRODUCT_DIR);
        File pluginDir = new File(productDir, SITES_EXPORT_PLUGIN_FOLDER_RELATIVE_PATH);
        properties.put(JPF_PLUGIN_REPOSITORY_PROPERTY, pluginDir.getAbsolutePath());
        JPFActivator jpfActivator = new JPFActivator();
        jpfActivator.start(properties);
        PluginManager pluginManager = jpfActivator.getPluginManager();
        if (pluginManager == null) {
            throw new SiteManagementException("Cannot get Plugin Manager for Sites Export Plugins");
        }
        ExtensionPoint point = pluginManager.getRegistry().getExtensionPoint("com.ericsson.cms.sites.export", "exporter");
        Collection extensions = point.getConnectedExtensions();
        if (!extensions.isEmpty()) {
            for (Extension extension : extensions) {
                ExportPlugin plugin;
                String name = extension.getParameter("name").valueAsString();
                String classStr = extension.getParameter("class").valueAsString();
                Collection paramParams = extension.getParameters("param");
                ArrayList<String> paramNames = new ArrayList<String>();
                if (paramParams != null) {
                    for (Extension.Parameter paramParam : paramParams) {
                        paramNames.add(paramParam.valueAsString());
                    }
                }
                paramNames.add(EXPORT_DIR);
                String fileExtension = null;
                Extension.Parameter paramFileExtension = extension.getParameter("fileextension");
                if (paramFileExtension != null) {
                    fileExtension = paramFileExtension.valueAsString();
                }
                PluginDescriptor declaringPluginDescriptor = extension.getDeclaringPluginDescriptor();
                try {
                    pluginManager.activatePlugin(declaringPluginDescriptor.getId());
                }
                catch (PluginLifecycleException e) {
                    throw new SiteManagementException("Unable to activate the plugin: " + declaringPluginDescriptor.getId(), (Throwable)e);
                }
                Class<?> exporterClass = null;
                try {
                    PluginClassLoader classLoader = pluginManager.getPluginClassLoader(declaringPluginDescriptor);
                    exporterClass = classLoader.loadClass(classStr);
                }
                catch (Exception e) {
                    throw new SiteManagementException("Unable to load the exporter class: " + classStr + " of plugin: " + declaringPluginDescriptor.getId(), (Throwable)e);
                }
                if (ISiteExporter.class.isAssignableFrom(exporterClass)) {
                    plugin = new ExportPlugin(name, exporterClass, paramNames, fileExtension);
                } else if (ISiteExporterV2.class.isAssignableFrom(exporterClass)) {
                    plugin = new ExportPlugin(name, exporterClass, 2, paramNames, fileExtension);
                } else {
                    throw new SiteManagementException("The exporter class: " + exporterClass + " of plugin: " + declaringPluginDescriptor.getId() + " does not implement either of the two interfaces: " + ISiteExporter.class + ", " + ISiteExporterV2.class);
                }
                this.pluginsMap.put(name, plugin);
            }
        }
        this.pluginsSet.addAll(this.pluginsMap.values());
    }

    public void stop() {
    }

    public Set<ExportPlugin> getAllPlugins() {
        return this.pluginsSet;
    }

    public String exportTitles(int siteId, List<DistributionStatus> statuses) throws SiteExportException {
        String exportDir;
        DistributionSite distSite = this.getDistributionSite(siteId);
        String string = exportDir = distSite.getExportConfParams() != null ? (String)distSite.getExportConfParams().get(EXPORT_DIR) : null;
        if (exportDir == null) {
            throw new SiteExportException("Export directory is not defined for this site");
        }
        if (!this.isValidExportDirectory(exportDir)) {
            throw new SiteExportException("Export directory defined for this site is not a valid directory");
        }
        String exportPluginName = distSite.getExportPluginName();
        if (exportPluginName == null) {
            throw new SiteExportException("Export Plugin is not defined for this Site");
        }
        ExportPlugin plugin = this.pluginsMap.get(exportPluginName);
        if (plugin == null) {
            throw new SiteExportException("Configured Export Plugin is not found");
        }
        String fileExtension = plugin.getFileExtension();
        String fileName = distSite.getName() + "_" + System.currentTimeMillis();
        if (fileExtension != null && fileExtension.trim().length() > 0) {
            fileName = fileName + "." + fileExtension.trim();
        }
        String filePath = new File(exportDir, fileName).getAbsolutePath();
        this.export(distSite, statuses, filePath);
        return filePath;
    }

    public void exportTitles(int siteId, List<DistributionStatus> statuses, String filePath) throws SiteExportException {
        this.export(this.getDistributionSite(siteId), statuses, filePath);
    }

    private DistributionSite getDistributionSite(int siteId) {
        Site site = this.siteManager.getSite(siteId);
        if (site == null) {
            throw new SiteExportException("No site found for id: " + siteId);
        }
        if (site.getType() != SiteType.DISTRIBUTION) {
            throw new SiteExportException("Can export Distribution Site titles only");
        }
        return (DistributionSite)site;
    }

    private void export(DistributionSite distSite, List<DistributionStatus> statuses, String filePath) {
        if (statuses == null || statuses.isEmpty()) {
            throw new SiteExportException("Statuses cannot be null or empty");
        }
        String exportPluginName = distSite.getExportPluginName();
        if (exportPluginName == null) {
            throw new SiteExportException("Export Plugin is not defined for this Site");
        }
        ExportPlugin plugin = this.pluginsMap.get(exportPluginName);
        if (plugin == null) {
            throw new SiteExportException("Configured Export Plugin is not found");
        }
        if (plugin.getVersion() == 1) {
            this.exportV1(plugin, distSite, statuses, filePath);
        } else if (plugin.getVersion() == 2) {
            this.exportV2(plugin, distSite, statuses, filePath);
        } else {
            throw new SiteManagementException("Export Plugin version " + plugin.getVersion() + " is unexpected and not supported.");
        }
    }

    private void exportV1(ExportPlugin plugin, DistributionSite distSite, List<DistributionStatus> statuses, String filePath) {
        ISiteExporter exporter = null;
        try {
            exporter = (ISiteExporter)plugin.getExporterClass().newInstance();
        }
        catch (Exception e) {
            throw new SiteManagementException("Unable to instantiate the exporter class: " + plugin.getExporterClass() + " of plugin: " + plugin.getName(), (Throwable)e);
        }
        Set<DistributionSiteTitle> siteTitles = this.getSiteTitles(distSite, statuses);
        exporter.setParams(distSite.getExportConfParams());
        exporter.exportTitles(distSite, siteTitles, filePath);
    }

    private void exportV2(ExportPlugin plugin, DistributionSite distSite, List<DistributionStatus> statuses, String filePath) {
        ISiteExporterV2 exporter = null;
        try {
            exporter = (ISiteExporterV2)plugin.getExporterClass().newInstance();
        }
        catch (Exception e) {
            throw new SiteManagementException("Unable to instantiate the exporter class: " + plugin.getExporterClass() + " of plugin: " + plugin.getName(), (Throwable)e);
        }
        exporter.setParams(distSite.getExportConfParams());
        exporter.setSite(distSite);
        CloseProtectedStream writer = null;
        try {
            writer = new CloseProtectedStream(new FileOutputStream(filePath));
            exporter.writeHeader((BufferedOutputStream)writer);
            for (DistributionStatus status : statuses) {
                List dsts = this.siteManager.getDistributionSiteTitlesBySiteAndStatus(distSite.getId().intValue(), status);
                if (dsts == null) continue;
                for (DistributionSiteTitle dst : dsts) {
                    exporter.writeTitle(dst, (BufferedOutputStream)writer);
                }
            }
            exporter.writeFooter((BufferedOutputStream)writer);
        }
        catch (IOException e) {
            throw new SiteManagementException("Error in writing to the file: " + filePath, (Throwable)e);
        }
        finally {
            try {
                writer.protectedClose();
            }
            catch (IOException e) {
                throw new SiteManagementException("Error in closing the file: " + filePath, (Throwable)e);
            }
        }
    }

    private Set<DistributionSiteTitle> getSiteTitles(DistributionSite distSite, List<DistributionStatus> statuses) {
        HashSet<DistributionSiteTitle> filteredTitles = new HashSet<DistributionSiteTitle>();
        if (distSite.getDistributionSiteTitles() == null) {
            return filteredTitles;
        }
        block0: for (DistributionSiteTitle dst : distSite.getDistributionSiteTitles()) {
            for (DistributionStatus status : statuses) {
                if (!dst.getStatus().equals((Object)status)) continue;
                filteredTitles.add(dst);
                continue block0;
            }
        }
        return filteredTitles;
    }

    private boolean isValidExportDirectory(String exportDir) {
        File file;
        boolean isValidExportDirectory = false;
        if (exportDir != null && !exportDir.isEmpty() && (file = new File(exportDir)).exists() && file.isDirectory()) {
            isValidExportDirectory = true;
        }
        return isValidExportDirectory;
    }
}

