/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.sites.monitoring;

import com.ericsson.cms.sites.core.DistTimeoutManager;
import com.ericsson.cms.sites.core.entities.DistributionSiteTitle;
import com.ericsson.cms.sites.monitoring.plugins.StatusPluginManager;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.MembershipEvent;
import com.hazelcast.core.MembershipListener;
import com.tandbergtv.workflow.core.service.Cluster;
import java.util.List;
import org.apache.log4j.Logger;
import org.java.plugin.PluginLifecycleException;

public class HazClusterNodeManager
implements MembershipListener {
    StatusPluginManager statusPluginManager;
    private HazelcastInstance haz;
    private List<DistributionSiteTitle> dstSiteTitleListHaz;
    private static Logger logger = Logger.getLogger((String)HazClusterNodeManager.class.getName());

    public HazClusterNodeManager(StatusPluginManager statusPluginManager) {
        this.statusPluginManager = statusPluginManager;
    }

    public void memberAdded(MembershipEvent event) {
        logger.info((Object)("member added: " + event.getMember().getPort()));
    }

    public void memberRemoved(MembershipEvent event) {
        logger.info((Object)("member removed: " + event.getMember().getPort()));
        if (Cluster.isMaster()) {
            DistTimeoutManager.getInstance().rescheduleDistSiteTitles(event.getMember().getInetSocketAddress().getAddress().getHostAddress());
            DistTimeoutManager.getInstance().rescheduleTrackingSiteTitles(event.getMember().getInetSocketAddress().getAddress().getHostAddress());
        }
        try {
            this.statusPluginManager.activate();
        }
        catch (PluginLifecycleException e) {
            logger.error((Object)("Exception occurred : " + (Object)((Object)e)), (Throwable)e);
        }
    }
}

