/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.sites.monitoring;

import com.ericsson.cms.sites.core.entities.DistributionSite;
import com.ericsson.cms.sites.core.entities.Site;
import com.ericsson.cms.sites.core.entities.SiteType;
import com.ericsson.cms.sites.core.entities.TrackingSite;
import com.ericsson.cms.sites.monitoring.ISiteChangeListener;
import com.ericsson.cms.sites.monitoring.PluginInformation;
import com.ericsson.cms.sites.monitoring.plugins.IStatusPlugin;
import com.ericsson.cms.sites.monitoring.plugins.IStatusPluginManager;
import com.ericsson.cms.sites.monitoring.plugins.StatusPluginType;
import com.tandbergtv.neptune.util.InjectionUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.ejb.Stateless;
import org.apache.log4j.Logger;

@Stateless
public class SiteChangeListener
implements ISiteChangeListener {
    private static Logger logger = Logger.getLogger((String)SiteChangeListener.class.getName());
    private IStatusPluginManager statusPluginManager;

    public void newTrackingSiteAdded(DistributionSite distributionSite, TrackingSite trackingSite) {
        logger.info((Object)("TrackingSite added : " + trackingSite + " to distributionSite : " + distributionSite));
        IStatusPluginManager statusPluginManager = this.getStatusPluginManager();
        if (distributionSite != null && trackingSite != null) {
            StatusPluginType statusPluginType;
            Integer distributionSiteId = distributionSite.getId();
            Integer trackingSiteId = trackingSite.getId();
            IStatusPlugin trackingSiteDeplStatusPlugin = statusPluginManager.getAssociatedPluginForSite(trackingSiteId, statusPluginType = StatusPluginType.DEPLOYMENT_STATUS);
            if (trackingSiteDeplStatusPlugin != null) {
                logger.info((Object)("Tracking site : " + trackingSite + " has plug-in associated : " + trackingSiteDeplStatusPlugin));
                String pluginId = trackingSiteDeplStatusPlugin.getId();
                HashSet<Integer> siteIds = new HashSet<Integer>();
                siteIds.add(trackingSiteId);
                logger.info((Object)("Starting monitoring tracking site : " + trackingSiteId + " with it's plug-in : " + trackingSiteDeplStatusPlugin));
                statusPluginManager.startMasterMonitoring(pluginId, siteIds);
            } else {
                logger.info((Object)("Tracking site : " + trackingSite + " has no plug-in associated..."));
                IStatusPlugin distSiteDeplStatusPlugin = statusPluginManager.getAssociatedPluginForSite(distributionSiteId, statusPluginType);
                if (distSiteDeplStatusPlugin != null) {
                    logger.info((Object)("Distribution site : " + distributionSite + " has plug-in associated : " + distSiteDeplStatusPlugin));
                    String pluginId = distSiteDeplStatusPlugin.getId();
                    HashSet<Integer> siteIds = new HashSet<Integer>();
                    siteIds.add(trackingSiteId);
                    logger.info((Object)("Starting monitoring tracking site : " + trackingSiteId + " with distribution site's plug-in : " + distSiteDeplStatusPlugin));
                    statusPluginManager.startMasterMonitoring(pluginId, siteIds);
                } else {
                    logger.info((Object)("Neither Tracking site : " + trackingSite + " nor Distribution Site : " + distributionSite + " have plug-in associated. Monitoring will not be started..."));
                }
            }
        } else {
            logger.error((Object)"'null' distributionSite or trackingSite passed.");
        }
    }

    public void siteActivated(Site site) {
        logger.info((Object)("Site activated : " + site));
        IStatusPluginManager statusPluginManager = this.getStatusPluginManager();
        if (site != null) {
            SiteType siteType = site.getType();
            if (SiteType.DISTRIBUTION.equals((Object)siteType) || SiteType.TRACKING.equals((Object)siteType)) {
                Integer siteId = site.getId();
                statusPluginManager.startMonitoringWithAllPluginsForSite(siteId);
            }
        } else {
            logger.error((Object)"'null' site passed.");
        }
    }

    public void siteCreated(Site site, Collection<PluginInformation> pluginInfos) {
        logger.info((Object)("Site created : " + site + ", pluginInfos : " + pluginInfos));
        IStatusPluginManager statusPluginManager = this.getStatusPluginManager();
        if (site != null) {
            Integer siteId = site.getId();
            if (pluginInfos != null) {
                for (PluginInformation pluginInfo : pluginInfos) {
                    String pluginId = pluginInfo.getPluginId();
                    HashSet<Integer> siteIds = new HashSet<Integer>();
                    siteIds.add(siteId);
                    boolean startMonitoring = true;
                    statusPluginManager.associate(pluginId, siteIds, startMonitoring);
                }
            } else {
                logger.warn((Object)"'null' Collection<PluginInformation> pluginInfos passed.");
            }
        } else {
            logger.error((Object)"'null' site passed.");
        }
    }

    public void siteDeleted(Site site) {
        logger.info((Object)("Site deleted : " + site));
        IStatusPluginManager statusPluginManager = this.getStatusPluginManager();
        if (site != null) {
            Integer siteId = site.getId();
            statusPluginManager.dissociateAllPluginsForSite(siteId);
        } else {
            logger.error((Object)"'null' site passed.");
        }
    }

    public void siteInactivated(Site site) {
        logger.info((Object)("Site inactivated : " + site));
        IStatusPluginManager statusPluginManager = this.getStatusPluginManager();
        if (site != null) {
            SiteType siteType = site.getType();
            if (SiteType.DISTRIBUTION.equals((Object)siteType) || SiteType.TRACKING.equals((Object)siteType)) {
                Integer siteId = site.getId();
                statusPluginManager.stopMonitoringWithAllPluginsForSite(siteId);
            }
        } else {
            logger.error((Object)"'null' site passed.");
        }
    }

    public void siteUpdated(Site oldSite, Site newSite, Collection<PluginInformation> oldPluginInfos, Collection<PluginInformation> newPluginInfos) {
        logger.info((Object)("Site updated : oldSite " + oldSite + ", newSite : " + newSite + ", oldPluginInfos : " + oldPluginInfos + ", newPluginInfos : " + newPluginInfos));
        IStatusPluginManager statusPluginManager = this.getStatusPluginManager();
        if (oldSite != null && newSite != null) {
            Integer siteId = newSite.getId();
            if (oldPluginInfos != null && newPluginInfos != null) {
                HashSet<Integer> siteIds;
                String pluginId;
                Map<StatusPluginType, String> oldPluginInfosMap = this.getPluginInfosMap(oldPluginInfos);
                Map<StatusPluginType, String> newPluginInfosMap = this.getPluginInfosMap(newPluginInfos);
                Set<StatusPluginType> oldPluginTypes = oldPluginInfosMap.keySet();
                Set<StatusPluginType> newPluginTypes = newPluginInfosMap.keySet();
                Set<StatusPluginType> addedPluginTypes = this.getAddedPluginTypes(oldPluginTypes, newPluginTypes);
                logger.info((Object)("Got addedPluginTypes = " + addedPluginTypes));
                Set<StatusPluginType> removedPluginTypes = this.getRemovedPluginTypes(oldPluginTypes, newPluginTypes);
                logger.info((Object)("Got removedPluginTypes = " + removedPluginTypes));
                Set<StatusPluginType> changedPluginTypes = this.getChangedPluginTypes(oldPluginInfosMap, newPluginInfosMap);
                logger.info((Object)("Got changedPluginTypes = " + changedPluginTypes));
                for (StatusPluginType addedPluginType : addedPluginTypes) {
                    pluginId = newPluginInfosMap.get(addedPluginType);
                    siteIds = new HashSet<Integer>();
                    siteIds.add(siteId);
                    boolean startMonitoring = true;
                    statusPluginManager.associate(pluginId, siteIds, startMonitoring);
                }
                for (StatusPluginType removedPluginType : removedPluginTypes) {
                    pluginId = oldPluginInfosMap.get(removedPluginType);
                    siteIds = new HashSet();
                    siteIds.add(siteId);
                    statusPluginManager.dissociateMaster(pluginId, removedPluginType, siteIds);
                }
                for (StatusPluginType changedPluginType : changedPluginTypes) {
                    String oldPluginId = oldPluginInfosMap.get(changedPluginType);
                    siteIds = new HashSet();
                    siteIds.add(siteId);
                    statusPluginManager.dissociateMaster(oldPluginId, changedPluginType, siteIds);
                    String newPluginId = newPluginInfosMap.get(changedPluginType);
                    boolean startMonitoring = true;
                    statusPluginManager.associate(newPluginId, siteIds, startMonitoring);
                }
            } else {
                logger.warn((Object)"'null' Collection<PluginInformation> oldPluginInfos or 'null' Collection<PluginInformation> newPluginInfos passed.");
            }
        } else {
            logger.error((Object)"'null' oldSite or 'null' newSite passed.");
        }
    }

    public void trackingSiteDetached(DistributionSite distributionSite, TrackingSite trackingSite) {
        logger.info((Object)("TrackingSite : " + trackingSite + " detached from distributionSite : " + distributionSite));
        IStatusPluginManager statusPluginManager = this.getStatusPluginManager();
        if (distributionSite != null && trackingSite != null) {
            Integer distributionSiteId = distributionSite.getId();
            Integer trackingSiteId = trackingSite.getId();
            StatusPluginType statusPluginType = StatusPluginType.DEPLOYMENT_STATUS;
            IStatusPlugin distSiteDeplStatusPlugin = statusPluginManager.getAssociatedPluginForSite(distributionSiteId, statusPluginType);
            if (distSiteDeplStatusPlugin != null) {
                logger.info((Object)("Distribution site : " + distributionSite + " has plug-in associated : " + distSiteDeplStatusPlugin));
                String pluginId = distSiteDeplStatusPlugin.getId();
                HashSet<Integer> siteIds = new HashSet<Integer>();
                siteIds.add(trackingSiteId);
                logger.info((Object)("Stopping monitoring tracking site : " + trackingSiteId + " with distribution site's plug-in : " + distSiteDeplStatusPlugin));
                statusPluginManager.stopMasterMonitoring(pluginId, siteIds, false);
            } else {
                logger.info((Object)("The Distribution Site : " + distributionSite + " has no plug-in associated. No monitoring will not be stopped..."));
            }
        } else {
            logger.error((Object)"'null' distributionSite or trackingSite passed.");
        }
    }

    public void trackingSiteShared(DistributionSite newDistributionSite, TrackingSite trackingSite) {
        logger.info((Object)("TrackingSite : " + trackingSite + " shared with new distributionSite : " + newDistributionSite));
        IStatusPluginManager statusPluginManager = this.getStatusPluginManager();
        if (newDistributionSite != null && trackingSite != null) {
            StatusPluginType statusPluginType;
            Integer newDistributionSiteId = newDistributionSite.getId();
            Integer trackingSiteId = trackingSite.getId();
            IStatusPlugin trackingSiteDeplStatusPlugin = statusPluginManager.getAssociatedPluginForSite(trackingSiteId, statusPluginType = StatusPluginType.DEPLOYMENT_STATUS);
            if (trackingSiteDeplStatusPlugin != null) {
                logger.info((Object)("Tracking site : " + trackingSite + " has plug-in associated : " + trackingSiteDeplStatusPlugin + ". Monitoring would be deferred to tracking site's plug-in..."));
            } else {
                logger.info((Object)("Tracking site : " + trackingSite + " has no plug-in associated..."));
                IStatusPlugin newDistSiteDeplStatusPlugin = statusPluginManager.getAssociatedPluginForSite(newDistributionSiteId, statusPluginType);
                if (newDistSiteDeplStatusPlugin != null) {
                    logger.info((Object)("New Distribution site : " + newDistributionSite + " has plug-in associated : " + newDistSiteDeplStatusPlugin));
                    String pluginId = newDistSiteDeplStatusPlugin.getId();
                    HashSet<Integer> siteIds = new HashSet<Integer>();
                    siteIds.add(trackingSiteId);
                    logger.info((Object)("Starting monitoring tracking site : " + trackingSiteId + " with new distribution site's plug-in : " + newDistSiteDeplStatusPlugin));
                    statusPluginManager.startMasterMonitoring(pluginId, siteIds);
                } else {
                    logger.info((Object)("Neither Tracking site : " + trackingSite + " nor new Distribution Site : " + newDistributionSite + " have plug-in associated. New monitoring will not be started..."));
                }
            }
        } else {
            logger.error((Object)"'null' distributionSite or trackingSite passed.");
        }
    }

    private Map<StatusPluginType, String> getPluginInfosMap(Collection<PluginInformation> pluginInfos) {
        HashMap<StatusPluginType, String> pluginInfosMap = new HashMap<StatusPluginType, String>();
        for (PluginInformation pluginInfo : pluginInfos) {
            StatusPluginType pluginType = pluginInfo.getPluginType();
            String pluginId = pluginInfo.getPluginId();
            pluginInfosMap.put(pluginType, pluginId);
        }
        return pluginInfosMap;
    }

    private Set<StatusPluginType> getAddedPluginTypes(Set<StatusPluginType> oldPluginTypes, Set<StatusPluginType> newPluginTypes) {
        HashSet<StatusPluginType> addedPluginTypes = new HashSet<StatusPluginType>();
        for (StatusPluginType newPluginType : newPluginTypes) {
            if (oldPluginTypes.contains(newPluginType)) continue;
            addedPluginTypes.add(newPluginType);
        }
        return addedPluginTypes;
    }

    private Set<StatusPluginType> getRemovedPluginTypes(Set<StatusPluginType> oldPluginTypes, Set<StatusPluginType> newPluginTypes) {
        HashSet<StatusPluginType> removedPluginTypes = new HashSet<StatusPluginType>();
        for (StatusPluginType oldPluginType : oldPluginTypes) {
            if (newPluginTypes.contains(oldPluginType)) continue;
            removedPluginTypes.add(oldPluginType);
        }
        return removedPluginTypes;
    }

    private Set<StatusPluginType> getChangedPluginTypes(Map<StatusPluginType, String> oldPluginInfosMap, Map<StatusPluginType, String> newPluginInfosMap) {
        HashSet<StatusPluginType> changedPluginTypes = new HashSet<StatusPluginType>();
        for (StatusPluginType pluginType : oldPluginInfosMap.keySet()) {
            String oldPluginId = oldPluginInfosMap.get(pluginType);
            String newPluginId = newPluginInfosMap.get(pluginType);
            if (oldPluginId != null) {
                if (oldPluginId.equals(newPluginId)) continue;
                changedPluginTypes.add(pluginType);
                continue;
            }
            if (newPluginId == null) continue;
            changedPluginTypes.add(pluginType);
        }
        return changedPluginTypes;
    }

    private IStatusPluginManager getStatusPluginManager() {
        if (this.statusPluginManager == null) {
            this.statusPluginManager = (IStatusPluginManager)InjectionUtil.injectInstance((String)"cms/StatusPluginManager/local", IStatusPluginManager.class);
        }
        return this.statusPluginManager;
    }
}

