/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.sites.monitoring.plugins;

import com.ericsson.cms.sites.core.ISiteManager;
import com.ericsson.cms.sites.core.entities.DistributionSite;
import com.ericsson.cms.sites.core.entities.LogicalSite;
import com.ericsson.cms.sites.core.entities.Site;
import com.ericsson.cms.sites.core.entities.SiteType;
import com.ericsson.cms.sites.core.entities.TrackingSite;
import com.ericsson.cms.sites.monitoring.HazClusterNodeManager;
import com.ericsson.cms.sites.monitoring.IMonitoringServiceManagement;
import com.ericsson.cms.sites.monitoring.SiteMonitoring;
import com.ericsson.cms.sites.monitoring.SiteMonitoringAction;
import com.ericsson.cms.sites.monitoring.dao.SiteMonitoringDao;
import com.ericsson.cms.sites.monitoring.plugins.IStatusPlugin;
import com.ericsson.cms.sites.monitoring.plugins.IStatusPluginManager;
import com.ericsson.cms.sites.monitoring.plugins.PluginAssociateCallable;
import com.ericsson.cms.sites.monitoring.plugins.PluginDisassociateCallable;
import com.ericsson.cms.sites.monitoring.plugins.PluginMonitorStartCallable;
import com.ericsson.cms.sites.monitoring.plugins.PluginMonitorStopCallable;
import com.ericsson.cms.sites.monitoring.plugins.StatusPluginBase;
import com.ericsson.cms.sites.monitoring.plugins.StatusPluginType;
import com.ericsson.cms.sites.monitoring.plugins.deplstatusplugin.IDeploymentStatusPlugin;
import com.ericsson.cms.sites.monitoring.plugins.diststatusplugin.IDistributionStatusPlugin;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.MembershipListener;
import com.tandbergtv.cms.portal.util.transaction.TransactionEnforcer;
import com.tandbergtv.cms.portal.util.transaction.Transactional;
import com.tandbergtv.cms.portal.util.transaction.TransactionalException;
import com.tandbergtv.metadatamanager.JPFActivator;
import com.tandbergtv.workflow.core.service.Cluster;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.core.service.thread.ISchedulerService;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.ejb.EJB;
import javax.naming.InitialContext;
import javax.transaction.TransactionManager;
import org.apache.log4j.Logger;
import org.aspectj.runtime.internal.AroundClosure;
import org.java.plugin.Plugin;
import org.java.plugin.PluginLifecycleException;
import org.java.plugin.PluginManager;
import org.java.plugin.registry.PluginDescriptor;
import org.java.plugin.registry.PluginRegistry;
import org.jboss.ejb3.annotation.Depends;
import org.jboss.ejb3.annotation.Service;

@Service(objectName="StatusPluginManager:service=com.ericsson.cms.sites.monitoring.plugins.IStatusPluginManager")
@Depends(value={"ContentManagement:service=com.tandbergtv.cms.contentmgmt.activation.IServiceActivator"})
public class StatusPluginManager
implements IStatusPluginManager,
IMonitoringServiceManagement {
    private static Logger logger = Logger.getLogger((String)StatusPluginManager.class.getName());
    public static final String PROPERTY_NAME_PRODUCT_DIR = "com.tandbergtv.cms.product.dir";
    public static final String PLUGINS_FOLDER_RELATIVE_PATH = "plugins" + File.separator + "site" + File.separator + "monitoring";
    ISchedulerService<Void> executor = (ISchedulerService)ServiceRegistry.getDefault().lookup("plugin-scheduler");
    public static final String JPF_PLUGIN_REPOSITORY_PROPERTY = "org.java.plugin.boot.pluginsRepositories";
    private boolean becameMaster = false;
    private PluginManager pluginManager;
    @EJB
    private ISiteManager siteManager;
    private Date appStartTime;

    public void create() throws Exception {
        logger.info((Object)"StatusPluginManager : Creating...");
    }

    public void destroy() {
        logger.info((Object)"StatusPluginManager : Destroying...");
    }

    public void start() throws Exception {
        logger.info((Object)"StatusPluginManager : Starting...");
        this.appStartTime = new Date();
        logger.info((Object)("appStartTime = " + this.appStartTime));
        try {
            com.hazelcast.core.Cluster cluster = Hazelcast.getCluster();
            this.pluginManager = this.intializeMonitoringPlugins();
            logger.info((Object)("StatusPluginManager : Got pluginManager : " + this.pluginManager));
            logger.info((Object)("cluster master: " + Cluster.localAddress()));
            this.activatePlugins(this.pluginManager);
            this.activate();
            cluster.addMembershipListener((MembershipListener)new HazClusterNodeManager(this));
        }
        catch (Exception e) {
            logger.error((Object)("Exception occurred : " + e), (Throwable)e);
        }
        logger.info((Object)"StatusPluginManager : Done starting...");
    }

    public void activate() throws PluginLifecycleException {
        if (Cluster.isMaster() && !this.becameMaster) {
            this.becameMaster = true;
            logger.info((Object)"StatusPluginManager : starting monitoring all on master...");
            this.startMonitoring(this.pluginManager);
        }
    }

    public void stop() {
        logger.info((Object)"StatusPluginManager : Stopping...");
        this.shutdown();
    }

    private IStatusPlugin getStatusPlugin(String id) {
        IStatusPlugin retPlugin = null;
        try {
            String pluginId = this.getPluginId(id);
            Plugin plugin = this.pluginManager.getPlugin(pluginId);
            if (plugin instanceof IStatusPlugin) {
                retPlugin = (IStatusPlugin)plugin;
            }
        }
        catch (Exception e) {
            logger.warn((Object)("Exception occurred getting Status Plugin for id : " + id + " : " + e), (Throwable)e);
        }
        return retPlugin;
    }

    private Collection<IDeploymentStatusPlugin> getDeploymentStatusPlugins() {
        ArrayList<IDeploymentStatusPlugin> deplStatusPlugins = new ArrayList<IDeploymentStatusPlugin>();
        Collection<IStatusPlugin> statusPlugins = this.getAllStatusPlugins();
        for (IStatusPlugin statusPlugin : statusPlugins) {
            if (!StatusPluginType.DEPLOYMENT_STATUS.equals((Object)statusPlugin.getPluginType())) continue;
            deplStatusPlugins.add((IDeploymentStatusPlugin)statusPlugin);
        }
        return deplStatusPlugins;
    }

    private Collection<IDistributionStatusPlugin> getDistributionStatusPlugins() {
        ArrayList<IDistributionStatusPlugin> distStatusPlugins = new ArrayList<IDistributionStatusPlugin>();
        Collection<IStatusPlugin> statusPlugins = this.getAllStatusPlugins();
        for (IStatusPlugin statusPlugin : statusPlugins) {
            if (!StatusPluginType.DISTRIBUTION_STATUS.equals((Object)statusPlugin.getPluginType())) continue;
            distStatusPlugins.add((IDistributionStatusPlugin)statusPlugin);
        }
        return distStatusPlugins;
    }

    public Collection<IStatusPlugin> getPlugins(StatusPluginType statusPluginType) {
        ArrayList<IStatusPlugin> retStatusPlugins = new ArrayList<IStatusPlugin>();
        if (StatusPluginType.DISTRIBUTION_STATUS.equals((Object)statusPluginType)) {
            retStatusPlugins.addAll(this.getDistributionStatusPlugins());
        } else if (StatusPluginType.DEPLOYMENT_STATUS.equals((Object)statusPluginType)) {
            retStatusPlugins.addAll(this.getDeploymentStatusPlugins());
        }
        return retStatusPlugins;
    }

    private Collection<IStatusPlugin> getAssociatedPluginsForSite(Integer siteId) {
        ArrayList<IStatusPlugin> statusPlugins = new ArrayList<IStatusPlugin>();
        SiteMonitoringDao siteMonitoringDao = new SiteMonitoringDao();
        List<SiteMonitoring> siteMonitoringList = siteMonitoringDao.findBySiteId(siteId);
        if (siteMonitoringList != null) {
            for (SiteMonitoring siteMonitoring : siteMonitoringList) {
                IStatusPlugin statusPlugin = this.getStatusPluginForSiteMonitoring(siteMonitoring);
                if (statusPlugin == null) continue;
                statusPlugins.add(statusPlugin);
            }
        }
        return statusPlugins;
    }

    public IStatusPlugin getAssociatedPluginForSite(Integer siteId, StatusPluginType statusPluginType) {
        IStatusPlugin statusPlugin = null;
        SiteMonitoringDao siteMonitoringDao = new SiteMonitoringDao();
        SiteMonitoring siteMonitoring = siteMonitoringDao.findBySiteIdAndMonitoringType(siteId, statusPluginType.toString());
        if (siteMonitoring != null) {
            statusPlugin = this.getStatusPluginForSiteMonitoring(siteMonitoring);
        }
        return statusPlugin;
    }

    public void dissociateAllPluginsForSite(Integer siteId) {
        logger.info((Object)("Dissociate all plugins called for siteId=" + siteId));
        SiteMonitoringDao siteMonitoringDao = new SiteMonitoringDao();
        List<SiteMonitoring> siteMonitoringList = siteMonitoringDao.findBySiteId(siteId);
        HashSet<Integer> siteIds = new HashSet<Integer>();
        siteIds.add(siteId);
        for (SiteMonitoring siteMonitoring : siteMonitoringList) {
            String pluginId = siteMonitoring.getPluginId();
            this.dissociateMaster(pluginId, StatusPluginType.valueOf((String)siteMonitoring.getMonitoringType()), siteIds);
        }
    }

    public void startMonitoringWithAllPluginsForSite(Integer siteId) {
        logger.info((Object)("Start monitoring with all plugins called for siteId=" + siteId));
        SiteMonitoringDao siteMonitoringDao = new SiteMonitoringDao();
        List<SiteMonitoring> siteMonitoringList = siteMonitoringDao.findBySiteId(siteId);
        HashSet<Integer> siteIds = new HashSet<Integer>();
        siteIds.add(siteId);
        for (SiteMonitoring siteMonitoring : siteMonitoringList) {
            String pluginId = siteMonitoring.getPluginId();
            this.startMasterMonitoring(pluginId, siteIds);
        }
    }

    public void stopMonitoringWithAllPluginsForSite(Integer siteId) {
        logger.info((Object)("Stop monitoring with all plugins called for siteId=" + siteId));
        SiteMonitoringDao siteMonitoringDao = new SiteMonitoringDao();
        List<SiteMonitoring> siteMonitoringList = siteMonitoringDao.findBySiteId(siteId);
        HashSet<Integer> siteIds = new HashSet<Integer>();
        siteIds.add(siteId);
        for (SiteMonitoring siteMonitoring : siteMonitoringList) {
            String pluginId = siteMonitoring.getPluginId();
            this.stopMasterMonitoring(pluginId, siteIds, false);
        }
    }

    public void associate(String pluginId, StatusPluginType statusPluginType, int siteId, boolean startMonitoring) {
        logger.info((Object)("Associate called for pluginId=" + pluginId + ", siteId=" + siteId + ", startMonitoring=" + startMonitoring));
        SiteMonitoringDao siteMonitoringDao = new SiteMonitoringDao();
        ArrayList<Integer> siteIds = new ArrayList<Integer>();
        siteIds.add(siteId);
        SiteMonitoring currentSiteMonitoring = siteMonitoringDao.findBySiteIdAndMonitoringType(siteId, statusPluginType.toString());
        if (currentSiteMonitoring != null) {
            String currentPluginId = currentSiteMonitoring.getPluginId();
            this.dissociate(currentPluginId, statusPluginType, siteIds);
        }
        if (pluginId != null && !"".equals(pluginId.trim())) {
            siteMonitoringDao.saveSiteMonitoringAction(siteId, pluginId, SiteMonitoringAction.ASSOCIATE, statusPluginType.toString());
            if (startMonitoring) {
                this.startMonitoring(pluginId, siteIds);
            }
        }
    }

    public void associate(String pluginId, Collection<Integer> siteIds, boolean startMonitoring) {
        logger.info((Object)("Associate called for pluginId=" + pluginId + ", siteIds=" + siteIds));
        SiteMonitoringDao siteMonitoringDao = new SiteMonitoringDao();
        StatusPluginType statusPluginType = this.getStatusPluginType(pluginId);
        for (Integer siteId : siteIds) {
            siteMonitoringDao.saveSiteMonitoringAction(siteId, pluginId, SiteMonitoringAction.ASSOCIATE, statusPluginType.toString());
        }
        if (startMonitoring) {
            this.startMasterMonitoring(pluginId, siteIds);
        }
    }

    public void dissociate(String pluginId, StatusPluginType statusPluginType, Collection<Integer> siteIds) {
        logger.info((Object)("Dissociate called for pluginId=" + pluginId + ", statusPluginType=" + statusPluginType + ", siteIds=" + siteIds));
        SiteMonitoringDao siteMonitoringDao = new SiteMonitoringDao();
        this.stopMonitoring(pluginId, siteIds, true);
        for (Integer siteId : siteIds) {
            siteMonitoringDao.saveSiteMonitoringAction(siteId, pluginId, SiteMonitoringAction.DISSOCIATE, statusPluginType.toString());
        }
    }

    public void startMonitoring(String pluginId, Collection<Integer> siteIds) {
        logger.info((Object)("Start monitoring called for pluginId=" + pluginId + ", siteIds=" + siteIds));
        SiteMonitoringDao siteMonitoringDao = new SiteMonitoringDao();
        StatusPluginType statusPluginType = this.getStatusPluginType(pluginId);
        for (Integer siteId : siteIds) {
            siteMonitoringDao.saveSiteMonitoringAction(siteId, pluginId, SiteMonitoringAction.START_MONITORING, statusPluginType.toString());
        }
        this.instructPluginStartMonitoring(pluginId, siteIds);
    }

    public void stopMasterMonitoring(String pluginId, Collection<Integer> siteIds, boolean dissociatedFlag) {
        ISchedulerService executor = (ISchedulerService)ServiceRegistry.getDefault().lookup("plugin-scheduler");
        PluginMonitorStopCallable callable = new PluginMonitorStopCallable(pluginId, siteIds, dissociatedFlag);
        executor.schedule((Callable)((Object)callable));
    }

    public void stopMonitoring(String pluginId, Collection<Integer> siteIds, boolean dissociatedFlag) {
        logger.info((Object)("Stop monitoring called for pluginId=" + pluginId + ", siteIds=" + siteIds + ", dissociatedFlag=" + dissociatedFlag));
        SiteMonitoringDao siteMonitoringDao = new SiteMonitoringDao();
        StatusPluginType statusPluginType = this.getStatusPluginType(pluginId);
        for (Integer siteId : siteIds) {
            siteMonitoringDao.saveSiteMonitoringAction(siteId, pluginId, SiteMonitoringAction.STOP_MONITORING, statusPluginType.toString());
        }
        this.instructPluginStopMonitoring(pluginId, siteIds, dissociatedFlag);
    }

    public void updateStatusForAllPlugins(Integer siteId) {
        if (siteId != null) {
            Site site = this.siteManager.getSite(siteId.intValue());
            if (site != null) {
                SiteType siteType = site.getType();
                if (SiteType.LOGICAL.equals((Object)siteType)) {
                    LogicalSite logicalSite = (LogicalSite)site;
                    this.updateStatusForAllPlugins(logicalSite);
                } else if (SiteType.DISTRIBUTION.equals((Object)siteType)) {
                    DistributionSite distributionSite = (DistributionSite)site;
                    this.updateStatusForAllPlugins(distributionSite);
                } else if (SiteType.TRACKING.equals((Object)siteType)) {
                    TrackingSite trackingSite = (TrackingSite)site;
                    this.updateStatusForAllPlugins(trackingSite);
                }
            } else {
                logger.warn((Object)("Got 'null' Site for siteId : " + siteId));
            }
        } else {
            logger.warn((Object)"Got 'null' siteId...");
        }
    }

    public void updateStatus(String pluginId, Collection<Integer> siteIds) {
        logger.info((Object)("Update monitoring status called for pluginId=" + pluginId + ", siteIds=" + siteIds));
        IStatusPlugin statusPlugin = this.getStatusPlugin(pluginId);
        if (statusPlugin != null) {
            Collection<String> externalIds = this.getExternalIds(pluginId, siteIds);
            String configId = this.getConfigId(pluginId);
            if (configId != null) {
                logger.info((Object)("Calling synchronize for statusPlugin : " + statusPlugin + ", configId : " + configId + ", externalIds=" + externalIds));
                try {
                    statusPlugin.synchronize(configId, externalIds);
                }
                catch (Exception e) {
                    logger.warn((Object)("Exception occurred : " + e), (Throwable)e);
                }
            } else {
                logger.info((Object)("Calling synchronize for statusPlugin : " + statusPlugin + ", externalIds=" + externalIds));
                try {
                    statusPlugin.synchronize(externalIds);
                }
                catch (Exception e) {
                    logger.warn((Object)("Exception occurred : " + e), (Throwable)e);
                }
            }
        } else {
            logger.warn((Object)("Got 'null' Status Plugin for pluginId = " + pluginId + ". Cannot update monitoring status..."));
        }
    }

    public void shutdown() {
        logger.info((Object)"Shutting down StatusPluginManager...");
        this.pluginManager.shutdown();
    }

    public Collection<IStatusPlugin> getAllStatusPlugins() {
        ArrayList<IStatusPlugin> statusPlugins = new ArrayList<IStatusPlugin>();
        PluginRegistry pluginRegistry = this.pluginManager.getRegistry();
        logger.debug((Object)("StatusPluginManager : Got pluginRegistry : " + pluginRegistry));
        Collection pluginDescriptors = pluginRegistry.getPluginDescriptors();
        logger.debug((Object)("StatusPluginManager : Got pluginDescriptors : " + pluginDescriptors));
        for (PluginDescriptor pluginDescriptor : pluginDescriptors) {
            logger.debug((Object)("Got pluginDescriptor = " + pluginDescriptor));
            String pluginId = pluginDescriptor.getId();
            logger.debug((Object)("Got plugin id = " + pluginId));
            try {
                Plugin plugin = this.pluginManager.getPlugin(pluginId);
                logger.debug((Object)("Got plugin : " + plugin));
                if (plugin instanceof IStatusPlugin) {
                    statusPlugins.add((IStatusPlugin)plugin);
                    continue;
                }
                logger.warn((Object)("Found plug-in which is not a status plug-in : " + plugin));
            }
            catch (Exception e) {
                logger.warn((Object)("Exception occured getting Plugin for pluginId : " + pluginId + " : " + e), (Throwable)e);
            }
        }
        return statusPlugins;
    }

    protected PluginManager intializeMonitoringPlugins() {
        Properties properties = new Properties();
        String installFolder = System.getProperty(PROPERTY_NAME_PRODUCT_DIR);
        File pluginFolder = new File(installFolder, PLUGINS_FOLDER_RELATIVE_PATH);
        String pluginFolderAbsolutePath = pluginFolder.getAbsolutePath();
        logger.info((Object)("Setting Status Plugin Manager Plugins Folder to : " + pluginFolderAbsolutePath));
        properties.put(JPF_PLUGIN_REPOSITORY_PROPERTY, pluginFolder.getAbsolutePath());
        JPFActivator jpfActivator = new JPFActivator();
        jpfActivator.start(properties);
        return jpfActivator.getPluginManager();
    }

    protected void activatePlugins(PluginManager pluginManager) throws PluginLifecycleException {
        PluginRegistry pluginRegistry = pluginManager.getRegistry();
        logger.info((Object)("StatusPluginManager : Got pluginRegistry : " + pluginRegistry));
        Collection pluginDescriptors = pluginRegistry.getPluginDescriptors();
        logger.info((Object)("StatusPluginManager : Got pluginDescriptors : " + pluginDescriptors));
        for (PluginDescriptor pluginDescriptor : pluginDescriptors) {
            try {
                logger.info((Object)("Got pluginDescriptor = " + pluginDescriptor));
                String pluginId = pluginDescriptor.getId();
                logger.info((Object)("Got plugin id = " + pluginId));
                logger.info((Object)("Starting plugin : " + pluginId));
                pluginManager.activatePlugin(pluginId);
                Plugin plugin = pluginManager.getPlugin(pluginId);
                logger.info((Object)("Got plugin : " + plugin));
                if (!(plugin instanceof IStatusPlugin)) continue;
                IStatusPlugin statusPlugin = (IStatusPlugin)plugin;
                statusPlugin.setAppStartTime(this.appStartTime);
                statusPlugin.setLoaded(true);
            }
            catch (Exception e) {
                logger.error((Object)("Exception occurred activating plug-in : " + pluginDescriptor), (Throwable)e);
            }
        }
    }

    protected void startMonitoring(PluginManager pluginManager) throws PluginLifecycleException {
        logger.info((Object)("StatusPluginManager : startMonitoring invoked for pluginManager : " + pluginManager));
        SiteMonitoringDao siteMonitoringDao = new SiteMonitoringDao();
        boolean associated = true;
        boolean monitoringEnabled = true;
        List<SiteMonitoring> siteMonitoringList = siteMonitoringDao.findAllMonitorable(associated, monitoringEnabled);
        for (SiteMonitoring siteMonitoring : siteMonitoringList) {
            int siteId = siteMonitoring.getSiteId();
            String pluginId = siteMonitoring.getPluginId();
            ArrayList<Integer> siteIds = new ArrayList<Integer>();
            siteIds.add(siteId);
            this.instructPluginStartMonitoring(pluginId, siteIds);
        }
    }

    protected void stopMonitoring(PluginManager pluginManager) throws PluginLifecycleException {
        logger.info((Object)("StatusPluginManager : stopMonitoring invoked for pluginManager : " + pluginManager));
        SiteMonitoringDao siteMonitoringDao = new SiteMonitoringDao();
        boolean associated = true;
        boolean monitoringEnabled = true;
        List<SiteMonitoring> siteMonitoringList = siteMonitoringDao.findAllMonitorable(associated, monitoringEnabled);
        for (SiteMonitoring siteMonitoring : siteMonitoringList) {
            int siteId = siteMonitoring.getSiteId();
            String pluginId = siteMonitoring.getPluginId();
            ArrayList<Integer> siteIds = new ArrayList<Integer>();
            siteIds.add(siteId);
            this.instructPluginStopMonitoring(pluginId, siteIds, false);
        }
    }

    @Transactional
    protected Collection<String> getExternalIds(String pluginId, Collection<Integer> siteIds) {
        String string = pluginId;
        Collection<Integer> collection = siteIds;
        return (Collection)StatusPluginManager.getExternalIds_aroundBody1$advice(this, string, collection, TransactionEnforcer.aspectOf(), StatusPluginManager.class.getDeclaredMethod("getExternalIds", String.class, Collection.class).getAnnotation(Transactional.class), null);
    }

    protected StatusPluginType getStatusPluginType(String pluginId) {
        StatusPluginType statusPluginType = StatusPluginType.UNKNOWN;
        IStatusPlugin statusPlugin = this.getStatusPlugin(pluginId);
        if (statusPlugin != null) {
            statusPluginType = statusPlugin.getPluginType();
        }
        return statusPluginType;
    }

    protected void instructPluginStartMonitoring(String pluginId, Collection<Integer> siteIds) {
        logger.info((Object)("Instructing plug-in pluginId=" + pluginId + " to start monitoring siteIds=" + siteIds));
        IStatusPlugin statusPlugin = this.getStatusPlugin(pluginId);
        if (statusPlugin != null) {
            Collection<String> externalIds = this.getExternalIds(pluginId, siteIds);
            String configId = this.getConfigId(pluginId);
            logger.info((Object)("Instructing plug-in pluginId=" + pluginId + ", configId=" + configId + " to start monitoring externalIds=" + externalIds));
            if (configId != null) {
                try {
                    statusPlugin.startMonitoring(configId, externalIds);
                }
                catch (Exception e) {
                    logger.warn((Object)("Exception occurred : " + e), (Throwable)e);
                }
            } else {
                try {
                    statusPlugin.startMonitoring(externalIds);
                }
                catch (Exception e) {
                    logger.warn((Object)("Exception occurred : " + e), (Throwable)e);
                }
            }
        } else {
            logger.warn((Object)("Got 'null' Status Plugin for pluginId = " + pluginId + ". Cannot start monitoring..."));
        }
    }

    protected void instructPluginStopMonitoring(String pluginId, Collection<Integer> siteIds, boolean dissociatedFlag) {
        logger.info((Object)("Instructing plug-in pluginId=" + pluginId + " to stop monitoring siteIds=" + siteIds + " with dissociatedFlag=" + dissociatedFlag));
        IStatusPlugin statusPlugin = this.getStatusPlugin(pluginId);
        if (statusPlugin != null) {
            Collection<String> externalIds = this.getExternalIds(pluginId, siteIds);
            String configId = this.getConfigId(pluginId);
            logger.info((Object)("Instructing plug-in pluginId=" + pluginId + ", configId=" + configId + " to stop monitoring externalIds=" + externalIds + " with dissociatedFlag=" + dissociatedFlag));
            if (configId != null) {
                try {
                    statusPlugin.stopMonitoring(configId, externalIds, dissociatedFlag);
                }
                catch (Exception e) {
                    logger.warn((Object)("Exception occurred : " + e), (Throwable)e);
                }
            } else {
                try {
                    statusPlugin.stopMonitoring(externalIds, dissociatedFlag);
                }
                catch (Exception e) {
                    logger.warn((Object)("Exception occurred : " + e), (Throwable)e);
                }
            }
        } else {
            logger.warn((Object)("Got 'null' Status Plugin for pluginId = " + pluginId + ". Cannot stop monitoring..."));
        }
    }

    protected IStatusPlugin getStatusPluginForSiteMonitoring(SiteMonitoring siteMonitoring) {
        IStatusPlugin statusPlugin = null;
        if (siteMonitoring != null) {
            String pluginId = siteMonitoring.getPluginId();
            String monitoringType = siteMonitoring.getMonitoringType();
            StatusPluginType statusPluginType = StatusPluginType.valueOf((String)monitoringType);
            statusPlugin = this.getStatusPlugin(pluginId);
            if (statusPlugin != null) {
                logger.debug((Object)("SiteMonitoring instance with pluginId : " + pluginId + ", and the corresponding plug-in found..."));
                statusPlugin.setId(pluginId);
                statusPlugin.setLoaded(true);
                Map multiConfiguration = statusPlugin.getMultiConfiguration();
                if (multiConfiguration != null && !multiConfiguration.isEmpty()) {
                    String configId = this.getConfigId(pluginId);
                    Map configuration = (Map)multiConfiguration.get(configId);
                    logger.debug((Object)("Setting statusPlugin configuration to : " + configuration + " for configId : " + configId));
                    statusPlugin.setConfiguration(configuration);
                }
                logger.debug((Object)("Returning statusPlugin instance : " + statusPlugin));
            } else {
                logger.warn((Object)("SiteMonitoring instance found with pluginId : " + pluginId + ", but the corresponding plug-in not found - may have been removed."));
                StatusPluginBase dummyStatusPlugin = new StatusPluginBase();
                dummyStatusPlugin.setId(pluginId);
                dummyStatusPlugin.setName(pluginId);
                dummyStatusPlugin.setLoaded(false);
                dummyStatusPlugin.setPluginType(statusPluginType);
                logger.warn((Object)("Returning dummy plug-in instance : " + dummyStatusPlugin));
                statusPlugin = dummyStatusPlugin;
            }
        }
        return statusPlugin;
    }

    protected void updateStatusForAllPlugins(LogicalSite logicalSite) {
        if (logicalSite != null) {
            Set distributionSites = logicalSite.getChildren();
            for (DistributionSite distributionSite : distributionSites) {
                this.updateStatusForAllPlugins(distributionSite);
            }
        } else {
            logger.warn((Object)"Got 'null' logicalSite...");
        }
    }

    protected void updateStatusForAllPlugins(DistributionSite distributionSite) {
        if (distributionSite != null) {
            Integer distributionSiteId = distributionSite.getId();
            ArrayList<Integer> siteIds = new ArrayList<Integer>();
            siteIds.add(distributionSiteId);
            Collection<IStatusPlugin> statusPlugins = this.getAssociatedPluginsForSite(distributionSiteId);
            for (IStatusPlugin statusPlugin : statusPlugins) {
                String pluginId = statusPlugin.getId();
                this.updateStatus(pluginId, siteIds);
            }
            Set trackingSites = distributionSite.getChildren();
            for (TrackingSite trackingSite : trackingSites) {
                this.updateStatusForAllPlugins(trackingSite);
            }
        } else {
            logger.warn((Object)"Got 'null' distributionSite...");
        }
    }

    protected void updateStatusForAllPlugins(TrackingSite trackingSite) {
        if (trackingSite != null) {
            Integer trackingSiteId = trackingSite.getId();
            ArrayList<Integer> siteIds = new ArrayList<Integer>();
            siteIds.add(trackingSiteId);
            Collection<IStatusPlugin> statusPlugins = this.getAssociatedPluginsForSite(trackingSiteId);
            for (IStatusPlugin statusPlugin : statusPlugins) {
                String pluginId = statusPlugin.getId();
                this.updateStatus(pluginId, siteIds);
            }
        } else {
            logger.warn((Object)"Got 'null' trackingSite...");
        }
    }

    protected String getPluginId(String id) {
        String pluginId = null;
        if (id != null) {
            pluginId = id;
            if (id.contains("#")) {
                String[] idArray = id.split("#");
                pluginId = idArray[0];
            }
        }
        return pluginId;
    }

    protected String getConfigId(String id) {
        String configId = null;
        if (id != null && id.contains("#")) {
            String[] idArray = id.split("#");
            configId = idArray.length > 1 ? idArray[1] : "";
        }
        return configId;
    }

    public void startMasterAssociate(String pluginId, StatusPluginType statusPluginType, int siteId, boolean startMonitoring) {
        PluginAssociateCallable callable = new PluginAssociateCallable(pluginId, statusPluginType, siteId, startMonitoring);
        this.executor.schedule((Callable)((Object)callable));
    }

    public void startMasterMonitoring(String pluginId, Collection<Integer> siteIds) {
        PluginMonitorStartCallable callable = new PluginMonitorStartCallable(pluginId, siteIds);
        this.executor.schedule((Callable)((Object)callable));
    }

    public void dissociateMaster(String associatedPluginId, StatusPluginType status, Collection<Integer> siteIds) {
        PluginDisassociateCallable callable = new PluginDisassociateCallable(associatedPluginId, status, siteIds);
        this.executor.schedule((Callable)((Object)callable));
    }

    private static final /* synthetic */ Collection getExternalIds_aroundBody0(StatusPluginManager this_, String pluginId, Collection siteIds) {
        HashSet<String> externalSiteIds = new HashSet<String>();
        StatusPluginType statusPluginType = this_.getStatusPluginType(pluginId);
        for (Integer siteId : siteIds) {
            String externalSiteId;
            Site site = null;
            try {
                site = this_.siteManager.getSite(siteId.intValue());
            }
            catch (Exception e) {
                logger.warn((Object)("Exception occurred getting site for siteId : " + siteId + " : " + e), (Throwable)e);
            }
            if (site == null) continue;
            if (StatusPluginType.DISTRIBUTION_STATUS.equals((Object)statusPluginType)) {
                if (!SiteType.DISTRIBUTION.equals((Object)site.getType()) || (externalSiteId = site.getExternalId()) == null) continue;
                externalSiteIds.add(externalSiteId);
                continue;
            }
            if (!StatusPluginType.DEPLOYMENT_STATUS.equals((Object)statusPluginType)) continue;
            if (SiteType.DISTRIBUTION.equals((Object)site.getType())) {
                externalSiteId = site.getExternalId();
                if (externalSiteId != null) {
                    externalSiteIds.add(externalSiteId);
                }
                Set trackingSites = site.getSiteChildren();
                for (Site trackingSite : trackingSites) {
                    String trackingExternalSiteId;
                    if (!SiteType.TRACKING.equals((Object)trackingSite.getType()) || (trackingExternalSiteId = trackingSite.getExternalId()) == null) continue;
                    externalSiteIds.add(trackingExternalSiteId);
                }
                continue;
            }
            if (!SiteType.TRACKING.equals((Object)site.getType()) || (externalSiteId = site.getExternalId()) == null) continue;
            externalSiteIds.add(externalSiteId);
        }
        logger.debug((Object)("Returning with externalIds = " + externalSiteIds + " for siteIds = " + siteIds));
        return externalSiteIds;
    }

    private static final /* synthetic */ Object getExternalIds_aroundBody1$advice(StatusPluginManager this_, String pluginId, Collection siteIds, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return StatusPluginManager.getExternalIds_aroundBody0(this_, pluginId, siteIds);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Collection object = StatusPluginManager.getExternalIds_aroundBody0(this_, pluginId, siteIds);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }
}

