/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.contentmgmt.titlelist.ejb;

import com.ericsson.cms.criteria.ExpList;
import com.ericsson.cms.criteria.ExpNode;
import com.ericsson.cms.criteria.ExpValue;
import com.ericsson.cms.criteria.FieldType;
import com.ericsson.cms.criteria.LogicalOperator;
import com.ericsson.cms.criteria.Predicate;
import com.ericsson.cms.criteria.PredicateRightValue;
import com.tandbergtv.cms.contentmgmt.titlelist.entities.AssetList;
import com.tandbergtv.cms.contentmgmt.titlelist.entities.AssetListAssetMap;
import com.tandbergtv.cms.contentmgmt.titlelist.entities.TitleAssetId;
import com.tandbergtv.cms.contentmgmt.titlelist.service.AssetListDeleteException;
import com.tandbergtv.cms.contentmgmt.titlelist.service.AssetListErrorCode;
import com.tandbergtv.cms.contentmgmt.titlelist.service.AssetListExporterException;
import com.tandbergtv.cms.contentmgmt.titlelist.service.AssetListValidationException;
import com.tandbergtv.cms.contentmgmt.titlelist.service.IAssetListDeleteValidator;
import com.tandbergtv.cms.contentmgmt.titlelist.service.IAssetListExporter;
import com.tandbergtv.cms.contentmgmt.titlelist.service.IAssetListManager;
import com.tandbergtv.cms.contentmgmt.titlelist.service.IAssetListTypeManager;
import com.tandbergtv.cms.contentmgmt.titlelist.service.IAssetListValidator;
import com.tandbergtv.cms.title.search.ITitleSearchService;
import com.tandbergtv.neptune.configuration.service.IConfigurationService;
import com.tandbergtv.neptune.util.InjectionUtil;
import com.tandbergtv.watchpoint.pmm.dao.hibernate.HibernateContext;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.title.ITitleManager;
import com.tandbergtv.watchpoint.pmm.util.RulesEngineFacade;
import com.tandbergtv.watchpoint.search.Entity;
import com.tandbergtv.watchpoint.search.QueryBuilder;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.driver.search.SearchParameterBase;
import com.tandbergtv.workflow.driver.search.SearchType;
import com.tandbergtv.workflow.driver.search.SortParameter;
import com.tandbergtv.workflow.driver.search.ValueParameter;
import com.tandbergtv.workflow.util.SearchCriteria;
import com.tandbergtv.workflow.util.SortingOrder;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

@Stateless
@TransactionAttribute
public class AssetListManager
implements IAssetListManager {
    private IAssetListTypeManager assetListTypeManager = (IAssetListTypeManager)InjectionUtil.injectInstance((String)"cms/AssetListTypeManager/local", IAssetListTypeManager.class);
    private IConfigurationService configReaderService = (IConfigurationService)InjectionUtil.injectInstance((String)"cms/ConfigurationService/local", IConfigurationService.class);
    private String TITLELIST_EXPORT_FOLDER = "titleListExportFolder";
    private static final String FIELDS_VOD_PLAYLIST_ID = "/Fields/VodPlaylistId";
    private ITitleSearchService titleSearchService = (ITitleSearchService)InjectionUtil.injectInstance((String)"cms/TitleSearchServiceProxy/local", ITitleSearchService.class);
    private static String TITLELIST_PACKAGE_NAME = "com.ericsson.cms.titlelist";
    private int MAX_NAME_LENGTH = 50;
    private int MAX_DESCRIPTION_LENGTH = 255;

    protected Session getSession() {
        return HibernateContext.getContext().getCurrentSession();
    }

    private ITitleManager getTitleManager() {
        return (ITitleManager)ServiceRegistry.getDefault().lookup(ITitleManager.class);
    }

    private AssetList save(AssetList assetList) {
        try {
            Session session = this.getSession();
            session.saveOrUpdate((Object)assetList);
            PredicateRightValue prv = new PredicateRightValue();
            prv.setFieldLeft(FIELDS_VOD_PLAYLIST_ID);
            prv.setFieldLeftSectionType("PACKAGE");
            prv.setFieldTypeLhs(FieldType.ASSET);
            prv.setDataType("string");
            prv.setOperator(LogicalOperator.EQUAL);
            prv.setValue("" + assetList.getId());
            ExpList rootNode = new ExpList();
            rootNode.addItem((ExpNode)new ExpValue((Predicate)prv));
            List myResult = this.titleSearchService.search((ExpNode)rootNode);
            for (Title title : myResult) {
                RulesEngineFacade.sendUIUpdatedEvent((Title)title);
            }
            return assetList;
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to save " + assetList, ex);
        }
    }

    public AssetList get(long id) {
        Session session = this.getSession();
        return (AssetList)session.load(AssetList.class, (Serializable)Long.valueOf(id));
    }

    public String export(Long assetListId) throws AssetListExporterException {
        AssetList assetList = this.get(assetListId);
        String typeName = assetList.getType();
        String folderPath = null;
        try {
            folderPath = this.getFolderPath();
            File dir = new File(folderPath, typeName);
            folderPath = dir.getAbsolutePath();
            if (dir.exists() && !dir.canWrite()) {
                throw new IllegalArgumentException("Can't write to destination folder: " + folderPath);
            }
        }
        catch (Exception e) {
            AssetListExporterException expException = new AssetListExporterException();
            expException.initCause((Throwable)e);
            throw expException;
        }
        return this.export(assetListId, folderPath);
    }

    public String export(Long assetListId, String dirPath) throws AssetListExporterException {
        AssetList assetList = this.get(assetListId);
        IAssetListValidator validator = null;
        IAssetListExporter exporter = null;
        validator = this.assetListTypeManager.getValidatorByTypeName(assetList.getType());
        if (validator != null) {
            try {
                validator.validateAssetList(assetList);
            }
            catch (AssetListValidationException e) {
                AssetListExporterException expException = new AssetListExporterException();
                expException.initCause((Throwable)e);
                throw expException;
            }
        }
        exporter = this.assetListTypeManager.getExporterByTypeName(assetList.getType());
        String filePath = "";
        if (exporter != null) {
            File dir = new File(dirPath);
            dir.mkdirs();
            filePath = exporter.export(assetList, dirPath);
        }
        return filePath;
    }

    private String getFolderPath() throws Exception {
        String folderPath = (String)this.configReaderService.getProperties(TITLELIST_PACKAGE_NAME).get(this.TITLELIST_EXPORT_FOLDER);
        if (folderPath == null || folderPath.trim().isEmpty()) {
            throw new IllegalArgumentException(this.TITLELIST_EXPORT_FOLDER + " is not configured. Please configure that via the Settings module.");
        }
        return folderPath;
    }

    public Collection<AssetList> search(int start, int length, String sortProperty, boolean isAscending) {
        SearchCriteria criteria = new SearchCriteria();
        Entity e = new Entity("assetList", AssetList.class, "al");
        SortingOrder sortOrder = SortingOrder.ASCENDING;
        if (!isAscending) {
            sortOrder = SortingOrder.DESCENDING;
        }
        e.addParameter((SearchParameterBase)new SortParameter(sortProperty, sortOrder));
        criteria.addParameter((SearchParameterBase)e);
        criteria.setStartingRecordNumber(start);
        criteria.setRecordsCount(length);
        String s = this.getQuery(criteria);
        Session session = this.getSession();
        Query query = session.createQuery(s);
        query.setFirstResult(start);
        query.setMaxResults(criteria.getRecordsCount() == 0 ? Integer.MAX_VALUE : criteria.getRecordsCount());
        return query.list();
    }

    public Collection<AssetList> search(int start, int length, String sortProperty, boolean isAscending, String typeName) {
        SearchCriteria criteria = new SearchCriteria();
        Entity e = new Entity("assetList", AssetList.class, "al");
        e.addParameter((SearchParameterBase)new ValueParameter("type", SearchType.STRING, (Object)typeName));
        criteria.addParameter((SearchParameterBase)e);
        String s = this.getQuery(criteria);
        Session session = this.getSession();
        Query query = session.createQuery(s);
        query.setMaxResults(criteria.getRecordsCount() == 0 ? Integer.MAX_VALUE : criteria.getRecordsCount());
        return query.list();
    }

    public List<AssetList> getAllAssetLists() {
        Session session = this.getSession();
        String queryStr = "FROM com.tandbergtv.cms.contentmgmt.titlelist.entities.AssetList";
        Query query = session.createQuery(queryStr);
        return query.list();
    }

    public List<AssetList> getAllAssetListsByTitleId(Long titleId) {
        StringBuilder queryStr = new StringBuilder("SELECT DISTINCT al ");
        queryStr.append("FROM com.tandbergtv.cms.contentmgmt.titlelist.entities.AssetList al ");
        queryStr.append("JOIN al.assetsMap am ");
        queryStr.append("WHERE am.title.id = :TITLE_ID");
        Session session = this.getSession();
        Query query = session.createQuery(queryStr.toString());
        query.setParameter("TITLE_ID", (Object)titleId);
        return query.list();
    }

    private boolean verifyDuplicateName(AssetList assetList) {
        boolean duplicated = false;
        Criteria crit = this.getSession().createCriteria(AssetList.class);
        crit.add((Criterion)Restrictions.eq((String)"name", (Object)assetList.getName()));
        List resultList = crit.list();
        for (AssetList al : resultList) {
            if (assetList.getId() == 0L) {
                if (!al.getName().equals(assetList.getName())) continue;
                duplicated = true;
                break;
            }
            if (al.getId() == assetList.getId()) continue;
            duplicated = true;
            break;
        }
        return duplicated;
    }

    public int count() {
        SearchCriteria criteria = new SearchCriteria();
        Entity e = new Entity("assetList", AssetList.class, "al");
        criteria.addParameter((SearchParameterBase)e);
        String s = QueryBuilder.newInstance().buildCountQuery(criteria);
        Session session = this.getSession();
        Query query = session.createQuery(s);
        long count = (Long)query.uniqueResult();
        return (int)count;
    }

    private String getQuery(SearchCriteria criteria) {
        return QueryBuilder.newInstance().buildQuery(criteria);
    }

    public AssetList addAssets(long assetListId, List<TitleAssetId> titleAssetIdsList) throws AssetListValidationException {
        AssetList assetList = this.get(assetListId);
        ArrayList<AssetListAssetMap> titleAssetsToAdd = new ArrayList<AssetListAssetMap>();
        if (assetList != null) {
            Long alContentClass = assetList.getContentClass();
            IAssetListValidator validator = this.assetListTypeManager.getValidatorByTypeName(assetList.getType());
            for (TitleAssetId titleAssetId : titleAssetIdsList) {
                AssetListValidationException alve;
                Title title = this.getTitleManager().get(titleAssetId.getTitleId());
                if (!title.getIsActive().booleanValue()) {
                    alve = new AssetListValidationException();
                    alve.add(AssetListErrorCode.DELETED_TITLE_ADDED);
                    throw alve;
                }
                if (validator != null) {
                    validator.validateAssetToAdd(title, titleAssetId.getAssetId().longValue(), assetList);
                }
                if (alContentClass != null && !alContentClass.equals(title.getContentClassId())) {
                    alve = new AssetListValidationException();
                    alve.add(AssetListErrorCode.INVALID_CONTENT_CLASS);
                    throw alve;
                }
                AssetListAssetMap assetMap = new AssetListAssetMap(title, titleAssetId.getAssetId().longValue());
                titleAssetsToAdd.add(assetMap);
            }
        }
        assetList.addAssetsMap(titleAssetsToAdd);
        this.save(assetList);
        return assetList;
    }

    public void removeAssetsWithElementId(long assetListId, List<Long> assetListElementIds) {
        AssetList assetList = this.get(assetListId);
        assetList.removeAssetsMapWithElementId(assetListElementIds);
        this.save(assetList);
    }

    public void removeAssets(long assetListId, List<TitleAssetId> titleAssetId) {
        AssetList assetList = this.get(assetListId);
        ArrayList<AssetListAssetMap> titleAssetsToRemove = new ArrayList<AssetListAssetMap>();
        for (TitleAssetId assetTitleId : titleAssetId) {
            long titleId = assetTitleId.getTitleId();
            long assetId = assetTitleId.getAssetId();
            AssetListAssetMap assetMap = new AssetListAssetMap(this.getTitleManager().get(Long.valueOf(titleId)), assetId);
            titleAssetsToRemove.add(assetMap);
        }
        assetList.removeAssetsMap(titleAssetsToRemove);
        this.save(assetList);
    }

    public AssetList create(AssetList assetList) throws AssetListValidationException {
        IAssetListValidator validator = null;
        validator = this.assetListTypeManager.getValidatorByTypeName(assetList.getType());
        if (validator != null) {
            validator.validateAssetList(assetList);
        }
        this.trimAssetListName(assetList);
        this.validate(assetList);
        return this.save(assetList);
    }

    public AssetList update(AssetList assetList) throws AssetListValidationException {
        IAssetListValidator validator = null;
        validator = this.assetListTypeManager.getValidatorByTypeName(assetList.getType());
        if (validator != null) {
            validator.validateAssetList(assetList);
        }
        this.trimAssetListName(assetList);
        this.validate(assetList);
        return this.save(assetList);
    }

    private void validate(AssetList assetList) throws AssetListValidationException {
        AssetListValidationException exception = new AssetListValidationException();
        if (assetList.getName() == null || assetList.getName().trim().equals("") || assetList.getName().isEmpty()) {
            exception.add(AssetListErrorCode.NAME_REQUIRED);
        } else if (assetList.getName().length() > this.MAX_NAME_LENGTH) {
            exception.add(AssetListErrorCode.MAX_NAME_LENGTH_EXCEEDED);
        } else if (this.verifyDuplicateName(assetList)) {
            exception.add(AssetListErrorCode.DUPLICATE_NAME);
        }
        if (!assetList.getDescription().isEmpty() && assetList.getDescription().length() > this.MAX_DESCRIPTION_LENGTH) {
            exception.add(AssetListErrorCode.MAX_DESCRIPTION_LENGTH_EXCEEDED);
        }
        if (exception.getCodes().size() > 0) {
            throw exception;
        }
    }

    void trimAssetListName(AssetList assetList) {
        assetList.setName(assetList.getName().trim());
    }

    public void delete(long assetListId) throws AssetListDeleteException {
        try {
            IAssetListDeleteValidator validator = null;
            Session session = this.getSession();
            AssetList assetList = this.get(assetListId);
            validator = this.assetListTypeManager.getDeleteValidatorByTypeName(assetList.getType());
            if (validator != null) {
                validator.validateAssetListDelete(assetList);
            }
            session.delete((Object)assetList);
        }
        catch (AssetListDeleteException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to delete " + assetListId, e);
        }
    }
}

