/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.contentmgmt.titlelist.ejb;

import com.tandbergtv.cms.contentmgmt.titlelist.jaxb.FileDefinitionParserXML;
import com.tandbergtv.cms.contentmgmt.titlelist.jaxb.JaxbTitleListType;
import com.tandbergtv.cms.contentmgmt.titlelist.jaxb.TitleListModelConverter;
import com.tandbergtv.cms.contentmgmt.titlelist.model.AssetListType;
import com.tandbergtv.cms.contentmgmt.titlelist.model.Field;
import com.tandbergtv.cms.contentmgmt.titlelist.service.AssetListTypeErrorCode;
import com.tandbergtv.cms.contentmgmt.titlelist.service.AssetListTypeValidationException;
import com.tandbergtv.cms.contentmgmt.titlelist.service.IAssetListDeleteValidator;
import com.tandbergtv.cms.contentmgmt.titlelist.service.IAssetListExporter;
import com.tandbergtv.cms.contentmgmt.titlelist.service.IAssetListTypeManager;
import com.tandbergtv.cms.contentmgmt.titlelist.service.IAssetListTypeService;
import com.tandbergtv.cms.contentmgmt.titlelist.service.IAssetListValidator;
import com.tandbergtv.metadatamanager.JPFActivator;
import com.tandbergtv.neptune.configuration.service.IConfigurationService;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.ejb.EJB;
import javax.xml.bind.JAXBException;
import org.apache.log4j.Logger;
import org.java.plugin.PluginClassLoader;
import org.java.plugin.PluginLifecycleException;
import org.java.plugin.PluginManager;
import org.java.plugin.registry.Extension;
import org.java.plugin.registry.ExtensionPoint;
import org.java.plugin.registry.IntegrityCheckReport;
import org.jboss.ejb3.annotation.Depends;
import org.jboss.ejb3.annotation.Service;

@Service(objectName="AssetListManagement:service=com.tandbergtv.cms.contentmgmt.titlelist.service.IAssetListTypeService")
@Depends(value={"Neptune:service=com.tandbergtv.neptune.configuration.service.IConfigurationService"})
public class AssetListTypeManager
implements IAssetListTypeService,
IAssetListTypeManager {
    private Logger logger = Logger.getLogger(AssetListTypeManager.class);
    private Map<String, AssetListTypeValidationException> pluginLoadingErrors;
    private List<IntegrityCheckReport.ReportItem> pluginIntegrityErrors;
    ExtensionPoint titleListTypes;
    private List<AssetListType> titleListPluginsLoaded;
    PluginManager pluginManagerTitleList;
    @EJB
    IConfigurationService configurationService;
    public static final String JAXB_PACKAGE_CONTEXT = "com.tandbergtv.cms.contentmgmt.titlelist.jaxb";
    public static final String TITLELIST_TYPE_PLUGIN_NAME = "com.tandbergtv.cms.contentmgmt.titlelist.type";
    public static final String TITLELIST_TYPE_EXT_POINT_NAME = "titleListType";
    public static final String TITLELIST_PLUGIN_NAME = "titleListTypeName";
    public static final String TITLELIST_PLUGIN_DISPLAY_NAME = "titleListTypeDisplayName";
    public static final String TITLELIST_DEFINITION_FILE_PARAMETER_NAME = "titleListTypeDefinitionFile";
    public static final String TITLELIST_VALIDATOR_PARAMETER_NAME = "titleListValidatorName";
    public static final String TITLELIST_DELETE_VALIDATOR_PARAMETER_NAME = "titleListDeleteValidatorName";
    public static final String TITLELIST_EXPORTER_PARAMETER_NAME = "titleListExporterName";
    public static final String TITLELIST_PLUGIN_FOLDER_RELATIVE_PATH = "plugins" + File.separator + "titlelist";
    public static final String JPF_PLUGIN_REPOSITORY_PROPERTY = "org.java.plugin.boot.pluginsRepositories";

    public void start() throws Exception {
        this.pluginLoadingErrors = new HashMap<String, AssetListTypeValidationException>();
        this.pluginIntegrityErrors = new ArrayList<IntegrityCheckReport.ReportItem>();
        this.pluginManagerTitleList = this.intializeTitleListPlugins();
        IntegrityCheckReport checkReport = this.pluginManagerTitleList.getRegistry().checkIntegrity(null, true);
        for (IntegrityCheckReport.ReportItem reportItem : checkReport.getItems()) {
            if (!reportItem.getSeverity().equals((Object)IntegrityCheckReport.Severity.ERROR)) continue;
            this.pluginIntegrityErrors.add(reportItem);
        }
        this.titleListTypes = this.getTitleListTypesExtensionPoint(this.pluginManagerTitleList);
        this.validatePluginsNames(this.pluginManagerTitleList);
        this.validatePluginsParameters(this.pluginManagerTitleList);
        this.titleListPluginsLoaded = new ArrayList<AssetListType>();
        for (Extension ext : this.titleListTypes.getConnectedExtensions()) {
            this.loadTitleListTypePlugin(ext);
        }
        if (!this.pluginLoadingErrors.isEmpty() || !this.pluginIntegrityErrors.isEmpty()) {
            this.showMessageErrors();
            throw new RuntimeException("Failed to load the title list type plugins !");
        }
        this.showSuccessMessage();
    }

    public void stop() {
        System.out.println("Title List Type Plugins Loading Interrupted !");
    }

    public IAssetListValidator getValidatorByTypeName(String typeName) {
        IAssetListValidator validator = null;
        for (AssetListType assetListType : this.titleListPluginsLoaded) {
            if (!assetListType.getName().equals(typeName)) continue;
            validator = assetListType.getTitleListTypeValidator();
        }
        return validator;
    }

    public IAssetListDeleteValidator getDeleteValidatorByTypeName(String typeName) {
        IAssetListDeleteValidator validator = null;
        for (AssetListType assetListType : this.titleListPluginsLoaded) {
            if (!assetListType.getName().equals(typeName)) continue;
            validator = assetListType.getTitleListTypeDeleteValidator();
        }
        return validator;
    }

    public IAssetListExporter getExporterByTypeName(String typeName) {
        IAssetListExporter exporter = null;
        for (AssetListType assetListType : this.titleListPluginsLoaded) {
            if (!assetListType.getName().equals(typeName)) continue;
            exporter = assetListType.getTitleListTypeExporter();
        }
        return exporter;
    }

    public List<AssetListType> getTypes() {
        if (this.titleListPluginsLoaded != null) {
            return this.titleListPluginsLoaded;
        }
        return null;
    }

    private void showSuccessMessage() {
        if (this.titleListTypes.getConnectedExtensions().size() == 0) {
            this.logger.info((Object)"Succesfully initialized the main Title List Type Plugin ");
            this.logger.info((Object)"No extensions detected for the main Title List Type Plugin");
        } else {
            this.logger.info((Object)"Succesfully initialized all the Title List Type Plugins ");
        }
    }

    private void showMessageErrors() {
        this.logger.error((Object)"Problem while loading the title list type plugins !");
        for (IntegrityCheckReport.ReportItem reportItem : this.pluginIntegrityErrors) {
            this.logger.error((Object)("PLUGIN LOAD INTEGRITY ERROR : " + reportItem.getMessage()));
        }
        for (Map.Entry entry : this.pluginLoadingErrors.entrySet()) {
            String errorMessage = "PLUGIN NAME : " + (String)entry.getKey();
            for (AssetListTypeErrorCode errorCode : ((AssetListTypeValidationException)entry.getValue()).getCodes()) {
                String errorCodeText = " ERROR CODE : " + errorCode.toString();
                this.logger.error((Object)(errorMessage + errorCodeText));
            }
        }
    }

    private void validatePluginsNames(PluginManager pluginManager) {
        ArrayList<String> pluginNames = new ArrayList<String>();
        for (Extension ext : this.titleListTypes.getAvailableExtensions()) {
            Extension.Parameter parameter = ext.getParameter(TITLELIST_PLUGIN_NAME);
            String pluginName = "";
            if (parameter == null) continue;
            pluginName = parameter.valueAsString();
            if (pluginNames.contains(pluginName)) {
                this.addError(pluginName, AssetListTypeErrorCode.DUPLICATE_NAME);
                continue;
            }
            pluginNames.add(pluginName);
        }
    }

    private void validatePluginsParameters(PluginManager pluginManager) {
        ExtensionPoint extPoint = this.getTitleListTypesExtensionPoint(pluginManager);
        for (Extension ext : extPoint.getConnectedExtensions()) {
            Extension.Parameter name = ext.getParameter(TITLELIST_PLUGIN_NAME);
            if (name != null) continue;
            this.addError(ext.getId(), AssetListTypeErrorCode.MISSING_PLUGIN_NAME);
        }
    }

    private void addError(String pluginName, AssetListTypeErrorCode errorCode) {
        AssetListTypeValidationException errors = this.pluginLoadingErrors.get(pluginName);
        if (errors == null) {
            errors = new AssetListTypeValidationException();
            this.pluginLoadingErrors.put(pluginName, errors);
        }
        errors.getCodes().add(errorCode);
    }

    private void setFieldsMetadata(Extension ext, AssetListType titleListTypePlugin) {
        String fileDefinitionName;
        PluginClassLoader classLoader = this.pluginManagerTitleList.getPluginClassLoader(ext.getDeclaringPluginDescriptor());
        FileInputStream fileDefinitionXML = (FileInputStream)classLoader.getResourceAsStream(fileDefinitionName = ext.getParameter(TITLELIST_DEFINITION_FILE_PARAMETER_NAME).valueAsString());
        if (fileDefinitionXML != null) {
            try {
                JaxbTitleListType titleListTypeParsed = FileDefinitionParserXML.parseXML(JAXB_PACKAGE_CONTEXT, fileDefinitionXML);
                List<Field> listFields = null;
                if (titleListTypeParsed.getListMetadata() != null) {
                    listFields = TitleListModelConverter.convertFieldList(titleListTypeParsed.getListMetadata().getField());
                    titleListTypePlugin.setListMetadata(listFields);
                }
                List<Field> titleFields = null;
                if (titleListTypeParsed.getAssetMetadata() != null) {
                    titleFields = TitleListModelConverter.convertFieldList(titleListTypeParsed.getAssetMetadata().getField());
                    titleListTypePlugin.setAssetMetadata(titleFields);
                }
            }
            catch (JAXBException e) {
                this.addError(ext.getId(), AssetListTypeErrorCode.ERROR_PARSING_XML_FILE_DEFINITION);
                e.printStackTrace();
            }
        } else {
            this.addError(ext.getId(), AssetListTypeErrorCode.MISSING_FILE_DEFINITION);
        }
    }

    private void loadTitleListTypePlugin(Extension ext) {
        Extension.Parameter exporterClass;
        Extension.Parameter deleteValidatorClass;
        Extension.Parameter validatorClass;
        Extension.Parameter pluginName;
        this.activatePlugin(ext);
        AssetListType titleListTypePlugin = new AssetListType();
        Extension.Parameter fileName = ext.getParameter(TITLELIST_DEFINITION_FILE_PARAMETER_NAME);
        if (fileName != null) {
            this.setFieldsMetadata(ext, titleListTypePlugin);
        }
        if ((pluginName = ext.getParameter(TITLELIST_PLUGIN_NAME)) != null) {
            titleListTypePlugin.setName(pluginName.valueAsString());
        }
        Extension.Parameter displayName = ext.getParameter(TITLELIST_PLUGIN_DISPLAY_NAME);
        titleListTypePlugin.setDisplayName(pluginName.valueAsString());
        if (displayName != null) {
            titleListTypePlugin.setDisplayName(displayName.valueAsString());
        }
        if ((validatorClass = ext.getParameter(TITLELIST_VALIDATOR_PARAMETER_NAME)) != null) {
            IAssetListValidator loadedValidator = this.getValidatorInstance(ext);
            titleListTypePlugin.setTitleListTypeValidator(loadedValidator);
        }
        if ((deleteValidatorClass = ext.getParameter(TITLELIST_DELETE_VALIDATOR_PARAMETER_NAME)) != null) {
            IAssetListDeleteValidator loadedDeleteValidator = this.getDeleteValidatorInstance(ext);
            titleListTypePlugin.setTitleListTypeDeleteValidator(loadedDeleteValidator);
        }
        if ((exporterClass = ext.getParameter(TITLELIST_EXPORTER_PARAMETER_NAME)) != null) {
            IAssetListExporter loadedExporter = this.getExporterInstance(ext);
            titleListTypePlugin.setTitleListTypeExporter(loadedExporter);
        }
        this.titleListPluginsLoaded.add(titleListTypePlugin);
    }

    private void activatePlugin(Extension ext) {
        try {
            this.pluginManagerTitleList.activatePlugin(ext.getDeclaringPluginDescriptor().getId());
        }
        catch (PluginLifecycleException e) {
            this.logger.error((Object)("Problem activating plugin : " + ext.getId()), (Throwable)e);
            this.addError(ext.getId(), AssetListTypeErrorCode.PLUGIN_ACTIVATION_PROBLEM);
            e.printStackTrace();
        }
    }

    private Class<?> loadPluginClass(Extension ext, String classNameParameter) throws ClassNotFoundException {
        PluginClassLoader classLoader = this.pluginManagerTitleList.getPluginClassLoader(ext.getDeclaringPluginDescriptor());
        Extension.Parameter className = ext.getParameter(classNameParameter);
        Class<?> titleListType = null;
        if (className != null) {
            String parameterName = className.valueAsString();
            titleListType = classLoader.loadClass(parameterName);
        }
        return titleListType;
    }

    private IAssetListValidator getValidatorInstance(Extension ext) {
        IAssetListValidator titleListValidator = null;
        Class<?> titleListTypeValidatorClass = null;
        try {
            titleListTypeValidatorClass = this.loadPluginClass(ext, TITLELIST_VALIDATOR_PARAMETER_NAME);
            if (titleListTypeValidatorClass != null) {
                titleListValidator = (IAssetListValidator)titleListTypeValidatorClass.newInstance();
            }
        }
        catch (ClassNotFoundException e) {
            this.addError(ext.getId(), AssetListTypeErrorCode.MISSING_VALIDATOR_CLASS);
            e.printStackTrace();
        }
        catch (Exception e) {
            this.logger.error((Object)("Problem creating a new instance for the plugin class : " + titleListTypeValidatorClass.getName()), (Throwable)e);
            this.addError(ext.getId(), AssetListTypeErrorCode.VALIDATOR_INSTANCE_PROBLEM);
            e.printStackTrace();
        }
        return titleListValidator;
    }

    private IAssetListDeleteValidator getDeleteValidatorInstance(Extension ext) {
        IAssetListDeleteValidator titleListDeleteValidator = null;
        Class<?> titleListTypeDeleteValidatorClass = null;
        try {
            titleListTypeDeleteValidatorClass = this.loadPluginClass(ext, TITLELIST_DELETE_VALIDATOR_PARAMETER_NAME);
            if (titleListTypeDeleteValidatorClass != null) {
                titleListDeleteValidator = (IAssetListDeleteValidator)titleListTypeDeleteValidatorClass.newInstance();
            }
        }
        catch (ClassNotFoundException e) {
            this.addError(ext.getId(), AssetListTypeErrorCode.MISSING_VALIDATOR_CLASS);
            e.printStackTrace();
        }
        catch (Exception e) {
            this.logger.error((Object)("Problem creating a new instance for the plugin class : " + titleListTypeDeleteValidatorClass.getName()), (Throwable)e);
            this.addError(ext.getId(), AssetListTypeErrorCode.VALIDATOR_INSTANCE_PROBLEM);
            e.printStackTrace();
        }
        return titleListDeleteValidator;
    }

    private IAssetListExporter getExporterInstance(Extension ext) {
        IAssetListExporter titleListExpoter = null;
        Class<?> titleListTypeExporterClass = null;
        try {
            titleListTypeExporterClass = this.loadPluginClass(ext, TITLELIST_EXPORTER_PARAMETER_NAME);
            if (titleListTypeExporterClass != null) {
                titleListExpoter = (IAssetListExporter)titleListTypeExporterClass.newInstance();
            }
        }
        catch (ClassNotFoundException e) {
            this.addError(ext.getId(), AssetListTypeErrorCode.MISSING_EXPORTER_CLASS);
            e.printStackTrace();
        }
        catch (Exception e) {
            this.logger.error((Object)("Problem creating a new instance for the plugin class : " + titleListTypeExporterClass.getName()), (Throwable)e);
            this.addError(ext.getId(), AssetListTypeErrorCode.EXPORTER_INSTANCE_PROBLEM);
            e.printStackTrace();
        }
        return titleListExpoter;
    }

    private ExtensionPoint getTitleListTypesExtensionPoint(PluginManager pluginManager) {
        String pluginId = this.getPluginId(pluginManager, TITLELIST_TYPE_PLUGIN_NAME);
        ExtensionPoint extPoint = pluginManager.getRegistry().getExtensionPoint(pluginId, TITLELIST_TYPE_EXT_POINT_NAME);
        return extPoint;
    }

    private String getPluginId(PluginManager pluginManager, String pluginName) {
        String pluginId = pluginManager.getRegistry().getPluginDescriptor(pluginName).getId();
        return pluginId;
    }

    private PluginManager intializeTitleListPlugins() {
        Properties properties = new Properties();
        String installFolder = this.configurationService.getInstallDirectory();
        File pluginFolder = new File(installFolder, TITLELIST_PLUGIN_FOLDER_RELATIVE_PATH);
        properties.put(JPF_PLUGIN_REPOSITORY_PROPERTY, pluginFolder.getAbsolutePath());
        JPFActivator jpfActivator = new JPFActivator();
        jpfActivator.start(properties);
        return jpfActivator.getPluginManager();
    }
}

