package com.ericsson.cms.categorymgmt.client;

import java.util.ArrayList;
import java.util.List;

import com.ericsson.cms.categorymgmt.client.i18n.CategoryConstants;
import com.google.gwt.core.client.GWT;
import com.tandbergtv.neptune.widgettoolkit.client.application.ClientAuthorizationManager;
import com.tandbergtv.neptune.widgettoolkit.client.application.PortletFactory;
import com.tandbergtv.neptune.widgettoolkit.client.application.Service;
import com.tandbergtv.neptune.widgettoolkit.client.component.ComponentBase;
import com.tandbergtv.neptune.widgettoolkit.client.menu.GroupMenuItem;
import com.tandbergtv.neptune.widgettoolkit.client.menu.MenuItemBase;
import com.tandbergtv.neptune.widgettoolkit.client.menu.WidgetMenuItem;
import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;

/**
 * @author   estezac
 */
public class CategoryComponent extends ComponentBase {

    /* The values for the user properties loaded during initialization */
    /**
     * @uml.property  name="constants"
     * @uml.associationEnd
     */
    private final CategoryConstants constants;
    /**
     * Constructor
     */
    public CategoryComponent() {
        constants = GWT.create( CategoryConstants.class );
    }

    // ========================================================================
    // ===================== COMPONENT METHODS
    // ========================================================================

    @Override
    public List<PortletFactory> listPortlets( NeptuneSecurity security ) {
        List<PortletFactory> portletFactories = new ArrayList<PortletFactory>();

        return portletFactories;
    }

    @Override
    public <E extends Service> List<E> listServices( Class<E> clazz, NeptuneSecurity security ) {
        return null;
    }

    // ========================================================================
    // ===================== Category Manager - MENU ITEMS
    // ========================================================================

    @Override
    public List<MenuItemBase> listTabs(final NeptuneSecurity security) {
        List<MenuItemBase> tabs = new ArrayList<MenuItemBase>();

        /* Always add the group menu item */
        List<MenuItemBase> childMenuItems = new ArrayList<MenuItemBase>();
        GroupMenuItem rootMenuItem = new GroupMenuItem("CategoryManager",
                constants.componentDisplayName(), childMenuItems);
        tabs.add(rootMenuItem);

        if(ClientAuthorizationManager.isAuthorized(Permissions.CATEGORY_VIEW))
        {
            CategoryViewWidgetFactory factory = new CategoryViewWidgetFactory();
            WidgetMenuItem viewMenuItem = new WidgetMenuItem(constants.viewSubMenuDisplayName(), factory, factory.getAnchorChangeListener());
            childMenuItems.add(viewMenuItem);
        }

        return tabs;
    }

    @Override
    public String getName() {
        return "CategoryComponent";
    }

    @Override
    public String getDisplayName() {
        return constants.componentDisplayName();
    }

}
