package com.ericsson.cms.categorymgmt.client;

import java.util.List;

import com.ericsson.cms.categorymgmt.client.i18n.CategoryConstants;
import com.ericsson.cms.categorymgmt.client.model.UICategoryHyperlink;
import com.ericsson.cms.categorymgmt.client.model.UICategoryNode;
import com.ericsson.cms.categorymgmt.client.model.UIConstants;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.IsSerializable;
import com.google.gwt.user.client.ui.Composite;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.HTMLWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;

/**
 * @author AnujJain
 *
 */
public class CategoryHeaderPanel extends Composite implements IsSerializable{
    private final VerticalContainer headerPanel;
    private final LabelWidget headerLabel = new LabelWidget();
    private final CategoryConstants constants = GWT.create(CategoryConstants.class);

    HTMLWidget br = new HTMLWidget("<BR>");
    HTMLWidget hr = new HTMLWidget("<HR style=\"height: 1px; background-color: black; color: black;\" />");

    public CategoryHeaderPanel() {
        headerPanel = new VerticalContainer();
        headerPanel.add(br);
        headerPanel.add(br);
        headerPanel.add(br);
        headerPanel.setWidth(UIConstants.WIDTH_100PC);
        headerLabel.addStyleName(UIConstants.STYLE_HEADER_LABEL);
        headerPanel.add(new LabelWidget(" "));
        headerLabel.setText("Category View: ");
        headerPanel.add(headerLabel);
        headerPanel.add(hr);
        headerPanel.add(br);
        initWidget(headerPanel);
    }

    public void setDetailView(CategoryDetailPanel detailView) {
    }

    public void refreshHeading(){
        headerLabel.setText("Category View: ");
    }

    public void updateCategoryHeaderView(UICategoryNode categoryNode){
        headerPanel.clear();
        headerPanel.add(br);
        headerPanel.add(br);
        headerPanel.add(br);
        headerPanel.add(new LabelWidget(" "));
        headerLabel.setText("Category View: " + createBreadCrumb(categoryNode));
        headerLabel.addStyleName(UIConstants.STYLE_HEADER_LABEL);
        headerPanel.add(headerLabel);
        headerPanel.add(hr);
        headerPanel.add(br);
    }

    public String createBreadCrumb(UICategoryNode categoryNode){
        String result = "";
        List<UICategoryHyperlink> links = categoryNode.getHyperlinks();
        String categoryName = categoryNode.getName();
        for (final UICategoryHyperlink link : links)
        {
            String categoryParent = link.getName();
            result += categoryParent + UIConstants.CATEGORY_HEADER_PATH_SEPARATOR;
        }
        if(categoryName != null){
            result += categoryName;
        }
        else{
            result += constants.newCategoryTempName();
        }
        return result;
    }
}
