/**
 * 
 */
package com.ericsson.cms.categorymgmt.client;

import com.ericsson.cms.categorymgmt.client.model.UIConstants;
import com.ericsson.cms.categorymgmt.client.validation.CategoryValidationView;
import com.google.gwt.dom.client.Style.Unit;
import com.google.gwt.event.logical.shared.ResizeEvent;
import com.google.gwt.event.logical.shared.ResizeHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.DockLayoutPanel;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.PopupPanel.PositionCallback;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.SplitLayoutPanel;
import com.google.gwt.user.client.ui.TabPanel;
import com.tandbergtv.neptune.widgettoolkit.client.menu.WidgetMenuItem.AnchorChangeListener;
import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.HTMLWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.PopupContainer;

/**
 * Contains Category Tree and Category Details Panel.
 * 
 * @author Anuj Jain
 */
public class CategoryViewPanel extends Composite implements AnchorChangeListener{
    ResizeableDockLayoutPanel rootPanel;
    private TabPanel tabPanel;
    private final CategoryTreePanel treePanel;
    private final CategoryDetailPanel detailPanel;
    private final CategoryHeaderPanel headerPanel;
    private final FlowPanel buttonPanel;
    private final CategoryValidationView validationView;
    private LabelWidget feedbackLabel;
    private PopupContainer feedbackContainer;

    //Message to display between detail views
    private String feedbackMessage;

    public CategoryViewPanel(NeptuneSecurity security) {

        rootPanel 	= new ResizeableDockLayoutPanel(Unit.PX);
        headerPanel = new CategoryHeaderPanel();
        validationView = new CategoryValidationView(this);

        buttonPanel = new FlowPanel();
        treePanel 	= new CategoryTreePanel(security);
        detailPanel = new CategoryDetailPanel(this, treePanel, headerPanel, validationView, buttonPanel);

        buttonPanel.setStyleName(UIConstants.STYLE_BUTTON_PANEL);

        Window.addResizeHandler(rootPanel);

        treePanel.setDetailView(detailPanel);
        headerPanel.setDetailView(detailPanel);

        rootPanel.addStyleName(UIConstants.STYLE_ROOT_PANEL);

        layout();
        initWidget(rootPanel);

    }

    @Override
    public void anchorChanged(String anchor) {
        validationView.clearMessages();
        detailPanel.anchorChanged(anchor);

    }

    protected String getFeedbackMessage(){
        return this.feedbackMessage;
    }
    protected void setFeedbackMessage(String message){
        this.feedbackMessage = message;
    }

    public void layout()
    {
        SplitLayoutPanel metadata 	= new SplitLayoutPanel(4);
        HTMLWidget br 				= new HTMLWidget("<BR>");
        FlowPanel northPanel 		= new FlowPanel();
        ScrollPanel treeScroll 		= new ScrollPanel();
        FlowPanel treeBox 			= new FlowPanel();
        ScrollPanel dataScroll 		= new ScrollPanel();
        rootPanel.clear();

        long height = Window.getClientHeight()<400?400:Window.getClientHeight()-125;
        long width 	= Window.getClientWidth()<900?900:Window.getClientWidth()-50;

        rootPanel.setSize(width+"px", height+"px");

        northPanel.add(br);
        northPanel.add(headerPanel);
        northPanel.add(br);

        treeBox.add(treePanel);
        treeScroll.add(treeBox);

        dataScroll.add(detailPanel);
        dataScroll.addStyleName(UIConstants.STYLE_CATEGORY_METADATA_AREA);

        if (validationView.hasErrors())
        {
            ScrollPanel validationScroll = new ScrollPanel();
            validationScroll.add(validationView);
            validationScroll.setHeight(UIConstants.WIDTH_100PX);
            validationScroll.setWidth(UIConstants.WIDTH_100PC);
            metadata.addNorth(validationScroll, 100);
        }

        metadata.addWest(treeScroll, 275);
        metadata.add(dataScroll);
        metadata.setSize(width-25+"px", height-123+"px");
        metadata.addStyleName(UIConstants.DEFAULT_MARGIN);

        treeBox.addStyleName(UIConstants.STYLE_TREE_PANEL);
        treeScroll.addStyleName(UIConstants.STYLE_TREE_PANEL);
        treeScroll.addStyleName(UIConstants.BASIC_BORDER);

        tabPanel = new TabPanel();
        tabPanel.add(metadata, "Metadata");
        tabPanel.selectTab(0);
        tabPanel.getDeckPanel().setStyleName(UIConstants.STYLE_MAIN_PANEL);
        tabPanel.getDeckPanel().addStyleName(UIConstants.NULL_BORDER);

        buttonPanel.setStyleName(UIConstants.STYLE_BUTTON_PANEL);
        buttonPanel.addStyleName(UIConstants.FLOAT_LEFT);

        rootPanel.addNorth(northPanel, UIConstants.HEADER_HEIGHT);
        rootPanel.addSouth(buttonPanel, UIConstants.FOOTER_HEIGHT);
        rootPanel.add(tabPanel);
    }


    private class ResizeableDockLayoutPanel extends DockLayoutPanel implements ResizeHandler{

        public ResizeableDockLayoutPanel(Unit unit) {
            super(unit);
        }

        @Override
        public void onResize(ResizeEvent event) {
            layout();
        }


    }


    /**
     * Initialize the objects to display feedback messages
     */
    public void initFeedback(){
        //Initialize the feedback bar
        this.feedbackLabel = new LabelWidget("");
        this.feedbackLabel.addStyleName(UIConstants.STYLE_FEEDBACK_LABEL);
        this.feedbackContainer = new PopupContainer(true);
        this.feedbackContainer.addStyleName(UIConstants.STYLE_FEEDBACK_POPUP);
        this.feedbackContainer.add(feedbackLabel);
        this.feedbackContainer.addAutoHidePartner(this.getElement());
    }

    /**
     * Display any feedback messages and then clear them out
     */
    public void showFeedback(){
        this.feedbackContainer.hide();
        String message = this.getFeedbackMessage();
        if(message != null && !message.isEmpty()){
            this.feedbackLabel.setText(message);
            this.feedbackContainer.setPopupPositionAndShow(new FeedbackPositionCallback());
        }
        this.setFeedbackMessage("");
    }

    public void hideFeedback(){

        if (feedbackContainer != null) {
            feedbackContainer.hide();
        }
    }

    public class FeedbackPositionCallback implements PositionCallback {

        @Override
        public void setPosition(int offsetWidth, int offsetHeight) {
            int top = rootPanel.getAbsoluteTop() + offsetHeight + 40;
            int left = detailPanel.getAbsoluteLeft() + UIConstants.WIDTH_DISCLOSURE_PANEL_INT + offsetWidth;
            left = Window.getClientWidth() - feedbackContainer.getOffsetWidth()-22;

            if (feedbackContainer != null) {
                feedbackContainer.setPopupPosition(left, top);
            }
        }
    }

    @Override
    protected void onUnload() {
        /* Hide the feedback popup */
        if (feedbackContainer != null) {
            feedbackContainer.hide();
        }
        super.onUnload();
    }


}
