/**
 * 
 */
package com.ericsson.cms.categorymgmt.client;

import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneApplication;
import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.LazyView;

/**
 * @author     Anuj Jain
 * @uml.dependency   supplier="com.ericsson.cms.categorymgmt.client.CategoryViewPanel"
 */
public class LazyCategoryView extends LazyView {

    /**
     * @uml.property  name="widget"
     * @uml.associationEnd
     */
    private CategoryViewPanel widget = null;
    public LazyCategoryView(){};

    @Override
    protected void setWidgetAnchor(String anchor) {
        widget.anchorChanged(anchor);

    }

    @Override
    protected Widget createWidget() {
        NeptuneSecurity security = NeptuneApplication.getApplication().getSecurity();
        widget = new CategoryViewPanel(security);
        return widget;
    }

    @Override
    public String getAnchor() {
        return "#CategoryManager.View";
    }

}
