/*
 * Created on Dec 13, 2011
 * 
 * (C) Copyright ERICSSON Television Inc.
 */

package com.ericsson.cms.categorymgmt.client;


/**
 * The permissions used by the category component, and verification of the current user permissions
 * 
 * @author Anuj Jain
 */
public final class Permissions {

	/* Cannot instantiate */
	private Permissions() {
	}

	/**
	 * View permission for a category
	 */
	public static final String CATEGORY_VIEW = "CategoryManager_View";

	/**
	 * Create permission for a category
	 */
	public static final String CATEGORY_CREATE = "CategoryManager_Create";

	/**
	 * Modify permission for a category
	 */
	public static final String CATEGORY_MODIFY = "CategoryManager_Modify";

	/**
	 * Delete permission for a category
	 */
	public static final String CATEGORY_DELETE = "CategoryManager_Delete";
	
	/**
	 * Target Category Title permission for a category
	 */
	public static final String CATEGORY_TARGETCATEGORYTITLE = "CategoryManager_TargetCategoryTitle";
	
	/**
	 * Configuration permission for a category
	 */
	public static final String CATEGORY_CONFIGURATION = "CategoryManager_Configuration";

}
