/**
 * 
 */
package com.ericsson.cms.categorymgmt.client.i18n;

import com.google.gwt.i18n.client.Messages;

/**
 * @author Anuj Jain
 *
 */
public interface CategoryConstants extends Messages{
	
	/** Menu and Sub Menus */
	String componentDisplayName();
	String viewSubMenuDisplayName();
	String configurationSubMenuDisplayName();
	
	/** Context Menu */
	String contextMenuCreateCategory();
	String contextMenuEditCategory();
	String contextMenuDeleteCategory();
	
	/** Category tree root node */
	String labelCategoryTreeRoot();
	String categorySelectionMessage(String name);
	
	/** Default message on category detail panel when root category is selected */
	String defaultDetailPanelMessage();
	
	/** Default message on category detail panel when non-existent category is selected */
	String defaultCategoryDoesNotExistMessage();
	
	/** Button Widgets */
	String saveButton();
	String cancelButton();
	String okButton();
	String createCategoryPackageButton();
	String targetButton();
	String deleteButton();
	
	/** Label Widgets */
	String categoryNameLabel();
	String internalVersionLabel();
	String categoryTitleLable();
	String newCategoryTempName();
	
	/** Confirmation messages */
	String saveCategoryConfirmMessage();
	String saveCategorySuccessMessage(String name);
	String deleteCategoryConfirmMessage(String name);
	String deleteCategorySuccessMessage();
	String createCategoryPackageConfirmMessage();
	String targetConfirmMessage();
	
	/** Validation messages */
	String emptyNameValidationMessage();
	String duplicateNameValidationMessage();
	String invalidCategoryNameMessage();
	String invalidInternalVersionMessage();
	String requiredFieldMissingMessage();
	String invalidValueMessage(String dataType);
	String invalidFormatMessage(String dataType, String format);
	String minLengthMessage(long length);
	String maxLengthMessage(long length);
	String uniqueMessage();
	
	/** Button titles */
	String datalossButtonTitle();
	String commitButtonTitle();
	
	String categoryName();
	String name();
	String unanticipatedException();
	String unableToSaveCategory();
	String savedSuccessfully();
	String unknownDisplayType();
	String errorDisplayingAddPanel();
	String confirmRemoveField();

}
