/**
 * 
 */
package com.ericsson.cms.categorymgmt.client.model;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import com.google.gwt.user.client.rpc.IsSerializable;

/**
 * @author Anuj Jain
 *
 * @Date Jan 11, 2012
 */
public class UICategoryFieldSchema  implements IsSerializable{
    private long id;
    private String name;
    private String dataType;
    private String displayType;
    private long minOcc;
    private long maxOcc;
    private boolean isRequiredCreate;
    private boolean isRequiredExport;
    private boolean isEnabled;
    private boolean isUnique;
    private String validationRegex;
    private long minLen;
    private long maxLen;
    private Date updateDate;
    private Date createDeate;
    private UICategoryFieldSchema parent;
    private List<UICategoryFieldSchema> children = new ArrayList<UICategoryFieldSchema>();
    private List<UICategoryFieldSchemaDefault> defaults = new ArrayList<UICategoryFieldSchemaDefault>();

    /**
     * @return the id
     */
    public long getId() {
        return id;
    }
    /**
     * @param id the id to set
     */
    public void setId(long id) {
        this.id = id;
    }
    /**
     * @return the name
     */
    public String getName() {
        return name;
    }
    /**
     * @param name the name to set
     */
    public void setName(String name) {
        this.name = name;
    }
    /**
     * @return the children
     */
    public List<UICategoryFieldSchema> getChildren() {
        return children;
    }
    /**
     * @param children the children to set
     */
    public void setChildren(List<UICategoryFieldSchema> children) {
        this.children.clear();
        if(children != null) {
            for(UICategoryFieldSchema child : children) {
                addChild(child);
            }
        }
    }

    public boolean hasChildren() {
        return !children.isEmpty();
    }

    public void addChild(UICategoryFieldSchema child) {
        if (child == null) {
            throw new IllegalArgumentException("child cannot be null");
        }
        this.children.add(child);
        child.setParent(this);
    }

    public void setParent(UICategoryFieldSchema parent) {
        this.parent = parent;
    }
    public UICategoryFieldSchema getParent() {
        return parent;
    }

    /* (non-Javadoc)
     * @see java.lang.Object#hashCode()
     */
    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = (int) (prime * result + id);
        return result;
    }

    /* (non-Javadoc)
     * @see java.lang.Object#equals(java.lang.Object)
     */
    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (getClass() != obj.getClass()) {
            return false;
        }
        UICategoryFieldSchema other = (UICategoryFieldSchema) obj;
        if (id != other.id) {
            return false;
        }
        return true;
    }


    public void setDataType(String dataType) {
        this.dataType = dataType;
    }
    public String getDataType() {
        return dataType;
    }
    public void setDisplayType(String displayType) {
        this.displayType = displayType;
    }
    public String getDisplayType() {
        return displayType;
    }

    public void setMinOcc(long minOcc) {
        this.minOcc = minOcc;
    }
    public long getMinOcc() {
        return minOcc;
    }
    public void setMaxOcc(long maxOcc) {
        this.maxOcc = maxOcc;
    }
    public long getMaxOcc() {
        return maxOcc;
    }
    public void setRequiredCreate(boolean isRequiredCreate) {
        this.isRequiredCreate = isRequiredCreate;
    }
    public boolean isRequiredCreate() {
        return isRequiredCreate;
    }
    public void setRequiredExport(boolean isRequiredExport) {
        this.isRequiredExport = isRequiredExport;
    }
    public boolean isRequiredExport() {
        return isRequiredExport;
    }
    public void setEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
    }
    public boolean isEnabled() {
        return isEnabled;
    }
    public void setUnique(boolean isUnique) {
        this.isUnique = isUnique;
    }
    public boolean isUnique() {
        return isUnique;
    }
    public void setValidationRegex(String validationRegex) {
        this.validationRegex = validationRegex;
    }
    public String getValidationRegex() {
        return validationRegex;
    }
    public void setMinLen(long minLen) {
        this.minLen = minLen;
    }
    public long getMinLen() {
        return minLen;
    }
    public void setMaxLen(long maxLen) {
        this.maxLen = maxLen;
    }
    public long getMaxLen() {
        return maxLen;
    }
    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }
    public Date getUpdateDate() {
        return updateDate;
    }
    public void setCreateDeate(Date createDeate) {
        this.createDeate = createDeate;
    }
    public Date getCreateDeate() {
        return createDeate;
    }
    public void setDefaults(List<UICategoryFieldSchemaDefault> defaults)
    {
        this.defaults = defaults;
    }
    public List<UICategoryFieldSchemaDefault> getDefaults()
    {
        return defaults;
    }

    @Override
    public String toString()
    {
        return "parent=" + (parent == null ? null : parent.getId()) + "id=" + id + " name=" + name + " dataType=" + dataType + " displayType=" + displayType + " enabled=" + isEnabled + " maxLen=" + maxLen;
    }
}
