/**
 * 
 */
package com.ericsson.cms.categorymgmt.client.model;

import java.util.ArrayList;
import java.util.List;

import com.google.gwt.user.client.rpc.IsSerializable;

/**
 * @author Anuj Jain
 *
 */
public class UICategoryTreeNode implements IsSerializable{
    private Long id;
    private String name;
    private UICategoryTreeNode parent;

    private List<UICategoryTreeNode> children = new ArrayList<UICategoryTreeNode>();

    /**
     * @return the id
     */
    public Long getId() {
        return id;
    }
    /**
     * @param id the id to set
     */
    public void setId(Long id) {
        this.id = id;
    }
    /**
     * @return the name
     */
    public String getName() {
        return name;
    }
    /**
     * @param name the name to set
     */
    public void setName(String name) {
        this.name = name;
    }
    /**
     * @return the children
     */
    public List<UICategoryTreeNode> getChildren() {
        return children;
    }
    /**
     * @param children the children to set
     */
    public void setChildren(List<UICategoryTreeNode> children) {
        this.children.clear();
        if(children != null) {
            for(UICategoryTreeNode child : children) {
                addChild(child);
            }
        }
    }

    public boolean hasChildren() {
        return !children.isEmpty();
    }

    public void addChild(UICategoryTreeNode child) {
        if (child == null) {
            throw new IllegalArgumentException("child cannot be null");
        }
        this.children.add(child);
        child.setParent(this);
    }

    protected void setParent(UICategoryTreeNode parent) {
        this.parent = parent;
    }
    public UICategoryTreeNode getParent() {
        return parent;
    }

    /* (non-Javadoc)
     * @see java.lang.Object#hashCode()
     */
    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = (int) (prime * result + id);
        return result;
    }

    /* (non-Javadoc)
     * @see java.lang.Object#equals(java.lang.Object)
     */
    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (getClass() != obj.getClass()) {
            return false;
        }
        UICategoryTreeNode other = (UICategoryTreeNode) obj;
        if (id != other.id) {
            return false;
        }
        return true;
    }

}
