package com.ericsson.cms.categorymgmt.client.model;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

import com.google.gwt.user.client.rpc.IsSerializable;

public class UIMetadataContent implements IsSerializable {
	
	/**
	 * 
	 */
	private static final long serialVersionUID = -861716355365348912L;

	private static final String BOOLEAN_TRUE = "T";
	private static final String BOOLEAN_FALSE = "F";
	
	private String string;
	private BigDecimal number;
	private Date dateTimeZone;
	private byte[] image;
	private List<UIMetadataNode> list;
	
	public String 	getString()					{return string;			}
	public void 	setString(String string)	{this.string = string;	}
	
	public void setNumber(BigDecimal value)		{this.number = value;}
	public void setNumber(long value) 			{ setNumber(BigDecimal.valueOf(value));		}
	public void setNumber(int value) 			{ setNumber(BigDecimal.valueOf(value));		}
	public void setNumber(double value) 		{ setNumber(BigDecimal.valueOf(value));		}
	public void setNumber(float value) 			{ setNumber(BigDecimal.valueOf(value));		}
	public void setNumber(Long value) 			{ setNumber(value.longValue());				}
	public void setNumber(Integer value)		{ setNumber(value.intValue());				}
	public void setNumber(Double value) 		{ setNumber(value.doubleValue());			}
	public void setNumber(Float value) 			{ setNumber(value.floatValue());			}
	
	public BigDecimal	getNumber()		{return number;	}
	public Integer 		getInteger()	{return number == null ? null : Integer.valueOf(number.intValueExact()); 	}
	public Long 		getLong()		{return number == null ? null : Long.valueOf(number.longValueExact());		} 
	public Double 		getDouble()		{return number == null ? null : Double.valueOf(number.doubleValue());		}
	public Float 		getFloat()		{return number == null ? null : Float.valueOf(number.floatValue());			}
	
	public void setDate(Date value)		{this.dateTimeZone = value;}
	
	public Date getDate()					{return dateTimeZone;	}
	
	/* image value is not used in Category component currently. */
	public void setImage(byte[] value)		{this.image = value;	} //NOSONAR
	public byte[] getImage()				{return image;			}
	
	public void setList(List<UIMetadataNode> list)	{this.list = list;	}
	public List<UIMetadataNode> getList()			{return list;		}
	
	public void setBoolean(Boolean value)		{setString(value ? BOOLEAN_TRUE : BOOLEAN_FALSE);	}
	public void setBoolean(String stringVal)	{setBoolean(BOOLEAN_TRUE.equals(stringVal)?Boolean.TRUE:Boolean.FALSE);}

	public Boolean getBoolean()					{return getString()==null || BOOLEAN_TRUE.equals(getString()) ? Boolean.FALSE : Boolean.TRUE;}

	public boolean hasValue(){
		boolean hasValue = false;
		
		hasValue = (string != null) || (number != null) || (dateTimeZone != null) || (image != null) || (list != null);
		
		return hasValue;
	}
}
