package com.ericsson.cms.categorymgmt.client.model;

import java.util.List;

import com.google.gwt.user.client.rpc.IsSerializable;

public class UIMetadataNode implements IsSerializable {

    private static final String DATATYPE_SET = "Set";
    private static final String DATATYPE_STRING = "String";
    private static final String DATATYPE_STRING_CHOICE = "String Choice";
    private static final String DATATYPE_INTEGER = "Integer";
    private static final String DATATYPE_INTEGER_CHOICE = "Number Choice";
    private static final String DATATYPE_DECIMAL = "Decimal";
    private static final String DATATYPE_DATETIMEZONE = "DateTimeZone";
    private static final String DATATYPE_IMAGE = "Image";
    private static final String DATATYPE_BOOLEAN = "Boolean";

    private UICategoryFieldSchema schema;
    private UIMetadataContent content;

    private Long id;
    private Long occNum;

    private List<UIMetadataNode> parentList;

    public void setId(Long id){
        this.id = id;
    }
    public Long getId(){
        return id;
    }

    public void setSchema(UICategoryFieldSchema schema)
    {
        this.schema = schema;
    }
    public UICategoryFieldSchema getSchema()
    {
        return schema;
    }

    public void setContent(UIMetadataContent content)
    {
        this.content = content;
    }
    public UIMetadataContent getContent()
    {
        return content;
    }

    public void setOccNum(Long occNum){
        this.occNum = occNum;
    }
    public Long getOccNum(){
        return this.occNum;
    }

    public void setParentList(List<UIMetadataNode> parentList){
        this.parentList = parentList;
    }
    public List<UIMetadataNode> getParentList(){
        return this.parentList;
    }

    @Override
    public String toString()
    {
        if (DATATYPE_SET.equals(schema.getDataType()))
        {
            return schema.toString() + " size=" + (content != null ? content.getList().size() : 0);
        }
        else if (DATATYPE_STRING.equals(schema.getDataType()))
        {
            return schema.toString() + " value=" + (content != null ? content.getString() : null);
        }
        else if (DATATYPE_INTEGER.equals(schema.getDataType()))
        {
            return schema.toString() + " value=" + (content != null ? content.getLong() : null);
        }
        else if (DATATYPE_STRING_CHOICE.equals(schema.getDataType()))
        {
            return schema.toString() + " value=" + (content != null ? content.getString() : null);
        }
        else if (DATATYPE_INTEGER_CHOICE.equals(schema.getDataType()))
        {
            return schema.toString() + " value=" + (content != null ? content.getLong() : null);
        }
        else if (DATATYPE_DECIMAL.equals(schema.getDataType()))
        {
            return schema.toString() + " value=" + (content != null ? content.getDouble() : null);
        }
        else if (DATATYPE_BOOLEAN.equals(schema.getDataType()))
        {
            return schema.toString() + " value=" + (content != null ? content.getBoolean() : null);
        }
        else if (DATATYPE_DATETIMEZONE.equals(schema.getDataType()))
        {
            return "";
        }
        else if (DATATYPE_IMAGE.equals(schema.getDataType()))
        {
            return schema.toString() + " value=byte[].size->" + (content != null ? content.getImage().length : null);
        } else {
            return "Unknown datatype: " + schema.getDataType() + " content=" + content;
        }
    }

}
