/**
 * 
 */
package com.ericsson.cms.categorymgmt.client.rpc;

import java.util.List;

import com.ericsson.cms.categorymgmt.client.exception.UICategoryManagerException;
import com.ericsson.cms.categorymgmt.client.model.UICategoryFieldSchema;
import com.ericsson.cms.categorymgmt.client.model.UICategoryNode;
import com.ericsson.cms.categorymgmt.client.validation.UICategoryValidationException;
import com.google.gwt.user.client.rpc.RemoteService;
import com.google.gwt.user.client.rpc.RemoteServiceRelativePath;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneException;

/**
 * @author Anuj Jain
 *
 */

@RemoteServiceRelativePath("service/category/categoryFieldSchemaManagerService")
public interface ICategoryFieldSchemaManagerService extends RemoteService{
	
	List<UICategoryFieldSchema> getCategoryFieldSchema() throws NeptuneException;
	UICategoryNode getUICategoryNode(Long categoryId) throws NeptuneException;
	UICategoryNode getDefaultUICategory(Long parentId) throws NeptuneException;

	
	Long saveCategory(UICategoryNode categoryNode, boolean newCategory) throws NeptuneException, UICategoryValidationException, UICategoryManagerException;
	
	
}
