/**
 * 
 */
package com.ericsson.cms.categorymgmt.client.rpc;

import java.util.List;

import com.ericsson.cms.categorymgmt.client.exception.UICategoryManagerException;
import com.ericsson.cms.categorymgmt.client.model.UICategoryTreeNode;
import com.google.gwt.user.client.rpc.RemoteService;
import com.google.gwt.user.client.rpc.RemoteServiceRelativePath;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneException;

/**
 * RPC service which helps with all category manager operations.
 * 
 * @author Anuj Jain
 *
 */


@RemoteServiceRelativePath("service/category/categoryManagerService")
public interface ICategoryManagerService extends RemoteService{
	
	List<UICategoryTreeNode> getCategoryTree() throws NeptuneException;
	
	boolean deleteCategory(Long categoryId) throws NeptuneException, UICategoryManagerException;
	
}
