package com.ericsson.cms.categorymgmt.client.validation;

import java.util.ArrayList;
import java.util.List;

import com.ericsson.cms.categorymgmt.client.CategoryViewPanel;
import com.ericsson.cms.categorymgmt.client.model.UIConstants;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.SimpleContainer;

public class CategoryValidationView extends Composite{
    List<UICategoryMessage> categoryMessages;

    private final SimpleContainer mainContainer;
    private CategoryViewPanel parent;

    public CategoryValidationView(){
        this.categoryMessages = new ArrayList<UICategoryMessage>();
        this.mainContainer = new SimpleContainer();
        this.mainContainer.addStyleName(UIConstants.STYLE_VALIDATION_VIEW);
        initWidget(mainContainer);

        this.mainContainer.setVisible(false);
    }

    public CategoryValidationView(CategoryViewPanel parent){
        this.categoryMessages = new ArrayList<UICategoryMessage>();
        this.parent = parent;
        this.mainContainer = new SimpleContainer();
        this.mainContainer.addStyleName(UIConstants.STYLE_VALIDATION_VIEW);
        initWidget(mainContainer);

        this.mainContainer.setVisible(false);
    }

    public boolean hasErrors(){
        return this.categoryMessages != null && this.categoryMessages.size() > 0;
    }

    public void addValidationMessage(UICategoryMessage exception){
        this.categoryMessages.add(exception);
    }

    public void clearMessages(){
        this.categoryMessages.clear();
        refresh();
    }

    public void refresh(){
        this.setVisible(false);

        FlowPanel messageContainer = new FlowPanel();
        messageContainer.addStyleName(UIConstants.STYLE_ROOT_PANEL);

        for(UICategoryMessage curMessage : this.categoryMessages){
            LabelWidget messageLabel = new LabelWidget(curMessage.formatMessage());

            switch(curMessage.getLevel()){
            case INFO:
                messageLabel.addStyleName(UIConstants.STYLE_MESSAGE_INFO);
                break;
            case WARNING:
                break;
            case ERROR:
                messageLabel.addStyleName(UIConstants.STYLE_MESSAGE_ERROR);
                break;
            }
            messageContainer.add(messageLabel);
        }

        mainContainer.setWidget(messageContainer);
        this.setVisible(true);

        if (parent != null) {
            parent.layout();
        }

    }
}
