package com.ericsson.cms.categorymgmt.client.validation;

import java.util.ArrayList;
import java.util.List;

public class UICategoryValidationException extends Exception implements UICategoryMessage{
	private MessageLevel level = MessageLevel.ERROR;
	private String fieldName;
	private String message;
	private List<UICategoryValidationException> children = new ArrayList<UICategoryValidationException>();
	
	public UICategoryValidationException(){
		super();
	}
	
	public UICategoryValidationException(String message){
		this.message = message;
	}
	
	public UICategoryValidationException(String fieldName, String message){
		this.fieldName = fieldName;
		this.message = message;
	}
	
	public UICategoryValidationException(String fieldName, String message, Throwable cause){
		super(cause);
		this.fieldName = fieldName;
		this.message = message;				
	}
	
	public String getFieldName(){
		return this.fieldName;
	}
	
	public String getMessage(){
		return this.message;
	}
	
	public String formatMessage(){
		
		return this.fieldName != null ? this.fieldName + " - " + this.message : this.message;
	}
	
	public void setLevel(MessageLevel level){
		this.level = level;
	}
	public MessageLevel getLevel(){
		return this.level;
	}

	public List<UICategoryValidationException> getChildren() {
		return children;
	}

	public void setChildren(List<UICategoryValidationException> children) {
		this.children = children;
	}

}
