package com.tandbergtv.cms.pmm.client;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import com.ericsson.cms.scheduling.ui.client.IUISchedulerClient;
import com.google.gwt.core.client.GWT;
import com.tandbergtv.cms.pmm.client.i18n.ContentConstants;
import com.tandbergtv.cms.pmm.client.uiservices.AddTitlesToSchedule;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.ITitleService;
import com.tandbergtv.neptune.widgettoolkit.client.application.PortletFactory;
import com.tandbergtv.neptune.widgettoolkit.client.application.Service;
import com.tandbergtv.neptune.widgettoolkit.client.application.ServiceLoader;
import com.tandbergtv.neptune.widgettoolkit.client.component.Component;
import com.tandbergtv.neptune.widgettoolkit.client.component.ComponentBase;
import com.tandbergtv.neptune.widgettoolkit.client.event.EventListenerRegistry;
import com.tandbergtv.neptune.widgettoolkit.client.event.EventSink;
import com.tandbergtv.neptune.widgettoolkit.client.menu.GroupMenuItem;
import com.tandbergtv.neptune.widgettoolkit.client.menu.MenuItemBase;
import com.tandbergtv.neptune.widgettoolkit.client.menu.WidgetMenuItem;
import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.AutosizeFrame;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.Portlet;

/**
 * GWT UI component for PMM related entities.
 * 
 * TODO: Get all tab/menu names from a resource bundle.
 * 
 * @author spuranik
 * 
 */
public class ContentTraffickingComponent extends ComponentBase {

	private String SPECIFICATION_KEY = "ContentComponent.Specification";
	
	private final ContentConstants constants = GWT.create( ContentConstants.class  );

	// remember the spec. This is extracted from the info that was sent by the
	// server during init
	private String spec = "";
	
	public void init(EventListenerRegistry eventListenerRegistry,
			EventSink eventSink, ServiceLoader serviceLoader,
			Map<String, String> info) {
		super.init(eventListenerRegistry, eventSink, serviceLoader, info);
		spec = info.get(SPECIFICATION_KEY);
	}

	public List<PortletFactory> listPortlets(final NeptuneSecurity security) {
		if (!PermissionManager.isAuthorized(PermissionManager.SCHEDULE_VIEW)) {
			return null;
		}
		
		List<PortletFactory> portletFactories = new ArrayList<PortletFactory>();
		
		//get configured refresh time for portlets
		int confRefreshTimeMillis = -1;
		try {
			confRefreshTimeMillis = Integer.parseInt(info.get("pmm.portlets.refreshTime"));
		} catch(Exception e) {}
		
		final int refreshTimeMillis = (confRefreshTimeMillis != -1) ? confRefreshTimeMillis : 10000;

		//alerts
		portletFactories.add(new PortletFactory() {
			AlertListPortlet portlet = new AlertListPortlet(security, refreshTimeMillis, 
					info.get("pmm.portlets.alertDateFormat"), info.get("pmm.portlets.alerts.maxLength"));
			public Portlet getInstance() {
				return portlet;
			}

			public void release(Portlet portlet) {
			}

                        @Override
                        public Component getComponent() {
                            return ContentTraffickingComponent.this;
                        }
		});
		
		return portletFactories;
	}

	@SuppressWarnings("unchecked")
    public <E extends Service> List<E> listServices(Class<E> clazz,
			NeptuneSecurity security) {
		if (clazz.getName().equalsIgnoreCase(ITitleService.class.getName())) {
			return (List<E>) getTitleServices(security);
		} else if(clazz.equals(IUISchedulerClient.class)) {
			List<IUISchedulerClient> services = new ArrayList<IUISchedulerClient>(3);
			services.add(new SourcePartnerUISchedulerClient());
			services.add(new SelfPartnerUISchedulerClient());
			return (List<E>) services;
		}
		return null;
	}

	private List<ITitleService> getTitleServices(NeptuneSecurity security) {
		List<ITitleService> titleServices = new ArrayList<ITitleService>();
		if (PermissionManager.isAuthorized(PermissionManager.SCHEDULE_MODIFY)) {
			AddTitlesToSchedule addToScheduleService = new AddTitlesToSchedule();
			titleServices.add(addToScheduleService);
		}
		return titleServices;
	}

	public List<MenuItemBase> listTabs(NeptuneSecurity security) {
		// top level tab
		List<MenuItemBase> tabs = new ArrayList<MenuItemBase>();
		final List<MenuItemBase> pmmGroupTab = new ArrayList<MenuItemBase>();

		String specSuffix = "&spec=" + spec;

		addPartner(pmmGroupTab, specSuffix);
		addSchedule(pmmGroupTab, specSuffix);
		
		/* Always add the group menu item */
		tabs.add(new GroupMenuItem("PMM", "Partners", pmmGroupTab));

		return tabs;
	}
	private void addSchedule(List<MenuItemBase> pmmGroupTab, String specSuffix) {
		// schedule
		if (PermissionManager.isAuthorized(PermissionManager.SCHEDULE_VIEW)) {
			String url = "/pmm/schedules.do?spec=" + spec;
			final AutosizeFrame frame = createFrame();
			ScheduleAnchorChangeListener listener = new ScheduleAnchorChangeListener(
					url, frame, spec);
			final WidgetMenuItem menuItem = new WidgetMenuItem("Schedule", frame,
					listener);
			pmmGroupTab.add(menuItem);
			
		}
	}

	private void addPartner(List<MenuItemBase> pmmGroupTab, final String specSuffix) {
		// partner
		if (PermissionManager.isAuthorized(PermissionManager.PARTNER_VIEW)) {
			final AutosizeFrame frame = createFrame();
			WidgetMenuItem.AnchorChangeListener anchorChangeListener = new WidgetMenuItem.AnchorChangeListener() {
				public void anchorChanged(String anchor) {						
					if (anchor.startsWith("Modify")) {
						if (anchor.startsWith("Modify.Job")) {
							// expects the url to be of the form
							// #PMM.Partner.Modify.Job.Id=147
							String jobId = anchor.substring("Modify.Job.Id=".length());
							String url = "/pmm/jobManagement.do?method=getJob&id=" + jobId
							        + specSuffix;
							showFrame(frame, url);
						} else {
							// expects the url to be of the form:
							// #PMM.Partner.Modify?id=1
							String url = "/pmm/partnerManagement.do?method=getPartnerDetails&"
								+ anchor.substring(7)
								+ specSuffix;
							showFrame(frame, url);
						}
					} else {
						String url = "/pmm/partners.do?method=getPartnersView" + specSuffix;
						showFrame(frame, url);
					}
				}
			};
			final WidgetMenuItem partnersViewPanel = new WidgetMenuItem(
					"View", frame, anchorChangeListener);
			pmmGroupTab.add(partnersViewPanel);
		}
	}

	/**
	 * Returns the spec determined from the server for this user.
	 * 
	 * @return the spec
	 */
	public String getSpec() {
		return spec;
	}

	/* Build the frame so it can be referenced from the anchor change listener */
	private AutosizeFrame createFrame() {
		AutosizeFrame frame = new AutosizeFrame ();
		return frame;
	}
	
	/* Show a frame in the given container using the given URL */
	private void showFrame(AutosizeFrame frame, String frameURL) {
		frame.setVisible(true);
		frame.setUrl(frameURL);
	}

    @Override
    public String getName() {
        return "CONTENT_TRAFFICKING";
    }

    @Override
    public String getDisplayName() {
        return constants.componentDisplayName();
    }
}
