package com.tandbergtv.cms.pmm.client;

import com.ericsson.cms.scheduling.ui.client.Action;
import com.ericsson.cms.scheduling.ui.client.IUISchedulerClient;

public abstract class PartnerUISchedulerClient implements IUISchedulerClient {

	@Override
	public boolean isUserAuthorized(Action action) {
		switch(action) {
		case VIEW:
			return PermissionManager.isAuthorized(PermissionManager.PARTNER_VIEW);
		case CREATE:
		case ACTIVATE:
		case INACTIVATE:
		case ENABLE_EXECUTION:
		case DISABLE_EXECUTION:
		case DELETE:
			return PermissionManager.isAuthorized(PermissionManager.PARTNER_MODIFY);
		case MODIFY:
		case EXECUTE:
		default:
			return true;
		}
	}

}
