/*
 * Created on May 4, 2010
 * 
 * (C) Copyright TANDBERG Television Inc.
 */

package com.tandbergtv.cms.pmm.client;

import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneApplication;
import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;

/**
 * The permissions used by the content trafficking component, and verification of the current user
 * permissions. For use on client side only.
 * 
 * @author Vijay Silva
 */
public class PermissionManager {

	/* Cannot instantiate */
	private PermissionManager() {
	}

	/**
	 * View permission for a schedule
	 */
	public static final String SCHEDULE_VIEW = "Schedules_View";

	/**
	 * Modify permission for a schedule
	 */
	public static final String SCHEDULE_MODIFY = "Schedules_Modify";

	/**
	 * View permission for a partner
	 */
	public static final String PARTNER_VIEW = "Partners_View";

	/**
	 * Modify permission for a partner
	 */
	public static final String PARTNER_MODIFY = "Partners_Modify";

	/**
	 * View permission for a job
	 */
	public static final String JOB_VIEW = "Jobs_View";

	/**
	 * Get the Neptune Security
	 * 
	 * @return The security
	 */
	public static final NeptuneSecurity getSecurity() {
		return NeptuneApplication.getApplication().getSecurity();
	}

	/**
	 * Determine if the currently logged in user has the given permissions
	 * 
	 * @param permissions The permissions
	 * @return true if permissions present, false otherwise
	 */
	public static final boolean isAuthorized(String... permissions) {
		NeptuneSecurity security = getSecurity();
		for (String permission : permissions) {
			boolean hasPermission = (security != null && security.isUserInRole(permission));
			if (!hasPermission)
				return false;
		}

		return true;
	}
}
