package com.tandbergtv.cms.pmm.client;

import com.tandbergtv.neptune.widgettoolkit.client.menu.WidgetMenuItem;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.AutosizeFrame;

/**
 * Anchor change listener for schedule. Adds the spec value if the url contains an empty value.
 * 
 * @author spuranik
 * 
 */
public class ScheduleAnchorChangeListener implements WidgetMenuItem.AnchorChangeListener {
	private String url;
	private AutosizeFrame frame;
	private String specification;

	// Constants used to extract info from the anchor and to build the frame url.
	private final String PREFIX = "?";
	private final String CREATE = "Create?";
	private final String URL_PARAMETER_SEPARATOR = "&";
	private final String PARAMETER_VALUE_SEPARATOR = "=";
	private final String SCHEDULE_ID = "scheduleId";
	private final String SPECIFICATION = "spec";

	public ScheduleAnchorChangeListener(String url, AutosizeFrame frameContainer, String spec) {
		this.url = url;
		this.frame = frameContainer;
		this.specification = spec;
	}

	public void anchorChanged(String anchor) {
		if(anchor.startsWith(CREATE)) {
			showFrame("/pmm/createschedule.do?" + anchor.substring(CREATE.length()));
			return;
		}
		
		// If the url does not have any parameters, don't bother processing it.
		if (!anchor.startsWith(PREFIX)) {
			showFrame(url);
			return;
		}
		
		String spec = "";
		String scheduleId = "";

		// strip off the '?', split the string based on '&' and then based on '='
		anchor = anchor.isEmpty() ? anchor : anchor.substring(1);
		String[] parameters = anchor.split(URL_PARAMETER_SEPARATOR);
		for (String p : parameters) {
			String[] nameValue = p.split(PARAMETER_VALUE_SEPARATOR);
			// spec
			if (nameValue[0].equalsIgnoreCase(SPECIFICATION)) {
				spec = nameValue[1];
			}
			// scheduleid
			else if (nameValue[0].equalsIgnoreCase(SCHEDULE_ID)) {
				scheduleId = nameValue[1];
			}
		}

		// If the spec is not provided, populate it.
		spec = spec.isEmpty() ? specification : spec;

		// If the schedule is provided, then go fetch that schedule
		if (!scheduleId.isEmpty()) {
			String url = ("/pmm/scheduletitles.do" + PREFIX + SCHEDULE_ID
					+ PARAMETER_VALUE_SEPARATOR + scheduleId + URL_PARAMETER_SEPARATOR
					+ SPECIFICATION + PARAMETER_VALUE_SEPARATOR + spec);
			showFrame(url);
		}
	}

	/* Show a frame in the using the given URL */
	private void showFrame(String frameURL) {
		frame.setVisible(true);
		frame.setUrl(frameURL);	}
}
