package com.tandbergtv.cms.pmm.client.uiservices;

import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneException;

/**
 * Ui exception indicating problems when working with a title list. 
 * 
 * @author spuranik
 *
 */
public class ScheduleException extends NeptuneException {

	private static final long serialVersionUID = 1L;

	private String errorCode;
	
	private String message;
	
	public ScheduleException() {
		
	}

	public ScheduleException(String errorCode) {
		super();
		this.errorCode = errorCode;
	}

	public ScheduleException(String message, String errorCode) {
		super(message);
		setMessage(message);
		this.errorCode = errorCode;
	}
	
	/**
	 * @return the errorCode
	 */
	public String getErrorCode() {
		return errorCode;
	}

	/**
	 * @return the message
	 */
	public String getMessage() {
		return message;
	}

	/**
	 * @param message the message to set
	 */
	public void setMessage(String message) {
		this.message = message;
	}
	
}
