package com.tandbergtv.cms.pmm.client.uiservices;

import java.util.ArrayList;
import java.util.List;

import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneException;

/**
 * Exception thrown back in case of title-schedule validation
 * 
 * @author spuranik
 * 
 */
public class TitleScheduleValidation extends NeptuneException {
	private static final long serialVersionUID = 1L;

	private List<String> errorCodes;
	private String message;

	public TitleScheduleValidation() {	
		this.errorCodes = new ArrayList<String>();
	}
	
	public TitleScheduleValidation(List<String> errorCodes) {
		this.errorCodes = errorCodes;
	}

	/**
	 * @return the errorCodes
	 */
	public List<String> getErrorCodes() {
		return errorCodes;
	}

	/**
	 * @return the message
	 */
	public String getMessage() {
		return message;
	}

	/**
	 * @param message the message to set
	 */
	public void setMessage(String message) {
		this.message = message;
	}
}
