package com.tandbergtv.cms.portal.content.client;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.contentclass.ContentClassLazyView;
import com.tandbergtv.cms.portal.content.client.customfield.view.CustomFieldLazyView;
import com.tandbergtv.cms.portal.content.client.lookupkey.view.LookupKeysListPanel;
import com.tandbergtv.cms.portal.content.client.metadataconfig.MetadataConfigLazyView;
import com.tandbergtv.cms.portal.content.client.portlet.activity.ActivityPortlet;
import com.tandbergtv.cms.portal.content.client.portlet.activity.ActivityPortletConfig;
import com.tandbergtv.cms.portal.content.client.portlet.modified.LastModifiedPortlet;
import com.tandbergtv.cms.portal.content.client.rpc.title.IPitchScheduleService;
import com.tandbergtv.cms.portal.content.client.rpc.title.IPitchScheduleServiceAsync;
import com.tandbergtv.cms.portal.content.client.services.title.BulkEditService;
import com.tandbergtv.cms.portal.content.client.services.title.DeleteService;
import com.tandbergtv.cms.portal.content.client.services.title.Distribute;
import com.tandbergtv.cms.portal.content.client.services.title.RunNormalizationRuleService;
import com.tandbergtv.cms.portal.content.client.services.title.RunTemplate;
import com.tandbergtv.cms.portal.content.client.services.title.RunSiteTemplate;
import com.tandbergtv.cms.portal.content.client.services.title.SatellitePitchBottom;
import com.tandbergtv.cms.portal.content.client.services.title.SatellitePitchTop;
import com.tandbergtv.cms.portal.content.client.services.title.TargetSites;
import com.tandbergtv.cms.portal.content.client.services.title.TerrestrialPitchBottom;
import com.tandbergtv.cms.portal.content.client.services.title.TerrestrialPitchTop;
import com.tandbergtv.cms.portal.content.client.services.title.TitleSearchResultsExportService;
import com.tandbergtv.cms.portal.content.client.services.titleprogress.TitleProgressService;
import com.tandbergtv.cms.portal.content.client.tab.create.ContentCreateLazyView;
import com.tandbergtv.cms.portal.content.client.tab.search.TitleSearchWidgetFactory;
import com.tandbergtv.cms.portal.ui.title.client.criteria.UiCriteriaMode;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.ITitleProgressService;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.ITitleService;
import com.tandbergtv.neptune.widgettoolkit.client.application.ClientAuthorizationManager;
import com.tandbergtv.neptune.widgettoolkit.client.application.PortletFactory;
import com.tandbergtv.neptune.widgettoolkit.client.application.Service;
import com.tandbergtv.neptune.widgettoolkit.client.application.ServiceLoader;
import com.tandbergtv.neptune.widgettoolkit.client.application.WidgetFactory;
import com.tandbergtv.neptune.widgettoolkit.client.component.Component;
import com.tandbergtv.neptune.widgettoolkit.client.component.ComponentBase;
import com.tandbergtv.neptune.widgettoolkit.client.event.EventListenerRegistry;
import com.tandbergtv.neptune.widgettoolkit.client.event.EventSink;
import com.tandbergtv.neptune.widgettoolkit.client.menu.GroupMenuItem;
import com.tandbergtv.neptune.widgettoolkit.client.menu.MenuItemBase;
import com.tandbergtv.neptune.widgettoolkit.client.menu.WidgetMenuItem;
import com.tandbergtv.neptune.widgettoolkit.client.menu.WidgetMenuItem.AnchorChangeListener;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.LazyViewWidgetFactory;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.Portlet;

public class ContentComponent extends ComponentBase {
	/** The Content Component Name */
	public static final String COMPONENT_NAME = "Content Management";
	private static final String VIDEO_PREVIEW_LIC_KEY = "VideoPreviewLicense";
	private static final String EDIT_IMAGE_LIC_KEY = "EditImageLicense";
	private static final String CATEGORY_MANAGER_LIC_KEY = "CategoryManagerLicense";
	private static final String METADATA_ENHANCEMENT_LIC_KEY = "MetadataEnhancementLicense";

	/* The values for the user properties loaded during initialization */
	private String spec = "";
	private Integer titleHistoryRefreshRate = null;
	private Integer titleSitesRefreshRate = null;
	private Boolean sitesFeatureActive = null;
	private List<String> imageAssetTypes = new ArrayList<String>();
	private List<String> videoAssetTypes = new ArrayList<String>();
	
	private boolean licensedForImageEditing;
	private boolean licensedForVideoPreview;
	private boolean licensedForCategoryManagement;
	private boolean licensedForMetadataEnhancement;
	private IPitchScheduleServiceAsync pitchService;
	private final ContentComponentConstants constants;
	private Boolean hasMPWithTracking = false;
	/**
	 * Constructor
	 */
	public ContentComponent() {
		constants = GWT.create(ContentComponentConstants.class);
		pitchService = GWT.create(IPitchScheduleService.class);
		
	}

	

	// ========================================================================
	// ===================== COMPONENT METHODS
	// ========================================================================

	@Override
	public void init(EventListenerRegistry eventListenerRegistry, EventSink eventSink,
	        ServiceLoader serviceLoader, Map<String, String> info) {
		super.init(eventListenerRegistry, eventSink, serviceLoader, info);
		setPitchScheduleOptions();
		spec = info.get(PreferenceKeys.SPECIFICATION_NAME);
		titleHistoryRefreshRate = getIntegerValue(PreferenceKeys.TITLEVIEW_HISTORY_REFRESH_RATE);
		titleSitesRefreshRate = getIntegerValue(PreferenceKeys.TITLEVIEW_SITES_REFRESH_RATE);
		sitesFeatureActive = getBooleanValue(PreferenceKeys.SITES_FEATURE_ACTIVE);
		
		try {
			String strImageAssetTypes = info.get(PreferenceKeys.IMAGE_ASSET_TYPES);
			String[] imageAssetTypesArray = strImageAssetTypes.split(",");
			imageAssetTypes = Arrays.asList(imageAssetTypesArray);

			String strVideoAssetTypes = info.get(PreferenceKeys.VIDEO_ASSET_TYPES);
			String[] videoAssetTypesArray = strVideoAssetTypes.split(",");
			videoAssetTypes = Arrays.asList(videoAssetTypesArray);
		}
		catch(Exception ex) {
			GWT.log("Unable to get image and video asset types", ex);
		}
		
		licensedForVideoPreview = getBooleanValue(VIDEO_PREVIEW_LIC_KEY);
		licensedForImageEditing = getBooleanValue(EDIT_IMAGE_LIC_KEY);
		licensedForCategoryManagement = getBooleanValue(CATEGORY_MANAGER_LIC_KEY);
		licensedForMetadataEnhancement = getBooleanValue(METADATA_ENHANCEMENT_LIC_KEY);
		
	}

	@Override
	public List<PortletFactory> listPortlets(NeptuneSecurity security) {
		List<PortletFactory> portletFactories = new ArrayList<PortletFactory>();
		if (ClientAuthorizationManager.isAuthorized(Permissions.TITLE_VIEW)) {
			// Activity Portlet
			// Create config params
			ActivityPortletConfig apConfig = new ActivityPortletConfig();
			apConfig.setRefreshRateSecs(getRefreshRate(info));
			apConfig.setRecordCount(getActivityPortletRecordCount(info));
			// Create portlet
			Portlet portlet = new ActivityPortlet(security, apConfig);
			portletFactories.add(new GenericPortletFactory(portlet, this));

			// add last modified titles portlet
			portletFactories.add(addLastModifiedPortlet(security,info,getRefreshRate(info)));
		}
		return portletFactories;
	}

	private GenericPortletFactory addLastModifiedPortlet(NeptuneSecurity security, Map<String, String> info,
			int refresh){
		LastModifiedPortlet portlet = new LastModifiedPortlet(security, info,refresh);
		return new GenericPortletFactory(portlet, this);
	}
	/**
	 * Get refresh rate from a config map
	 * @param info
	 * @return
	 */
	private int getRefreshRate(Map<String, String> info) {
		// Default value (1 min)
		int refreshRateSecs = 60;

		// Try getting refresh rate from a config file. If it is more than 1 min update default value.
		try {
			int tmp = Integer.parseInt(info.get("ContentComponent.portlets.refreshRate"));
			if(tmp > 60) refreshRateSecs = tmp; 
		} catch(Exception e) {}
		
		return refreshRateSecs;
	}

	/**
	 * Get record count for activity portlet from a config map
	 * @param info
	 * @return
	 */
	private int getActivityPortletRecordCount(Map<String, String> info) {
		// Default value
		int recordCount = 10;

		// Try getting record count from a config file.
		try {
			int tmp = Integer.parseInt(info.get("ContentComponent.portlets.activityPortlet.recordCount"));
			// Do some validation
			if(tmp < 1) recordCount = 10;
			else if(tmp > 20) recordCount = 20;
			else recordCount = tmp;
		} catch(Exception e) {
			recordCount = 10;
		}
		
		return recordCount;
	}

	@Override
	@SuppressWarnings("unchecked")
	public <E extends Service> List<E> listServices(Class<E> clazz, NeptuneSecurity security) {
		if (clazz.getName().equalsIgnoreCase(ITitleService.class.getName())) {
			return (List<E>) getTitleServices();
		} else if (clazz.getName().equalsIgnoreCase(ITitleProgressService.class.getName())) {
			List<ITitleProgressService> tpServices = new ArrayList<ITitleProgressService>();
			tpServices.add(new TitleProgressService());
			return (List<E>) tpServices;
		}

		return null;
	}

	private List<ITitleService> getTitleServices() {
		List<ITitleService> assetServices = new ArrayList<ITitleService>();
		
		if (ClientAuthorizationManager.isAuthorized(Permissions.TITLE_DELETE)) {
			assetServices.add(new DeleteService());
		}

		if (ClientAuthorizationManager.isAuthorized(Permissions.WORKORDER_CREATE)) {
			assetServices.add(new RunTemplate());
			assetServices.add(new RunSiteTemplate());
		}
		
		if (ClientAuthorizationManager.isAuthorized(Permissions.DISTRIBUTE)) {
			assetServices.add(new Distribute());
		}

		if (ClientAuthorizationManager.isAuthorized(Permissions.TITLE_VIEW,
		        Permissions.TITLE_MODIFY)) {
			assetServices.add(new BulkEditService());
		}

		if (isSitesFeatureActive()
		        && ClientAuthorizationManager.isAuthorized(Permissions.SITE_TARGET)) {
			assetServices.add(new TargetSites());
		}

		if (ClientAuthorizationManager.isAuthorized(Permissions.TITLE_VIEW,
		        Permissions.TITLE_MODIFY)) {
			assetServices.add(new RunNormalizationRuleService());
		}

		if (ClientAuthorizationManager.isAuthorized(Permissions.TITLE_VIEW)) {
			assetServices.add(new TitleSearchResultsExportService());
		}
		if (ClientAuthorizationManager.isAuthorized(Permissions.WORKORDER_CREATE) && hasMPWithTracking) {
			assetServices.add(new SatellitePitchTop());
		}
		if (ClientAuthorizationManager.isAuthorized(Permissions.WORKORDER_CREATE) && hasMPWithTracking)  {
			assetServices.add(new SatellitePitchBottom());
		}
		if (ClientAuthorizationManager.isAuthorized(Permissions.WORKORDER_CREATE) && hasMPWithTracking)  {
			assetServices.add(new TerrestrialPitchTop());
		}
		if (ClientAuthorizationManager.isAuthorized(Permissions.WORKORDER_CREATE) && hasMPWithTracking)  {
			assetServices.add(new TerrestrialPitchBottom());
		}
		
		return assetServices;
	}

	// ========================================================================
	// ===================== CONTENT - MENU ITEMS
	// ========================================================================

	@Override
	public List<MenuItemBase> listTabs(final NeptuneSecurity security) {
		List<MenuItemBase> tabs = new ArrayList<MenuItemBase>();

		/* Build the menu group: 'Content' */
		List<MenuItemBase> childMenuItems = new ArrayList<MenuItemBase>();
		String displayName = constants.menuItemContent();
		GroupMenuItem rootMenuItem = new GroupMenuItem("Content", displayName, childMenuItems);

		/* Build the menu items for the 'title' entity */
		buildTitleMenuItems(rootMenuItem);

		// Content Class menu items
		buildContentClassMenuItems(rootMenuItem);
		
			// Lookup Key menu item
		buildLookupKeyMenuItem(rootMenuItem);

		// Configuration menu item
		buildMetadataConfigMenuItems(rootMenuItem);
		
		/* Always add the group menu item */
		tabs.add(rootMenuItem);

		return tabs;
	}

	

	// ========================================================================
	// ===================== CONTENT - TITLE MENU ITEMS
	// ========================================================================

	/*
	 * Build the menu items used to manage titles
	 */
	private void buildTitleMenuItems(GroupMenuItem parentMenuItem) {
		/* Add the title 'Search' menu item is permissions are present */
		if (ClientAuthorizationManager.isAuthorized(Permissions.TITLE_VIEW)) {
			parentMenuItem.getSubPanels().add(createSearchMenuItem("Search", constants.menuItemContentSearch(), UiCriteriaMode.EPISODE));
			parentMenuItem.getSubPanels().add(createSearchMenuItem("SeriesSearch", constants.menuItemContentSeriesSearch(), UiCriteriaMode.SERIES));
		}

			
		/* Add the title 'Create' menu item if permissions are present */
		if (ClientAuthorizationManager.isAuthorized(Permissions.TITLE_VIEW, Permissions.TITLE_CREATE)) {
			LazyViewWidgetFactory factory = new LazyViewWidgetFactory(new ContentCreateLazyView());

			AnchorChangeListener listener = factory.getAnchorChangeListener();
			String displayName = constants.menuItemContentCreate();
			WidgetMenuItem menuItem = new WidgetMenuItem("Create", displayName, factory, listener);
			factory.setAnchorChangeNotifier(menuItem.getReverseAnchorChangeListener());
			parentMenuItem.getSubPanels().add(menuItem);
		}
	}
	
	private WidgetMenuItem createSearchMenuItem(String searchName, String displayName, UiCriteriaMode criteriaMode) {
		TitleSearchWidgetFactory factory = new TitleSearchWidgetFactory(criteriaMode);
		AnchorChangeListener listener = factory.getAnchorChangeListener();
		WidgetMenuItem menuItem = new WidgetMenuItem(searchName, displayName, factory, listener);
		factory.setAnchorChangeNotifier(menuItem.getReverseAnchorChangeListener());
		return menuItem;
	}

	/**
	 * Content class menu
	 * @param parentMenuItem
	 */
	private void buildContentClassMenuItems(GroupMenuItem parentMenuItem) {
		if (ClientAuthorizationManager.isAuthorized(Permissions.CONTENT_CLASS_VIEW)) {
			LazyViewWidgetFactory factory = new LazyViewWidgetFactory(new ContentClassLazyView());
			AnchorChangeListener listener = factory.getAnchorChangeListener();
			String displayName = constants.menuItemContentClass();
			WidgetMenuItem menuItem = new WidgetMenuItem("ContentClass", displayName, factory, listener);
			factory.setAnchorChangeNotifier(menuItem.getReverseAnchorChangeListener());
			parentMenuItem.getSubPanels().add(menuItem);
		}
	}
	
	/**
	 * Lookup Key menu
	 * @param parentMenuItem
	 */
	private void buildLookupKeyMenuItem(GroupMenuItem parentMenuItem) {
		if (ClientAuthorizationManager.isAuthorized(Permissions.LOOKUP_KEY_VIEW)) {
			// add view menu
			final LookupKeysListPanel lookupKeysListPanel = new LookupKeysListPanel();
			String displayName = constants.menuItemLookupKey();
			WidgetMenuItem lookupKeysListView = new WidgetMenuItem("LookupKey", displayName, new WidgetFactory() {
				public Widget getInstance() {
					return lookupKeysListPanel;
				}

				public void release(Widget widget) {
				}
			}, lookupKeysListPanel.getAnchorChangeListener());
			lookupKeysListPanel.setReverseAnchorChangeListener(lookupKeysListView.getReverseAnchorChangeListener());
			parentMenuItem.getSubPanels().add(lookupKeysListView);
		}
	}
	
	private void buildMetadataConfigMenuItems(GroupMenuItem parentMenuItem) {
		List<MenuItemBase> configGroup = new ArrayList<MenuItemBase>();
		if ((ClientAuthorizationManager.isAuthorized(Permissions.METADATA_CONFIG_VIEW)) ||
			(ClientAuthorizationManager.isAuthorized(Permissions.CUSTOMFIELDS_VIEW))){
			String displayName = constants.menuItemConfiguration();
			GroupMenuItem menuItem = new GroupMenuItem("Configuration", displayName, configGroup);
			
			parentMenuItem.getSubPanels().add(menuItem);
			//add custom field
			// add view menu
			final CustomFieldLazyView customFieldLazyView = new CustomFieldLazyView();
			LazyViewWidgetFactory factory = new LazyViewWidgetFactory(customFieldLazyView);
			if (ClientAuthorizationManager.isAuthorized(Permissions.CUSTOMFIELDS_VIEW)) {
				String customFieldName = constants.menuItemCustomFields();
				WidgetMenuItem customFieldViewItem = new WidgetMenuItem("CustomField", customFieldName, factory, factory.getAnchorChangeListener());  
				configGroup.add(customFieldViewItem);
				}
			final MetadataConfigLazyView metadataLazyView = new MetadataConfigLazyView();
			LazyViewWidgetFactory matadataFactory = new LazyViewWidgetFactory(metadataLazyView);
			if (ClientAuthorizationManager.isAuthorized(Permissions.METADATA_CONFIG_VIEW)) {
				WidgetMenuItem configItem = new WidgetMenuItem("StandardFields", constants.menuItemStandardFields(), new WidgetFactory() {
				public Widget getInstance() {
					return metadataLazyView;
				}

				public void release(Widget widget) {
				}
			},matadataFactory.getAnchorChangeListener());  
			configGroup.add(configItem);
			}
		}
		
		
	
	}
	
	// ========================================================================
	// ===================== COMPONENT PREFERENCES
	// ========================================================================

	/**
	 * Get the name of the default specification to use when rendering the content component pages
	 */
	public String getSpecificationName() {
		return this.spec;
	}

	/**
	 * Get the refresh rate (in milliseconds) to use for the title view history page auto-refresh
	 * 
	 * @return The refresh rate
	 */
	public Integer getTitleHistoryViewRefreshRate() {
		return this.titleHistoryRefreshRate;
	}

	/**
	 * Get the refresh rate (in milliseconds) to use for the title view sites page auto-refresh
	 * 
	 * @return The refresh rate
	 */
	public Integer getTitleSitesViewRefreshRate() {
		return this.titleSitesRefreshRate;
	}

	/**
	 * @return the imageAssetTypes
	 */
	public List<String> getImageAssetTypes() {
		return imageAssetTypes;
	}

	/**
	 * @return the videoAssetTypes
	 */
	public List<String> getVideoAssetTypes() {
		return videoAssetTypes;
	}
	
	/**
	 * Get the setting to use to decide whether to activate the sites tab in Title view
	 * 
	 * @return The sites feature active flag
	 */
	public boolean isSitesFeatureActive() {
		return this.sitesFeatureActive;
	}

	
	/**
	 * Get the setting to use to decide whether user has license for image editing
	 * 
	 * @return isLicensed flag 
	 */
	public boolean isLicensedForImageEditing() {
		return this.licensedForImageEditing;
	}

	/**
	 * Get the setting to use to decide whether user has license for video preview
	 * 
	 * @return isLicensed flag 
	 */
	public boolean isLicensedForVideoPreview() {
		return this.licensedForVideoPreview;
	}

	/**
	 * Get the setting to use to decide whether user has license for category management
	 * @return
	 */
	public boolean isLicensedForCategoryManagement() {
		return this.licensedForCategoryManagement;
	}
	
	/**
	 * Get the setting to use to decide whether user has license for metadata enhancement
	 * @return
	 */
	public boolean isLicensedForMetadataEnhancement() {
		return this.licensedForMetadataEnhancement;
	}

	
	/*
	 * Get the integer value for a property
	 */
	private Integer getIntegerValue(String property) {
		String value = info.get(property);
		if (value != null) {
			try {
				return new Integer(value);
			} catch (NumberFormatException e) {
			}
		}

		return null;
	}

	/*
	 * Get the boolean value for a property
	 */
	private boolean getBooleanValue(String property) {
		return Boolean.parseBoolean(info.get(property));
	}

	
	// ========================================================================
	// ===================== WIDGET FACTORIES
	// ========================================================================

	/**
	 * Portlet Factory that maintains the single portlet instance.
	 */
	private static final class GenericPortletFactory implements PortletFactory {
		private Portlet portlet;
		private ContentComponent contentComponent;

		public GenericPortletFactory(Portlet portlet, ContentComponent contentComponent) {
			this.portlet = portlet;
			this.contentComponent = contentComponent;
		}

		@Override
		public Portlet getInstance() {
			return this.portlet;
		}

		@Override
		public void release(Portlet widget) {
			this.portlet = null;
		}

                @Override
                public Component getComponent() {
                    return contentComponent;
                }
	}


        @Override
        public String getName() {
            return "CONTENT";
        }
    
        @Override
        public String getDisplayName() {
            return constants.componentDisplayName();
        }

		public Boolean getHasMPWithTracking() {
			return hasMPWithTracking;
		}

		public void setHasMPWithTracking(Boolean hasMPWithTracking) {
			this.hasMPWithTracking = hasMPWithTracking;
		}
		private void setPitchScheduleOptions() {
			pitchService.hasMPWithTrackingSites(new NeptuneAsyncCallback<Boolean>() {

				@Override
				public void onNeptuneFailure(Throwable caught) {
					
					
				}

				@Override
				public void onNeptuneSuccess(Boolean result) {
					setHasMPWithTracking(result);
					
					
				}
			});
			
		}
}

