/*
 * Created on May 4, 2010
 * 
 * (C) Copyright TANDBERG Television Inc.
 */

package com.tandbergtv.cms.portal.content.client;


/**
 * The permissions used by the content component, and verification of the current user permissions
 * 
 * @author Vijay Silva
 */
public final class Permissions {

	/* Cannot instantiate */
	private Permissions() {
	}

	/**
	 * View permission for a title
	 */
	public static final String TITLE_VIEW = "AssetManagement_View";

	/**
	 * Create permission for a title
	 */
	public static final String TITLE_CREATE = "AssetManagement_Create";

	/**
	 * Modify permission for a title
	 */
	public static final String TITLE_MODIFY = "AssetManagement_Modify";

	/**
	 * Delete permission for a title
	 */
	public static final String TITLE_DELETE = "AssetManagement_Delete";
	
	/**
	 * Modify permission for a title list
	 */
	public static final String TITLELIST_MODIFY = "AssetListManagement_Modify";	

	/**
	 * Create permission for a work order
	 */
	public static final String WORKORDER_CREATE = "WorkOrderManagement_Create";

	/**
	 * Distribution permission for a site
	 */
	public static final String DISTRIBUTE = "Sites_Distribute";
	/**
	 * Target permission for a site
	 */
	public static final String SITE_TARGET = "Sites_Target";

	/**
	 * Target permission for a site
	 */
	public static final String USER_VIEW = "UserManagement_View";
	
	/**
	 * View permission for a content class
	 */
	public static final String CONTENT_CLASS_VIEW = "ContentClassManagement_View";

	/**
	 * Create permission for a content class
	 */
	public static final String CONTENT_CLASS_CREATE = "ContentClassManagement_Create";

	/**
	 * Modify permission for a content class
	 */
	public static final String CONTENT_CLASS_MODIFY = "ContentClassManagement_Modify";

	/**
	 * Delete permission for a content class
	 */
	public static final String CONTENT_CLASS_DELETE = "ContentClassManagement_Delete";
	
	/**
	 * View permission for a lookup key
	 */
	public static final String LOOKUP_KEY_VIEW = "LookupKeyManagement_View";
	
	/**
	 * Create permission for a lookup key
	 */
	public static final String LOOKUP_KEY_CREATE = "LookupKeyManagement_Create";

	/**
	 * Modify permission for a lookup key
	 */
	public static final String LOOKUP_KEY_MODIFY = "LookupKeyManagement_Modify";

	public static final String METADATA_CONFIG_VIEW = "MetadataConfiguration_View";
	public static final String METADATA_CONFIG_CREATE = "MetadataConfiguration_Create";
	public static final String METADATA_CONFIG_DELETE = "MetadataConfiguration_Delete";

	public static final String CUSTOMFIELDS_VIEW = "CustomFieldsAdministration_View";
	public static final String CUSTOMFIELDS_ADMINISTER = "CustomFieldsAdministration_Administer" +
			"" +
			"";



	
}
